/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.functions.prs;

import com.google.common.collect.Lists;
import com.xdja.csagent.engine.CSEngine;
import com.xdja.csagent.engine.IRoutePacketListener;
import com.xdja.csagent.engine.plugins.IConnectionPlugin;
import com.xdja.csagent.webui.base.bean.AppPropBean;
import com.xdja.csagent.webui.base.entity.AgentParam;
import com.xdja.csagent.webui.base.manager.AgentManager;
import com.xdja.csagent.webui.base.manager.AppPropConst;
import com.xdja.csagent.webui.base.manager.AppPropManager;
import com.xdja.csagent.webui.base.utils.TestConfigTools;
import com.xdja.csagent.webui.functions.prs.dao.AccessLogDao;
import com.xdja.csagent.webui.functions.prs.manager.AccessLogManager;
import com.xdja.csagent.webui.functions.prs.manager.impl.AccessLogManagerImpl;
import com.xdja.csagent.webui.functions.prs.plugins.AccessLogProcessPlugin;
import com.xdja.csagent.webui.functions.prs.plugins.PrsAuthenticationPlugin;
import com.xdja.csagent.webui.functions.prs.routeListener.AccessLogForwardPacketListener;
import com.xdja.csagent.webui.functions.prs.routeListener.ConfigSyncBackendPacketListener;
import com.xdja.csagent.webui.functions.prs.routeListener.ConfigSyncFrontendPacketListener;
import com.xdja.prs.authentication.Configs;
import com.xdja.prs.authentication.Consts;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PrsIntegration {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private AgentManager agentManager;
    @Resource
    private AppPropManager appPropManager;

    private List<AgentParam> getDefaultAgentServiceList() {
        Integer socksProxyPort;
        ArrayList rst = Lists.newArrayList();
        Integer httpProxyPort = this.appPropManager.findOne(AppPropConst.INTEGRATE_PRS_SELF_HTTP_PROXY_PORT).getInt();
        if (httpProxyPort != null && httpProxyPort > 0) {
            AgentParam one = new AgentParam();
            one.setNote("PRS\u96c6\u6210-HTTP\u4ee3\u7406");
            one.setBelongGroup(1);
            one.setAgentType(Integer.valueOf(3));
            one.setRouteLocal(Integer.valueOf(0));
            one.setAgentPort(httpProxyPort);
            one.setId("system-prs-http-proxy");
            rst.add(one);
        }
        if ((socksProxyPort = this.appPropManager.findOne(AppPropConst.INTEGRATE_PRS_SELF_SOCKS_PROXY_PORT).getInt()) != null && socksProxyPort > 0) {
            AgentParam one = new AgentParam();
            one.setNote("PRS\u96c6\u6210-SOCKS5\u4ee3\u7406");
            one.setBelongGroup(1);
            one.setAgentType(Integer.valueOf(4));
            one.setRouteLocal(Integer.valueOf(0));
            one.setAgentPort(socksProxyPort);
            one.setId("system-prs-socks-proxy");
            rst.add(one);
        }
        return rst;
    }

    public void config(AgentManager agentManager, CSEngine engine) throws Exception {
        Integer prsNetLocation;
        for (AgentParam one : this.getDefaultAgentServiceList()) {
            if (!agentManager.hasAgentParam(one.getId())) {
                agentManager.addAgentParam(one);
            }
            agentManager.startAgent(one.getId());
        }
        if (TestConfigTools.isEnable()) {
            this.logger.info("#test# is enable !");
            if (TestConfigTools.isAuthenticationEnable()) {
                this.logger.info("#test# enable auth");
                this.configPrsAuthentication(engine);
            }
            prsNetLocation = this.appPropManager.findOne(AppPropConst.NETWORK_LOCATION).getInt();
            if (TestConfigTools.isResourceSyncEnable()) {
                this.logger.info("#test# enable resource sync");
                this.configResourceSync(engine, prsNetLocation);
            }
            if (TestConfigTools.isAccessLogEnable()) {
                this.logger.info("#test# enable accessLog");
                this.configResourceAccessLog(engine, prsNetLocation);
            }
        } else {
            this.configPrsAuthentication(engine);
            prsNetLocation = this.appPropManager.findOne(AppPropConst.NETWORK_LOCATION).getInt();
            this.configResourceSync(engine, prsNetLocation);
            this.configResourceAccessLog(engine, prsNetLocation);
        }
    }

    private void configResourceAccessLog(CSEngine agentServer, Integer prsNetLocation) throws Exception {
        AccessLogManagerImpl accessLogManager = null;
        if (2 != prsNetLocation && 1 == prsNetLocation) {
            AccessLogDao.AccessLogProp prop = new AccessLogDao.AccessLogProp();
            prop.setDriverClassName(this.appPropManager.findOne(AppPropConst.INTEGRATE_PRS_AUTH_PAMS_JDBC_DRIVER).getValue());
            prop.setUrl(this.appPropManager.findOne(AppPropConst.INTEGRATE_PRS_AUTH_PAMS_JDBC_URL).getValue());
            prop.setUsername(this.appPropManager.findOne(AppPropConst.INTEGRATE_PRS_AUTH_PAMS_JDBC_USERNAME).getValue());
            prop.setPassword(this.appPropManager.findOne(AppPropConst.INTEGRATE_PRS_AUTH_PAMS_JDBC_PASSWORD).getValue());
            accessLogManager = new AccessLogManagerImpl(prop);
            this.logger.info("register PrsAccessLogForwardListener");
            AccessLogForwardPacketListener accessLogRouteListener = new AccessLogForwardPacketListener((AccessLogManager)accessLogManager);
            agentServer.addRoutePacketListener((IRoutePacketListener)accessLogRouteListener);
        }
        this.logger.info("register AccessLogProcessPlugin");
        AccessLogProcessPlugin accessLogProcessPlugin = new AccessLogProcessPlugin(accessLogManager);
        agentServer.addRoutePacketListener(accessLogProcessPlugin.getRoutePacketListener());
        agentServer.addConnectionPlugin((IConnectionPlugin)accessLogProcessPlugin);
    }

    private void configResourceSync(CSEngine agentServer, Integer prsNetLocation) {
        if (2 == prsNetLocation) {
            this.logger.info("register ConfigSyncFrontendPacketListener");
            agentServer.addRoutePacketListener((IRoutePacketListener)new ConfigSyncFrontendPacketListener(this.agentManager));
        } else if (1 == prsNetLocation) {
            this.logger.info("register ConfigSyncBackendPacketListener");
            int resourceSyncPeriod = this.appPropManager.findOne(AppPropConst.INTEGRATE_PRS_RESOURCE_SYNC_PERIOD_MILLIS).getInt();
            agentServer.addRoutePacketListener((IRoutePacketListener)new ConfigSyncBackendPacketListener(this.agentManager, resourceSyncPeriod));
        }
    }

    private void configPrsAuthentication(CSEngine agentServer) {
        this.logger.info("register PrsAuthenticationPlugin");
        Properties props = new Properties();
        props.put("auth.authType", Consts.AuthenticationType.CSAGENT.name());
        props.put("auth.netLocation", this.quick(AppPropConst.NETWORK_LOCATION));
        props.put("auth.syncUrl", this.quick(AppPropConst.INTEGRATE_PRS_AUTH_SYNC_URL));
        props.put("auth.syncPeriod", this.quick(AppPropConst.INTEGRATE_PRS_AUTH_SYNC_PERIOD_MILLIS));
        props.put("auth.gatewayIp", this.quick(AppPropConst.INTEGRATE_PRS_AUTH_GATEWAY_IP_LIST));
        props.put("auth.gatewayPort", this.quick(AppPropConst.INTEGRATE_PRS_AUTH_GATEWAY_PORT_LIST));
        props.put("auth.httpProxyPort", this.quick(AppPropConst.INTEGRATE_PRS_AUTH_HTTP_PROXY_PORT));
        props.put("auth.httpProxyIp", this.quick(AppPropConst.INTEGRATE_PRS_AUTH_HTTP_PROXY_HOST));
        props.put("auth.httpPort", this.quick(AppPropConst.INTEGRATE_PRS_AUTH_RECEIVE_HTTP_DATA_PORT));
        props.put("auth.gatewayReceivePort", this.quick(AppPropConst.INTEGRATE_PRS_AUTH_RECEIVE_GATEWAY_PORT));
        props.put("auth.mdp.jdbc.url", this.quick(AppPropConst.INTEGRATE_PRS_AUTH_MDP_JDBC_URL));
        props.put("auth.prs.jdbc.url", this.quick(AppPropConst.INTEGRATE_PRS_AUTH_PRS_JDBC_URL));
        props.put("auth.pams.jdbc.url", this.quick(AppPropConst.INTEGRATE_PRS_AUTH_PAMS_JDBC_URL));
        props.put("auth.mdp.jdbc.driver", this.quick(AppPropConst.INTEGRATE_PRS_AUTH_MDP_JDBC_DRIVER));
        props.put("auth.prs.jdbc.driver", this.quick(AppPropConst.INTEGRATE_PRS_AUTH_PRS_JDBC_DRIVER));
        props.put("auth.pams.jdbc.driver", this.quick(AppPropConst.INTEGRATE_PRS_AUTH_PAMS_JDBC_DRIVER));
        props.put("auth.mdp.jdbc.username", this.quick(AppPropConst.INTEGRATE_PRS_AUTH_MDP_JDBC_USERNAME));
        props.put("auth.prs.jdbc.username", this.quick(AppPropConst.INTEGRATE_PRS_AUTH_PRS_JDBC_USERNAME));
        props.put("auth.pams.jdbc.username", this.quick(AppPropConst.INTEGRATE_PRS_AUTH_PAMS_JDBC_USERNAME));
        props.put("auth.mdp.jdbc.password", this.quick(AppPropConst.INTEGRATE_PRS_AUTH_MDP_JDBC_PASSWORD));
        props.put("auth.prs.jdbc.password", this.quick(AppPropConst.INTEGRATE_PRS_AUTH_PRS_JDBC_PASSWORD));
        props.put("auth.pams.jdbc.password", this.quick(AppPropConst.INTEGRATE_PRS_AUTH_PAMS_JDBC_PASSWORD));
        try {
            agentServer.addConnectionPlugin((IConnectionPlugin)new PrsAuthenticationPlugin(new Configs(props)));
        }
        catch (Exception e) {
            this.logger.error("register PrsAuthenticationPlugin error", (Throwable)e);
        }
    }

    public String quick(AppPropConst prop) {
        AppPropBean tmp = this.appPropManager.findOne(prop);
        if (tmp == null) {
            return "";
        }
        return tmp.getValue() == null ? "" : tmp.getValue();
    }
}

