/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.functions.prs.action;

import com.google.common.collect.Lists;
import com.xdja.common.util.FreeworkDateEditor;
import com.xdja.common.util.JsonResult;
import com.xdja.csagent.webui.base.action.BaseAction;
import com.xdja.csagent.webui.base.manager.AppPropConst;
import com.xdja.csagent.webui.base.manager.AppPropManager;
import com.xdja.csagent.webui.functions.prs.PrsModuleStatus;
import com.xdja.csagent.webui.functions.system.bean.InfoBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="prsInfoAction")
@RequestMapping(value={"prs/info"})
public class InfoAction
extends BaseAction {
    @Resource
    private AppPropManager appPropManager;

    @RequestMapping(value={"index"})
    public void index() {
    }

    @RequestMapping(value={"show"})
    @ResponseBody
    public JsonResult<List<InfoBean>> show() {
        try {
            ArrayList rst = Lists.newArrayList();
            Integer netLocation = this.appPropManager.findOne(AppPropConst.NETWORK_LOCATION).getInt();
            this.extractAuthStatus((List)rst, netLocation);
            this.extractResSyncStatus((List)rst, netLocation);
            this.extractAccessLogStatus((List)rst, netLocation);
            return JsonResult.success((Object)rst);
        }
        catch (Exception e) {
            this.logger.error("show prs status info error", (Throwable)e);
            return JsonResult.failure((String)e.getMessage());
        }
    }

    private String humanShowRunning(boolean running) {
        return running ? "\u5df2\u542f\u52a8" : "\u672a\u542f\u52a8";
    }

    private void extractAccessLogStatus(List<InfoBean> rst, Integer netLocation) {
        String type = "log";
        rst.add(new InfoBean("\u8bbf\u95ee\u65e5\u5fd7-\u672c\u673a\u4ea7\u751f\u6570\u91cf", PrsModuleStatus.AccessLog_GenerateCount.getNumber() + "", type));
        rst.add(new InfoBean("\u8bbf\u95ee\u65e5\u5fd7-\u672c\u673a\u4ea7\u751f\u65f6\u95f4\u6233", this.humanShowTime(PrsModuleStatus.AccessLog_GenerateCount.getLastUpdateTime()), type));
        if (netLocation.equals(1)) {
            rst.add(new InfoBean("\u8bbf\u95ee\u65e5\u5fd7-\u6536\u5230\u8def\u7531\u8f6c\u53d1\u6570\u91cf", PrsModuleStatus.AccessLog_ReceiveCount.getNumber() + "", type));
            rst.add(new InfoBean("\u8bbf\u95ee\u65e5\u5fd7-\u6536\u5230\u8def\u7531\u8f6c\u53d1\u65f6\u95f4\u6233", this.humanShowTime(PrsModuleStatus.AccessLog_ReceiveCount.getLastUpdateTime()), type));
            rst.add(new InfoBean("\u8bbf\u95ee\u65e5\u5fd7-\u5165\u5e93\u6570\u91cf", PrsModuleStatus.AccessLog_StoreCount.getNumber() + "", type));
            rst.add(new InfoBean("\u8bbf\u95ee\u65e5\u5fd7-\u5165\u5e93\u65f6\u95f4\u6233", this.humanShowTime(PrsModuleStatus.AccessLog_StoreCount.getLastUpdateTime()), type));
        }
    }

    private void extractResSyncStatus(List<InfoBean> rst, Integer netLocation) {
        String type = "res";
        rst.add(new InfoBean("\u8d44\u6e90\u540c\u6b65-\u8d44\u6e90\u6700\u540e\u66f4\u65b0\u65f6\u95f4\u6233", this.humanShowTime(PrsModuleStatus.ResourceSync_ResourceLastUpdateTime.getTime()), type));
        rst.add(new InfoBean("\u8d44\u6e90\u540c\u6b65-\u6570\u636e\u5305\u6700\u540e\u63a5\u6536\u65f6\u95f4", this.humanShowTime(PrsModuleStatus.ResourceSync_ReceiveLastPacketTime.getTime()), type));
        if (netLocation.equals(1)) {
            rst.add(new InfoBean("\u8d44\u6e90\u540c\u6b65-\u5b9a\u65f6\u540c\u6b65\u89e6\u53d1\u65f6\u95f4\u6233", this.humanShowTime(PrsModuleStatus.ResourceSync_LastScheduleTime.getTime()), type));
        }
    }

    private String humanShowTime(long lastUpdateTime) {
        return FreeworkDateEditor.formatYYYYMMDDHHMMSS((Object)new Date(lastUpdateTime));
    }

    private String humanShowSuccess(boolean success) {
        return success ? "\u6210\u529f" : "\u5931\u8d25";
    }

    private void extractAuthStatus(List<InfoBean> rst, Integer netLocation) {
        String type = "auth";
        rst.add(new InfoBean("\u9274\u6743-\u5931\u8d25\u6b21\u6570", PrsModuleStatus.Auth_AuthenticateFailureCount.getNumber() + "", type));
        rst.add(new InfoBean("\u9274\u6743-\u5931\u8d25\u65f6\u95f4\u6233", this.humanShowTime(PrsModuleStatus.Auth_AuthenticateFailureCount.getLastUpdateTime()), type));
        rst.add(new InfoBean("\u9274\u6743-\u6210\u529f\u6b21\u6570", PrsModuleStatus.Auth_AuthenticateSuccessCount.getNumber() + "", type));
        rst.add(new InfoBean("\u9274\u6743-\u6210\u529f\u65f6\u95f4\u6233", this.humanShowTime(PrsModuleStatus.Auth_AuthenticateSuccessCount.getLastUpdateTime()), type));
    }
}

