/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.functions.prs.action;

import com.xdja.csagent.engine.Utils;
import com.xdja.csagent.webui.functions.prs.bean.PrsAgentParamBean;
import com.xdja.csagent.webui.functions.prs.manager.PrsManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
public class PrsManageAction {
    Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PrsManager prsManager;
    public static final int FAILURE = 0;
    public static final int SUCCESS = 1;

    @RequestMapping(value={"/manage/agentService/delete"})
    @ResponseBody
    public Map<String, Object> delete(String resourceId) {
        this.log.info("\u5220\u9664\u4ee3\u7406\u670d\u52a1{}", (Object)resourceId);
        HashMap<String, Object> rst = new HashMap<String, Object>();
        try {
            this.prsManager.assertPrsManagerEnable();
            this.prsManager.deletePrsAgentParam(resourceId);
            rst.put("rst", 1);
            rst.put("msg", "success");
        }
        catch (Exception e) {
            this.log.error("\u5220\u9664\u4ee3\u7406\u670d\u52a1\u51fa\u9519\uff01", (Throwable)e);
            rst.put("rst", 0);
            rst.put("msg", PrsManageAction.getErrMsg((Exception)e));
        }
        return rst;
    }

    @RequestMapping(value={"/manage/agentService/list"})
    @ResponseBody
    public Map<String, Object> list() {
        this.prsManager.assertPrsManagerEnable();
        HashMap<String, Object> rst = new HashMap<String, Object>();
        try {
            this.log.info("\u83b7\u53d6\u5f53\u524d\u4ee3\u7406\u670d\u52a1\u5668\u5217\u8868");
            List list = this.prsManager.getPrsAgentParamList();
            rst.put("list", list);
            rst.put("rst", 1);
            rst.put("msg", "success");
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
            rst.put("rst", 0);
            rst.put("msg", PrsManageAction.getErrMsg((Exception)e));
        }
        return rst;
    }

    @RequestMapping(value={"/manage/agentService/netConnectTest"})
    @ResponseBody
    public Map<String, Object> netConnectTest(String resourceId, Integer location, Integer agentType, String host, Integer port, String contextPath, Integer timeout) {
        this.log.info("\u6d4b\u8bd5\u7f51\u7edc\u8fde\u63a5");
        HashMap<String, Object> rst = new HashMap<String, Object>();
        try {
            this.prsManager.assertPrsManagerEnable();
            boolean connected = this.prsManager.netConnect(resourceId, location, agentType, host, port, contextPath, timeout);
            if (connected) {
                rst.put("rst", 1);
                rst.put("msg", "success");
            } else {
                rst.put("rst", 0);
                rst.put("msg", "can't connected");
            }
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
            rst.put("rst", 0);
            rst.put("msg", PrsManageAction.getErrMsg((Exception)e));
        }
        return rst;
    }

    @RequestMapping(value={"/manage/agentService/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> saveOrUpdate(PrsAgentParamBean bean) {
        this.log.info("\u4fdd\u5b58\u6216\u66f4\u65b0\u4ee3\u7406\u670d\u52a1{}", (Object)bean.toString());
        HashMap<String, Object> rst = new HashMap<String, Object>();
        try {
            this.prsManager.assertPrsManagerEnable();
            Assert.hasText((String)bean.getResourceDesc(), (String)"resourceDesc");
            Assert.notNull((Object)bean.getStatus(), (String)"status");
            Assert.isTrue((boolean)Arrays.asList(0, 1).contains(bean.getStatus()), (String)"status");
            Assert.notNull((Object)bean.getAgentType(), (String)"agentType");
            Assert.isTrue((boolean)Arrays.asList(2, 1, 3).contains(bean.getAgentType()), (String)"agentType");
            Assert.notNull((Object)bean.getLocation(), (String)"location");
            Assert.isTrue((boolean)Arrays.asList(1, 2).contains(bean.getLocation()), (String)"location");
            if (bean.getScope() == null) {
                bean.setScope(Integer.valueOf(0));
            }
            Assert.isTrue((boolean)Arrays.asList(0, 1, 2).contains(bean.getScope()), (String)"scope");
            Integer agentPort = bean.getAgentPort();
            Assert.notNull((Object)agentPort, (String)"agentPort");
            Assert.isTrue((agentPort == -1 || agentPort > 1024 && agentPort < 65535 ? 1 : 0) != 0, (String)"agentPort");
            if (Arrays.asList(2, 1).contains(bean.getAgentType())) {
                Integer originalPort = bean.getOriginalPort();
                Assert.notNull((Object)originalPort, (String)"originalPort");
                Assert.isTrue((originalPort > 0 && originalPort < 65535 ? 1 : 0) != 0, (String)"originalPort");
                Assert.hasText((String)bean.getOriginalHost(), (String)"originalHost");
            }
            if (2 == bean.getAgentType() && !StringUtils.hasText((String)bean.getAgentContextPath())) {
                bean.setAgentContextPath(Utils.fixContextPath((String)bean.getResourceId()));
            }
            if (bean.getOriginalContextPath() == null) {
                bean.setOriginalContextPath("");
            }
            this.prsManager.saveOrUpdatePrsAgentParam(bean);
            rst.put("rst", 1);
            rst.put("msg", "success");
            rst.put("resourceId", bean.getResourceId());
            rst.put("agentPort", bean.getAgentPort());
            rst.put("agentContextPath", bean.getAgentContextPath());
        }
        catch (Exception e) {
            this.log.error("\u4fdd\u5b58\u6216\u66f4\u65b0\u4ee3\u7406\u670d\u52a1\u51fa\u9519", (Throwable)e);
            rst.put("rst", 0);
            rst.put("msg", PrsManageAction.getErrMsg((Exception)e));
        }
        return rst;
    }

    public static String getErrMsg(Exception e) {
        return e.getClass().getSimpleName() + ":" + e.getMessage();
    }
}

