/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.functions.prs.dao;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.io.Resources;
import com.xdja.csagent.webui.functions.prs.bean.AccessLogBean;
import com.xdja.csagent.webui.functions.prs.dao.AccessLogDao;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class AccessLogDao {
    public static final String PRS_ACCESS_LOG_SQL = "/prs/accessLog.sql";
    public static final String TABLE_NAME = "T_CS_ACCESS_LOG";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BasicDataSource dataSource;
    private NamedParameterJdbcTemplate jdbcTemplate;

    public AccessLogDao(AccessLogProp accessLogProps) {
        this.dataSource = this.initDataSource(accessLogProps);
        this.checkOrCreateTable(this.jdbcTemplate);
    }

    private void checkOrCreateTable(NamedParameterJdbcTemplate jdbc) {
        this.logger.info("check table {}", (Object)TABLE_NAME);
        int i = ((Number)jdbc.getJdbcOperations().queryForObject("SELECT COUNT(*) FROM User_Tables WHERE table_name = 'T_CS_ACCESS_LOG'", Number.class)).intValue();
        if (i == 0) {
            this.logger.info("table {} not exist, will create.", (Object)TABLE_NAME);
            try {
                URL sqlResource = this.getClass().getResource(PRS_ACCESS_LOG_SQL);
                String sql = Resources.toString((URL)sqlResource, (Charset)Charsets.UTF_8);
                jdbc.getJdbcOperations().execute(sql);
                this.logger.info("create table {} success", (Object)TABLE_NAME);
            }
            catch (Exception e) {
                this.logger.error("create table {} failure", (Object)TABLE_NAME, (Object)e);
                Throwables.propagate((Throwable)e);
            }
        }
    }

    private BasicDataSource initDataSource(AccessLogProp accessLogProps) {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(accessLogProps.getDriverClassName());
        dataSource.setUrl(accessLogProps.getUrl());
        dataSource.setUsername(accessLogProps.getUsername());
        dataSource.setPassword(accessLogProps.getPassword());
        dataSource.setDefaultAutoCommit(true);
        dataSource.setInitialSize(1);
        dataSource.setMaxActive(3);
        dataSource.setMaxIdle(2);
        dataSource.setMinIdle(1);
        dataSource.setTestWhileIdle(true);
        dataSource.setValidationQuery("select 1 from dual");
        this.jdbcTemplate = new NamedParameterJdbcTemplate((DataSource)dataSource);
        return dataSource;
    }

    public void clean() {
        if (this.dataSource != null) {
            try {
                this.dataSource.close();
            }
            catch (SQLException e) {
                LoggerFactory.getLogger(AccessLogDao.class).info("Close AccessLog DataSource error", (Throwable)e);
            }
        }
    }

    public void storeToDb(AccessLogBean take) {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into T_CS_ACCESS_LOG ");
        sql.append("(ID,AGENT_SERVICE_ID,ACCESS_USER_TYPE,ACCESS_USER,DEST_ADDRESS,IS_SUCCESS,NETWORK_FLOW,CONSUME_TIME,ACCESS_TIMESTAMP)");
        sql.append("values");
        sql.append("(:id,:agentServiceId,:accessUserType,:accessUser,:destAddress,:isSuccess,:networkFlow,:consumeTime,:accessTimestamp)");
        this.jdbcTemplate.update(sql.toString(), (SqlParameterSource)new BeanPropertySqlParameterSource((Object)take));
    }
}

