/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.functions.prs.manager.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xdja.common.util.NetworkTester;
import com.xdja.csagent.engine.Utils;
import com.xdja.csagent.webui.base.entity.AgentParam;
import com.xdja.csagent.webui.base.manager.AgentManager;
import com.xdja.csagent.webui.base.manager.AppPropConst;
import com.xdja.csagent.webui.base.manager.AppPropManager;
import com.xdja.csagent.webui.base.utils.PortRangeUtils;
import com.xdja.csagent.webui.exception.InvalidAgentPortException;
import com.xdja.csagent.webui.functions.prs.bean.PrsAgentParamBean;
import com.xdja.csagent.webui.functions.prs.manager.PrsManager;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class PrsManagerImpl
implements PrsManager {
    Logger log = LoggerFactory.getLogger(this.getClass());
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AgentManager agentManager;
    @Resource
    private AppPropManager appPropManager;

    private Integer autoGeneratePort() {
        List currents = this.agentManager.getAgentParamList();
        if (currents.size() > 0) {
            List ports = Lists.transform((List)currents, (Function)new /* Unavailable Anonymous Inner Class!! */);
            for (int i = ((Integer)PortRangeUtils.CS_OUT.lowerEndpoint()).intValue(); i < (Integer)PortRangeUtils.CS_OUT.upperEndpoint(); ++i) {
                if (ports.contains(i)) continue;
                return i;
            }
            this.logger.error("\u65e0\u6cd5\u81ea\u52a8\u5206\u914d\u7aef\u53e3");
            throw new IllegalStateException("\u65e0\u6cd5\u81ea\u52a8\u5206\u914d\u7aef\u53e3");
        }
        return (Integer)PortRangeUtils.CS_OUT.lowerEndpoint();
    }

    public void assertPrsManagerEnable() {
        Assert.isTrue((this.appPropManager.findOne(AppPropConst.INTEGRATE_PRS_ENABLE).getInt() == 1 ? 1 : 0) != 0, (String)"prs\u96c6\u6210\u672a\u5f00\u542f");
    }

    public void deletePrsAgentParam(String resourceId) throws Exception {
        this.agentManager.deleteAgentParam(resourceId);
        if (this.agentManager.isAgentRun(resourceId)) {
            this.agentManager.stopAgent(resourceId);
        }
    }

    public List<PrsAgentParamBean> getPrsAgentParamList() {
        List tmp = this.agentManager.getAgentParamList();
        Iterable prsAgentParams = Iterables.filter((Iterable)tmp, (Predicate)new /* Unavailable Anonymous Inner Class!! */);
        Iterable prsAgentParamBeanIterable = Iterables.transform((Iterable)prsAgentParams, (Function)new /* Unavailable Anonymous Inner Class!! */);
        return Lists.newLinkedList((Iterable)prsAgentParamBeanIterable);
    }

    public boolean netConnect(String resourceId, Integer location, Integer agentType, String host, Integer port, String contextPath, Integer timeout) {
        AgentParam agent = null;
        if (StringUtils.hasText((String)resourceId)) {
            agent = this.agentManager.getAgentParam(resourceId);
        }
        if (timeout == null || timeout < 1) {
            timeout = 10;
        }
        if (agent != null) {
            host = agent.getDestHost();
            port = agent.getDestPort();
        }
        Assert.hasText((String)host, (String)"host");
        Assert.notNull((Object)port, (String)"port");
        Assert.notNull((Object)location, (String)"location");
        Integer networkLocation = this.appPropManager.findOne(AppPropConst.NETWORK_LOCATION).getInt();
        if (networkLocation.equals(location)) {
            this.logger.debug("\u672c\u5730\u7f51\u7edc\uff0c\u76f4\u63a5\u8fde\u63a5\u6d4b\u8bd5");
            return NetworkTester.connectDirectTest((String)host, (int)port, (int)(timeout * 1000));
        }
        this.logger.debug("\u8fdc\u7a0b\u7f51\u7edc\uff0c\u901a\u8fc7socks\u4ee3\u7406\u8fdb\u884c\u8fde\u63a5\u6d4b\u8bd5");
        Integer socksPort = this.appPropManager.findOne(AppPropConst.INTEGRATE_PRS_SELF_SOCKS_PROXY_PORT).getInt();
        return NetworkTester.connectProxyTest((String)host, (int)port, (int)(timeout * 1000), (String)"127.0.0.1", (int)socksPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOrUpdatePrsAgentParam(PrsAgentParamBean bean) throws Exception {
        Integer networkLocation = this.appPropManager.findOne(AppPropConst.NETWORK_LOCATION).getInt();
        AgentParam acb = PrsAgentParamBean.transferToAgentConfig((PrsAgentParamBean)bean, (Integer)networkLocation);
        PrsManagerImpl prsManagerImpl = this;
        synchronized (prsManagerImpl) {
            if (StringUtils.hasText((String)acb.getId()) && this.agentManager.getAgentParam(acb.getId()) != null) {
                if (!this.agentManager.isAgentPortAvailable(acb.getAgentPort(), acb.getAgentType(), acb.getId())) {
                    throw new InvalidAgentPortException(acb.getAgentPort().toString());
                }
                this.agentManager.updateAgentParam(acb);
            } else {
                if (!StringUtils.hasText((String)acb.getId())) {
                    acb.setId(Utils.uuid());
                }
                if (acb.getAgentPort() == null || acb.getAgentPort() < 0) {
                    Integer autoPort = this.autoGeneratePort();
                    acb.setAgentPort(autoPort);
                }
                if (2 == acb.getAgentType() && !StringUtils.hasText((String)acb.getAgentContext())) {
                    acb.setAgentContext("/" + acb.getId());
                }
                if (!this.agentManager.isAgentPortAvailable(acb.getAgentPort(), acb.getAgentType(), null)) {
                    throw new InvalidAgentPortException(acb.getAgentPort().toString());
                }
                if (!this.agentManager.isContextPathAvailabel(acb.getAgentPort(), acb.getAgentContext(), null)) {
                    throw new IllegalArgumentException("agentContextPath");
                }
                this.agentManager.addAgentParam(acb);
            }
        }
        if (acb.getStatus() == 1) {
            this.agentManager.startAgent(acb.getId());
        } else {
            this.agentManager.stopAgent(acb.getId());
        }
        bean.setResourceId(acb.getId());
        bean.setAgentPort(acb.getAgentPort());
        bean.setAgentContextPath(acb.getAgentContext());
    }
}

