/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.functions.prs.plugins;

import com.xdja.csagent.engine.Agent;
import com.xdja.csagent.engine.AgentConnection;
import com.xdja.csagent.engine.AgentMeta;
import com.xdja.csagent.engine.plugins.IConnectionPlugin;
import com.xdja.csagent.webui.base.bean.DefaultAgentMeta;
import com.xdja.csagent.webui.functions.prs.PrsModuleStatus;
import com.xdja.prs.authentication.Configs;
import com.xdja.prs.authentication.IAuthenticate;
import com.xdja.prs.authentication.PrsAuthentication;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrsAuthenticationPlugin
implements IConnectionPlugin {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IAuthenticate authenticate;
    private PrsAuthentication prsAuthentication;

    public PrsAuthenticationPlugin(Configs configs) throws Exception {
        this.logger.info("initialize PrsAuthenticationPlugin");
        this.prsAuthentication = new PrsAuthentication(configs);
        this.authenticate = this.prsAuthentication.getAuthenticate();
    }

    public boolean activeIntercept(AgentConnection connection, AgentMeta config, Map<String, Object> context) {
        if (config != null && config instanceof DefaultAgentMeta && ((DefaultAgentMeta)config).getBelongGroup() != 3) {
            return false;
        }
        boolean rst = false;
        if (config != null && config.getAgentType() == 1) {
            String address = connection.remoteAddress().getAddress().getHostAddress();
            Integer port = connection.remoteAddress().getPort();
            boolean pass = this.authenticate.authenticate(context, address, port.intValue(), new Object[]{config.getId(), context});
            rst = this.loggerAndReturn(connection, pass);
        }
        this.recordStatus(rst);
        return rst;
    }

    public void applyNewConfig(AgentConnection connection, AgentMeta portConfig) {
    }

    public boolean httpRequestIntercept(AgentConnection connection, AgentMeta config, Map<String, Object> context, String destHost, int destPort, String destPath) {
        if (config != null && config instanceof DefaultAgentMeta && ((DefaultAgentMeta)config).getBelongGroup() != 3) {
            return false;
        }
        boolean rst = false;
        if (config != null && config.getAgentType() == 2) {
            String address = connection.remoteAddress().getAddress().getHostAddress();
            Integer port = connection.remoteAddress().getPort();
            boolean pass = this.authenticate.authenticate(context, address, port.intValue(), new Object[]{config.getId()});
            rst = this.loggerAndReturn(connection, pass);
        }
        this.recordStatus(rst);
        return rst;
    }

    private void recordStatus(boolean rst) {
        if (rst) {
            PrsModuleStatus.Auth_AuthenticateFailureCount.increment();
        } else {
            PrsModuleStatus.Auth_AuthenticateSuccessCount.increment();
        }
    }

    private boolean loggerAndReturn(AgentConnection connection, boolean pass) {
        if (pass) {
            this.logger.debug("prs authenticate pass !");
            return false;
        }
        this.logger.debug("prs authenticate failure !");
        connection.closeSync();
        return true;
    }

    public void onConnectOver(Agent agent, Map<String, Object> context, String destAddress, boolean success, long startTime, long endTime, int networkFlow) {
    }

    public void onPluginDestroy() {
        if (this.prsAuthentication != null) {
            try {
                this.prsAuthentication.stop();
            }
            catch (Exception e) {
                this.logger.error("PrsAuthentication stop error!", (Throwable)e);
            }
            this.prsAuthentication = null;
        }
    }
}

