/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.csagent.webui.functions.system.manager.impl;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xdja.common.util.page.Pagination;
import com.xdja.csagent.engine.Utils;
import com.xdja.csagent.webui.base.bean.UserBean;
import com.xdja.csagent.webui.base.bean.UserToMenuBean;
import com.xdja.csagent.webui.base.dao.ICSDao;
import com.xdja.csagent.webui.functions.system.manager.UserManager;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.encoding.ShaPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UserManagerImpl
implements UserManager {
    @Autowired
    private ICSDao dao;

    public void addUser(UserBean user, String roleId) {
        ShaPasswordEncoder shaPasswordEncoder = new ShaPasswordEncoder();
        String psw = shaPasswordEncoder.encodePassword(user.getPassword(), (Object)user.getName());
        user.setPassword(psw);
        user.setId(Utils.uuid());
        this.dao.saveUser(user);
    }

    public void delUser(String userId) {
        UserBean user = this.dao.findUser(userId);
        if (!user.getName().equals("superadmin")) {
            this.dao.deleteUser(userId);
        }
    }

    public void editUser(UserBean user, String roleId) {
        if (user == null || user.getId() == null) {
            return;
        }
        if (StringUtils.hasText((String)user.getPassword())) {
            ShaPasswordEncoder shaPasswordEncoder = new ShaPasswordEncoder();
            String psw = shaPasswordEncoder.encodePassword(user.getPassword(), (Object)user.getName());
            user.setPassword(psw);
        } else {
            UserBean old = this.dao.findUser(user.getId());
            user.setPassword(old.getPassword());
        }
        this.dao.updateUser(user);
    }

    public int getUserCountByName(String userName) {
        if (StringUtils.hasText((String)userName)) {
            return this.dao.countUserByName(userName);
        }
        return 0;
    }

    public List<UserToMenuBean> findMenuListByUser(String userId) {
        return this.dao.findUserToMenuByUser(userId);
    }

    public Set<String> findUserAuth(String userId) {
        List userToMenuByUser = this.dao.findUserToMenuByUser(userId);
        return Sets.newHashSet((Iterable)Iterables.transform((Iterable)userToMenuByUser, (Function)new /* Unavailable Anonymous Inner Class!! */));
    }

    public Pagination<UserBean> getUserList(UserBean user, Integer pageSize, Integer pageNo) {
        int totalCount = this.dao.countUser(user);
        Pagination pagination = new Pagination(pageNo, pageSize, totalCount);
        List list = this.dao.findUserList(user, pageSize, pageNo);
        pagination.setList(list);
        return pagination;
    }

    public boolean isNameAvailable(String name, String self) {
        UserBean userByName = this.dao.findUserByName(name);
        if (userByName == null) {
            return true;
        }
        return StringUtils.hasText((String)self) && userByName.getId().equals(self);
    }

    public void replaceUserAuthority(String userId, List<String> ids) {
        this.dao.deleteUserToMenuByUser(userId);
        List list = Lists.transform(ids, (Function)new /* Unavailable Anonymous Inner Class!! */);
        this.dao.saveUserToMenu(list);
    }

    public UserBean viewUser(UserBean user) {
        if (user == null || user.getId() == null) {
            return null;
        }
        return this.dao.findUser(user.getId());
    }
}

