ko.bindingHandlers.agentType = {
    update: function (element, valueAccessor) {
        var shouldDisplay = valueAccessor();
        var val = shouldDisplay();
        var result = val;
        if (val == 1) {
            result = "TCP转发";
        } else if (val == 2) {
            result = "URL转发";
        } else if (val == 3) {
            result = "HTTP代理";
        } else if (val == 4) {
            result = "SOCKS代理";
        } else if (val == 5) {
            result = "UDP转发";
        }
        $(element).html(result);
    }
};
ko.bindingHandlers.belongGroup = {
    update: function (element, valueAccessor) {
        var shouldDisplay = valueAccessor();
        var val = shouldDisplay();
        var result = val;
        if (val == 1) {
            result = "系统";
        } else if (val == 2) {
            result = "自定义";
        } else if (val == 3) {
            result = "PRS";
        } else {
            result = "未知";
        }
        $(element).html(result);
    }
};
ko.bindingHandlers.runState = {
    update: function (element, valueAccessor) {
        var shouldDisplay = valueAccessor();
        $(element).html(shouldDisplay() ? "<span style='color:green;'>运行中</span>" : "<span style='color: red;'>已停止</span>");
    }
};
ko.bindingHandlers.activeState = {
    update: function (element, valueAccessor) {
        var shouldDisplay = valueAccessor();
        var val = shouldDisplay();
        var text="";
        if(val=='start'){
            text="<span style='color:green;'>运行中</span>";
        }else if(val =='stop'){
            text="<span style='color: red;'>已停止</span>";
        }else if(val=='unavailable'){
            text="<span style='color: red;'>不可用</span>";
        }
        $(element).html(text);
    }
};
ko.bindingHandlers.routeLocal = {
    update: function (element, valueAccessor) {
        var shouldDisplay = valueAccessor();
        var val = shouldDisplay();
        var result = val;
        if (val == 1) {
            result = "本地";
        } else if (val == 0) {
            result = "远程";
        }
        $(element).html(result);
    }
};
ko.bindingHandlers.ipFilter = {
    update: function (element, valueAccessor) {
        var shouldDisplay = valueAccessor();
        var val = shouldDisplay();
        var result = val;
        if (val == 1) {
            result = "黑名单";
        } else if (val == 2) {
            result = "白名单";
        } else if (val == 0) {
            result = "未开启";
        }
        $(element).html(result);
    }
};
AgentType = {
    TcpForward: 1,
    URLForward: 2,
    HttpProxy: 3,
    Socks: 4,
    UdpForward: 5
};
ko.bindingHandlers.agentAddress = {
    update: function (element, valueAccessor) {
        var obj = valueAccessor();
        var text = "";
        if (obj.agentType() == AgentType.TcpForward
            || obj.agentType() == AgentType.HttpProxy
            || obj.agentType() == AgentType.Socks
            || obj.agentType() == AgentType.UdpForward) {
            text = "#:" + obj.agentPort();
        } else if (obj.agentType() == AgentType.URLForward) {
            text = "#:" + obj.agentPort() + obj.agentContext();
        }
        $(element).html(text);
    }
};
ko.bindingHandlers.destAddress = {
    update: function (element, valueAccessor) {
        var obj = valueAccessor();
        var text = "";
        if (obj.agentType() == AgentType.TcpForward
            || obj.agentType() == AgentType.UdpForward) {
            text = obj.destHost() + ":" + obj.destPort();
        } else if (obj.agentType() == AgentType.URLForward) {
            text = obj.destHost() + ":" + obj.destPort() + obj.destContext();
        } else if (obj.agentType() == AgentType.HttpProxy
            || obj.agentType() == AgentType.Socks) {
            text = "*";
        }
        $(element).html(text);
    }
};