/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.platform.core;

import com.xdja.cssp.ams.api.Constants;
import com.xdja.log.analysis.format.sdk.log.LogSetting;
import com.xdja.platform.common.lite.kit.prop.Prop;
import com.xdja.platform.common.lite.kit.prop.PropKit;
import com.xdja.platform.rpc.consumer.IService;
import com.xdja.platform.rpc.consumer.Service;
import com.xdja.platform.rpc.consumer.ServicePool;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationInit {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationInit.class);

    public static void initialize() {
        logger.info("=====\u5f00\u59cb\u6ce8\u518c\u9700\u8981\u8c03\u7528\u7684RPC\u670d\u52a1======");
        Prop systemProp = PropKit.use((String)"system.properties");
        String[] services = StringUtils.split((String)systemProp.get("rpc.services"), (String)"|");
        if (null != services && services.length > 0) {
            for (int i = 0; i < services.length; ++i) {
                String rpcIp = systemProp.get("rpc." + services[i] + ".ip", "127.0.0.1");
                int rpcPort = systemProp.getInt("rpc." + services[i] + ".port", Integer.valueOf(6666));
                long rpcTimeoutMillis = systemProp.getLong("rpc." + services[i] + ".timeoutMillis", Long.valueOf(5000L));
                Service service = new Service();
                service.setAddr(rpcIp);
                service.setPort(rpcPort);
                service.setTimeoutMillis(rpcTimeoutMillis);
                ServicePool.addService((String)services[i], (IService)service);
                logger.info("====>\u5f00\u59cb\u521d\u59cb\u5316RPC\u5ba2\u6237\u7aef\u914d\u7f6e\uff0c{}\u670d\u52a1\u5730\u5740{}:{}", new Object[]{services[i], rpcIp, rpcPort});
            }
        }
        Constants.HOST_ID = systemProp.get("host.id", "server_1");
        logger.info("=====\u6ce8\u518c\u9700\u8981\u8c03\u7528\u7684RPC\u670d\u52a1\u5b8c\u6210======");
        try {
            LogSetting.setServerName((String)"AmsApi");
            logger.info("\u8bbe\u7f6eloganalysis\u670d\u52a1\u6807\u8bc6\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6eloganalysis\u670d\u52a1\u6807\u8bc6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }
}

