/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xdja.cssp.ams.api.Constants;
import com.xdja.cssp.ams.api.util.IoReadUtil;
import com.xdja.cssp.ams.assetmanager.entity.BackupCardCheckBean;
import com.xdja.cssp.ams.assetmanager.service.IAssetManagerService;
import com.xdja.cssp.ams.assetmanager.service.IBakcardInfoService;
import com.xdja.cssp.restful.exception.BadRequestException;
import com.xdja.cssp.restful.exception.InternalServerException;
import com.xdja.log.analysis.aop.annoation.AopLog;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.util.json.JSONUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AssetApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IAssetManagerService assetManagerService = (IAssetManagerService)DefaultServiceRefer.getServiceRefer(IAssetManagerService.class);
    private IBakcardInfoService bakcardInfoService = (IBakcardInfoService)DefaultServiceRefer.getServiceRefer(IBakcardInfoService.class);

    @RequestMapping(value={"/save/assets"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @AopLog
    public Object saveAssets(HttpServletRequest request) {
        List assetList;
        this.logger.debug("\u5f00\u59cb\u4fdd\u5b58\u8d44\u4ea7\u4fe1\u606f");
        String requestId = this.genRequestId();
        try {
            assetList = this.convertRequestData(request);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8bf7\u6c42\u6570\u636e\u5f02\u5e38", (Throwable)e);
            throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_error", "\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u9519\u8bef");
        }
        this.logger.debug("\u6570\u636e\u957f\u5ea6\uff1a" + assetList.size());
        ArrayList failureDesc = new ArrayList();
        ArrayList cardList = new ArrayList();
        ArrayList mobileList = new ArrayList();
        ArrayList backupCardList = new ArrayList();
        this.checkParams(assetList, cardList, mobileList, backupCardList, failureDesc, requestId, 1);
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        if (cardList.isEmpty() && mobileList.isEmpty() && backupCardList.isEmpty()) {
            result.put("successCount", Integer.valueOf(0));
            result.put("failureCount", Integer.valueOf(failureDesc.size()));
            result.put("failureList", failureDesc);
            return result;
        }
        List failResult = null;
        try {
            failResult = this.assetManagerService.saveSyncAssets(cardList, mobileList, backupCardList);
        }
        catch (Exception e) {
            this.logger.error("\u4fdd\u5b58\u8d44\u4ea7\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new InternalServerException(Constants.HOST_ID, requestId, "internal_server_error", "\u4fdd\u5b58\u8d44\u4ea7\u4fe1\u606f\u5f02\u5e38");
        }
        if (!failResult.isEmpty()) {
            failureDesc.addAll(failResult);
        }
        result.put("successCount", Integer.valueOf(assetList.size() - failureDesc.size()));
        result.put("failureCount", Integer.valueOf(failureDesc.size()));
        result.put("failureList", failureDesc);
        try {
            this.logger.info("\u751f\u4ea7\u7cfb\u7edf\u540c\u6b65\u8d44\u4ea7\u4fe1\u606f\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSONUtil.toJSONString(result));
        }
        catch (Exception e) {
            this.logger.error("\u6253\u5370\u751f\u4ea7\u7cfb\u7edf\u540c\u6b65\u8d44\u4ea7\u4fe1\u606f\u7ed3\u679c\u4e3ajson\u5b57\u7b26\u4e32\u65f6\u5f02\u5e38", (Throwable)e);
        }
        this.logger.debug("\u4fdd\u5b58\u8d44\u4ea7\u4fe1\u606f\u5b8c\u6210");
        return result;
    }

    @RequestMapping(value={"/save/products"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @AopLog
    public Object saveProducts(HttpServletRequest request) {
        List assetList;
        String requestId = this.genRequestId();
        try {
            assetList = this.convertRequestData(request);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8bf7\u6c42\u6570\u636e\u5f02\u5e38", (Throwable)e);
            throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_error", "\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u9519\u8bef");
        }
        this.logger.debug("\u6570\u636e\u957f\u5ea6\uff1a" + assetList.size());
        ArrayList failureDesc = new ArrayList();
        ArrayList cardList = new ArrayList();
        ArrayList mobileList = new ArrayList();
        ArrayList backupCardList = new ArrayList();
        this.checkParams(assetList, cardList, mobileList, backupCardList, failureDesc, requestId, 2);
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        if (cardList.isEmpty() && mobileList.isEmpty() && backupCardList.isEmpty()) {
            result.put("successCount", Integer.valueOf(0));
            result.put("failureCount", Integer.valueOf(failureDesc.size()));
            result.put("failureList", failureDesc);
            return result;
        }
        List failResult = null;
        try {
            failResult = this.assetManagerService.saveSyncProducts(cardList, mobileList, backupCardList);
        }
        catch (Exception e) {
            this.logger.error("\u540c\u6b65\u51fa\u5382\u8d44\u4ea7\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new InternalServerException(Constants.HOST_ID, requestId, "internal_server_error", "\u540c\u6b65\u51fa\u5382\u8d44\u4ea7\u4fe1\u606f\u5f02\u5e38");
        }
        if (!failResult.isEmpty()) {
            failureDesc.addAll(failResult);
        }
        result.put("successCount", Integer.valueOf(assetList.size() - failureDesc.size()));
        result.put("failureCount", Integer.valueOf(failureDesc.size()));
        result.put("failureList", failureDesc);
        try {
            this.logger.info("\u540c\u6b65\u51fa\u5382\u8d44\u4ea7\u4fe1\u606f\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSONUtil.toJSONString(result));
        }
        catch (Exception e) {
            this.logger.error("\u540c\u6b65\u51fa\u5382\u8d44\u4ea7\u4fe1\u606f\u7ed3\u679c\u4e3ajson\u5b57\u7b26\u4e32\u65f6\u5f02\u5e38", (Throwable)e);
        }
        this.logger.debug("\u540c\u6b65\u51fa\u5382\u8d44\u4ea7\u4fe1\u606f\u5b8c\u6210");
        return result;
    }

    @RequestMapping(value={"/update/assets"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @AopLog
    public Object updateAssets(HttpServletRequest request) {
        List assetList;
        this.logger.debug("\u5f00\u59cb\u66f4\u65b0\u8d44\u4ea7\u4fe1\u606f");
        String requestId = this.genRequestId();
        try {
            assetList = this.convertRequestData(request);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8bf7\u6c42\u6570\u636e\u5f02\u5e38", (Throwable)e);
            throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_error", "\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u9519\u8bef");
        }
        this.logger.debug("\u6570\u636e\u957f\u5ea6\uff1a" + assetList.size());
        ArrayList failureDesc = new ArrayList();
        ArrayList cardList = new ArrayList();
        ArrayList mobileList = new ArrayList();
        ArrayList backupCardList = new ArrayList();
        this.checkParams(assetList, cardList, mobileList, backupCardList, failureDesc, requestId, 3);
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        if (cardList.isEmpty() && mobileList.isEmpty()) {
            result.put("successCount", Integer.valueOf(0));
            result.put("failureCount", Integer.valueOf(failureDesc.size()));
            result.put("failureList", failureDesc);
            return result;
        }
        List failResult = null;
        try {
            failResult = this.assetManagerService.updateSyncAssets(cardList, mobileList);
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u8d44\u4ea7\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new InternalServerException(Constants.HOST_ID, requestId, "internal_server_error", "\u66f4\u65b0\u8d44\u4ea7\u4fe1\u606f\u5f02\u5e38");
        }
        if (!failResult.isEmpty()) {
            failureDesc.addAll(failResult);
        }
        result.put("successCount", Integer.valueOf(assetList.size() - failureDesc.size()));
        result.put("failureCount", Integer.valueOf(failureDesc.size()));
        result.put("failureList", failureDesc);
        try {
            this.logger.info("\u751f\u4ea7\u7cfb\u7edf\u66f4\u65b0\u8d44\u4ea7\u4fe1\u606f\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSONUtil.toJSONString(result));
        }
        catch (Exception e) {
            this.logger.error("\u6253\u5370\u751f\u4ea7\u7cfb\u7edf\u66f4\u65b0\u8d44\u4ea7\u4fe1\u606f\u7ed3\u679c\u4e3ajson\u5b57\u7b26\u4e32\u65f6\u5f02\u5e38", (Throwable)e);
        }
        this.logger.debug("\u66f4\u65b0\u8d44\u4ea7\u4fe1\u606f\u5b8c\u6210");
        return result;
    }

    private List<Map<String, Object>> convertRequestData(HttpServletRequest request) throws Exception {
        byte[] data = IoReadUtil.readFixedLenDataFromInputStream((InputStream)request.getInputStream(), (int)request.getContentLength());
        String result = new String(data, "UTF-8");
        this.logger.debug("\u767b\u5f55\u539f\u59cb\u8bf7\u6c42\uff1a{}", (Object)result);
        return (List)JSONUtil.toSimpleJavaBean((String)result, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void checkParams(List<Map<String, Object>> assetList, List<Map<String, Object>> cardList, List<Map<String, Object>> mobileList, List<Map<String, Object>> backupCardList, List<Map<String, Object>> failureDesc, String requestId, int save) {
        if (null == assetList || assetList.size() <= 0) {
            this.logger.error("\u6536\u5230\u8d44\u4ea7\u4fe1\u606f\u4e3a\u7a7a");
            throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_not_valid", "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
        for (Map<String, Object> item : assetList) {
            item.put("randomId", UUID.randomUUID().toString());
            Integer type = (Integer)item.get("type");
            switch (type) {
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    try {
                        this.checkCard(item, requestId, save);
                    }
                    catch (BadRequestException e) {
                        failureDesc.add(this.bulidFailureResult((String)item.get("cardNo"), type, e.getMessage()));
                        break;
                    }
                    cardList.add(item);
                    break;
                }
                case 1: 
                case 2: {
                    try {
                        this.checkMobile(item, requestId, save);
                    }
                    catch (BadRequestException e) {
                        failureDesc.add(this.bulidFailureResult((String)item.get("imei"), type, e.getMessage()));
                        break;
                    }
                    mobileList.add(item);
                    break;
                }
                case 7: {
                    try {
                        this.checkBackupCard(item, requestId, save);
                    }
                    catch (BadRequestException e) {
                        failureDesc.add(this.bulidFailureResult((String)(item.get("cardSn") != null ? item.get("cardSn") : item.get("cardNo")), type, e.getMessage()));
                        break;
                    }
                    backupCardList.add(item);
                }
            }
        }
        if (cardList.isEmpty() && mobileList.isEmpty() && backupCardList.isEmpty()) {
            return;
        }
        if (!cardList.isEmpty()) {
            this.checkCardData(cardList, failureDesc, save);
        }
        if (!mobileList.isEmpty()) {
            this.checkMobileData(mobileList, failureDesc, save);
        }
        if (!backupCardList.isEmpty()) {
            this.checkBackupCardData(backupCardList, failureDesc, save);
        }
    }

    private void checkBackupCardData(List<Map<String, Object>> backupCardList, List<Map<String, Object>> failureDesc, int save) {
        ArrayList<Map<String, Object>> failureList = new ArrayList<Map<String, Object>>();
        ArrayList<String> localCard = new ArrayList<String>();
        for (Map<String, Object> item : backupCardList) {
            Integer type = (Integer)item.get("type");
            String backupCardName = (String)Constants.ASSET_BACKUPCARD_TYPE.get(type);
            String cardSn = ((String)(item.get("cardSn") != null ? item.get("cardSn") : item.get("cardNo"))).toLowerCase();
            if (localCard.contains(cardSn)) {
                failureDesc.add(this.bulidFailureResult(cardSn, type, backupCardName + "\u6570\u636e\u91cd\u590d"));
                failureList.add(item);
                continue;
            }
            localCard.add(cardSn);
        }
        backupCardList.removeAll(failureList);
    }

    private void checkMobileData(List<Map<String, Object>> mobileList, List<Map<String, Object>> failureDesc, int save) {
        ArrayList<Map<String, Object>> failureList = new ArrayList<Map<String, Object>>();
        ArrayList<String> localCard = new ArrayList<String>();
        ArrayList<String> localSn = new ArrayList<String>();
        ArrayList<String> localImei = new ArrayList<String>();
        ArrayList<String> localRelation = new ArrayList<String>();
        String sn = null;
        String imei = null;
        for (Map<String, Object> item : mobileList) {
            String cardNo;
            block8: {
                String mobileName;
                Integer type;
                block7: {
                    type = (Integer)item.get("type");
                    mobileName = (String)Constants.ASSET_MOBILE_TYPE.get(type);
                    cardNo = ((String)item.get("cardNo")).toLowerCase();
                    if (save == 2) break block7;
                    imei = (String)item.get("imei");
                    if (localCard.contains(cardNo)) {
                        failureDesc.add(this.bulidFailureResult(imei, type, mobileName + "\u6570\u636e\u91cd\u590d"));
                        failureList.add(item);
                        continue;
                    }
                    sn = (String)item.get("sn");
                    if (StringUtils.isNotBlank((CharSequence)sn) && localSn.contains(sn)) {
                        failureDesc.add(this.bulidFailureResult(imei, type, mobileName + "\u8bbe\u5907SN\u91cd\u590d"));
                        failureList.add(item);
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)imei) && localImei.contains(imei)) {
                        failureDesc.add(this.bulidFailureResult(imei, type, mobileName + "IMEI\u91cd\u590d"));
                        failureList.add(item);
                        continue;
                    }
                    if (save != 1 && save != 3) break block8;
                    String relationCardNo = (String)item.get("relationCardNo");
                    if (StringUtils.isNotBlank((CharSequence)relationCardNo) && localRelation.contains(relationCardNo.toLowerCase())) {
                        failureDesc.add(this.bulidFailureResult(imei, type, mobileName + "\u5173\u8054\u8bbe\u5907\u5361\u53f7\u91cd\u590d"));
                        failureList.add(item);
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)relationCardNo) && cardNo.equalsIgnoreCase(relationCardNo)) {
                        failureDesc.add(this.bulidFailureResult(imei, type, mobileName + "\u8bbe\u5907\u5361\u53f7\u4e0e\u5173\u8054\u8bbe\u5907\u5361\u53f7\u91cd\u590d"));
                        failureList.add(item);
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)relationCardNo)) break block8;
                    localRelation.add(relationCardNo.toLowerCase());
                    break block8;
                }
                if (localCard.contains(cardNo)) {
                    failureDesc.add(this.bulidFailureResult(imei, type, mobileName + "\u6570\u636e\u91cd\u590d"));
                    failureList.add(item);
                    continue;
                }
            }
            localCard.add(cardNo);
            localSn.add(sn);
            localImei.add(imei);
        }
        mobileList.removeAll(failureList);
    }

    private void checkCardData(List<Map<String, Object>> cardList, List<Map<String, Object>> failureDesc, int save) {
        ArrayList<Map<String, Object>> failureList = new ArrayList<Map<String, Object>>();
        ArrayList<String> localCard = new ArrayList<String>();
        for (Map<String, Object> item : cardList) {
            Integer type = (Integer)item.get("type");
            String cardName = (String)Constants.ASSET_CARD_TYPE.get(type);
            String cardNo = ((String)item.get("cardNo")).toLowerCase();
            if (localCard.contains(cardNo)) {
                failureDesc.add(this.bulidFailureResult(cardNo, type, cardName + "\u6570\u636e\u91cd\u590d"));
                failureList.add(item);
                continue;
            }
            localCard.add(cardNo);
        }
        cardList.removeAll(failureList);
    }

    private void checkMobile(Map<String, Object> mobile, String requestId, int save) {
        String deviceName;
        Integer type = (Integer)mobile.get("type");
        String typeDesc = (String)Constants.ASSET_MOBILE_TYPE.get(type);
        String string = deviceName = StringUtils.isBlank((CharSequence)typeDesc) ? "\u79fb\u52a8\u8bbe\u5907" : typeDesc;
        if (!Constants.ASSET_MOBILE_TYPE.keySet().contains(type)) {
            throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_not_valid", deviceName + "type\u5c5e\u6027\u4e0d\u5728\u679a\u4e3e\u7c7b\u578b\u5185");
        }
        if (save == 2) {
            String orderType = (String)mobile.get("orderOrigin");
            if (StringUtils.isBlank((CharSequence)orderType) || StringUtils.isBlank((CharSequence)(mobile.get("leaveFactoryTime") + "")) || StringUtils.isBlank((CharSequence)((String)mobile.get("cardNo")))) {
                throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_not_valid", deviceName + "\u5fc5\u586b\u9879\u4e3a\u7a7a");
            }
            if (orderType.equals("\u6218\u7565\u5e02\u573a\u90e8") && StringUtils.isBlank((CharSequence)((String)mobile.get("orderCode"))) || !orderType.equals("\u6218\u7565\u5e02\u573a\u90e8") && (StringUtils.isBlank((CharSequence)((String)mobile.get("project"))) || StringUtils.isBlank((CharSequence)((String)mobile.get("customer"))))) {
                throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_not_valid", deviceName + "\u5ba2\u6237\u4fe1\u606f\u5fc5\u586b\u9879\u4e3a\u7a7a");
            }
            return;
        }
        if (StringUtils.isBlank((CharSequence)((String)mobile.get("cardNo"))) || StringUtils.isBlank((CharSequence)((String)mobile.get("model")))) {
            throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_not_valid", deviceName + "\u5fc5\u586b\u9879\u4e3a\u7a7a");
        }
        if (type == 1 ? StringUtils.isBlank((CharSequence)((String)mobile.get("imei"))) || StringUtils.isBlank((CharSequence)((String)mobile.get("sn"))) : type == 2 && StringUtils.isBlank((CharSequence)((String)mobile.get("imei")))) {
            throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_not_valid", deviceName + "\u5fc5\u586b\u9879\u4e3a\u7a7a");
        }
    }

    private void checkCard(Map<String, Object> card, String requestId, int save) {
        String deviceName;
        Integer type = (Integer)card.get("type");
        String typeDesc = (String)Constants.ASSET_CARD_TYPE.get(type);
        String string = deviceName = StringUtils.isBlank((CharSequence)typeDesc) ? "" : typeDesc;
        if (!Constants.ASSET_CARD_TYPE.keySet().contains(type)) {
            throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_not_valid", deviceName + "type\u5c5e\u6027\u4e0d\u5728\u679a\u4e3e\u7c7b\u578b\u5185");
        }
        if (save == 2) {
            String orderType = (String)card.get("orderOrigin");
            if (StringUtils.isBlank((CharSequence)orderType) || StringUtils.isBlank((CharSequence)(card.get("leaveFactoryTime") + "")) || StringUtils.isBlank((CharSequence)((String)card.get("cardNo")))) {
                throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_not_valid", deviceName + "\u5fc5\u586b\u9879\u4e3a\u7a7a");
            }
            if (orderType.equals("\u6218\u7565\u5e02\u573a\u90e8") && StringUtils.isBlank((CharSequence)((String)card.get("orderCode"))) || !orderType.equals("\u6218\u7565\u5e02\u573a\u90e8") && (StringUtils.isBlank((CharSequence)((String)card.get("project"))) || StringUtils.isBlank((CharSequence)((String)card.get("customer"))))) {
                throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_not_valid", deviceName + "\u5ba2\u6237\u4fe1\u606f\u5fc5\u586b\u9879\u4e3a\u7a7a");
            }
            if ((type == 5 || type == 4) && StringUtils.isBlank((CharSequence)((String)card.get("norms")))) {
                throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_not_valid", deviceName + "\u89c4\u683c\u5bb9\u91cf\u5fc5\u586b\u9879\u4e3a\u7a7a");
            }
            return;
        }
        try {
            Integer isActivate = (Integer)card.get("isActivate");
            if (isActivate != 2 && isActivate != 1) {
                throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_not_valid", deviceName + "isActivate\u5c5e\u6027\u4e0d\u5728\u679a\u4e3e\u7c7b\u578b\u5185");
            }
        }
        catch (Exception e) {
            throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_not_valid", "isActivate\u5c5e\u6027\u503c\u4e0d\u5408\u6cd5");
        }
        if (StringUtils.isBlank((CharSequence)((String)card.get("cardNo"))) || StringUtils.isBlank((CharSequence)((String)card.get("initScript"))) || StringUtils.isBlank((CharSequence)((String)card.get("cosVersion"))) || StringUtils.isBlank((CharSequence)((String)card.get("productionTime"))) || StringUtils.isBlank((CharSequence)((String)card.get("rsaSignCert"))) || StringUtils.isBlank((CharSequence)((String)card.get("rsaEncCert"))) || StringUtils.isBlank((CharSequence)((String)card.get("sm2SignCert"))) || StringUtils.isBlank((CharSequence)((String)card.get("sm2EncCert")))) {
            throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_not_valid", deviceName + "\u5fc5\u586b\u9879\u4e3a\u7a7a");
        }
        if (type != 8 && (StringUtils.isBlank((CharSequence)((String)card.get("firmwareVersion"))) || StringUtils.isBlank((CharSequence)((String)card.get("seniorPublic"))))) {
            throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_not_valid", deviceName + "\u5fc5\u586b\u9879\u4e3a\u7a7a");
        }
        if (type == 4 && StringUtils.isBlank((CharSequence)((String)card.get("serialCode")))) {
            throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_not_valid", deviceName + "serialCode\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkBackupCard(Map<String, Object> backupcard, String requestId, int save) {
        String deviceName;
        Integer type = (Integer)backupcard.get("type");
        String typeDesc = (String)Constants.ASSET_BACKUPCARD_TYPE.get(type);
        String string = deviceName = StringUtils.isBlank((CharSequence)typeDesc) ? "" : typeDesc;
        if (save == 2) {
            String orderType = (String)backupcard.get("orderOrigin");
            if (StringUtils.isBlank((CharSequence)orderType) || StringUtils.isBlank((CharSequence)(backupcard.get("leaveFactoryTime") + "")) || StringUtils.isBlank((CharSequence)((String)backupcard.get("cardNo")))) {
                throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_not_valid", deviceName + "\u5fc5\u586b\u9879\u4e3a\u7a7a");
            }
            if (orderType.equals("\u6218\u7565\u5e02\u573a\u90e8") && StringUtils.isBlank((CharSequence)((String)backupcard.get("orderCode"))) || !orderType.equals("\u6218\u7565\u5e02\u573a\u90e8") && (StringUtils.isBlank((CharSequence)((String)backupcard.get("project"))) || StringUtils.isBlank((CharSequence)((String)backupcard.get("customer"))))) {
                throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_not_valid", deviceName + "\u5ba2\u6237\u4fe1\u606f\u5fc5\u586b\u9879\u4e3a\u7a7a");
            }
            return;
        }
        if (StringUtils.isBlank((CharSequence)((String)backupcard.get("cardSn"))) || StringUtils.isBlank((CharSequence)((String)backupcard.get("publicKey"))) || StringUtils.isBlank((CharSequence)((String)backupcard.get("privateKey"))) || StringUtils.isBlank((CharSequence)((String)backupcard.get("verifyCode"))) || StringUtils.isBlank((CharSequence)((String)backupcard.get("recoveryCode"))) || StringUtils.isBlank((CharSequence)((String)backupcard.get("productionTime")))) {
            throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_not_valid", deviceName + "\u5fc5\u586b\u9879\u4e3a\u7a7a");
        }
        Integer bKeyPairAlg = (Integer)backupcard.get("bKeyPairAlg");
        Integer encBkeyPairAlg = (Integer)backupcard.get("encBkeyPairAlg");
        if (!Constants.BAK_BKEYPAIRALG_TYPE.keySet().contains(bKeyPairAlg)) {
            throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_not_valid", deviceName + "\u516c\u79c1\u94a5\u7b97\u6cd5\u7c7b\u578b\u5c5e\u6027\u4e0d\u5728\u679a\u4e3e\u7c7b\u578b\u5185");
        }
        if (!Constants.BAK_ENCBKEYPAIRALG_TYPE.keySet().contains(encBkeyPairAlg)) {
            throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_not_valid", deviceName + "\u4fdd\u62a4\u5bc6\u94a5\u52a0\u5bc6\u79c1\u94a5\u7684\u7b97\u6cd5\u7c7b\u578b\u5c5e\u6027\u4e0d\u5728\u679a\u4e3e\u7c7b\u578b\u5185");
        }
    }

    private Map<String, Object> bulidFailureResult(String key, Integer type, String desc) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("cardNo", key);
        result.put("type", type);
        result.put("desc", desc);
        return result;
    }

    private String genRequestId() {
        return UUID.randomUUID().toString();
    }

    @RequestMapping(value={"/backupCard/check"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public Object checkBakup(HttpServletRequest request) {
        this.logger.debug("\u6536\u5230\u5ba2\u6237\u7aef\u5907\u4efd\u5361\u68c0\u6d4b\u8bf7\u6c42");
        Map<String, String> result = new HashMap<String, Object>();
        BackupCardCheckBean backupCard = null;
        try {
            byte[] data = IoReadUtil.readFixedLenDataFromInputStream((InputStream)request.getInputStream(), (int)request.getContentLength());
            this.logger.debug("\u767b\u5f55\u539f\u59cb\u8bf7\u6c42\uff1a{}", (Object)new String(data, "UTF-8"));
            backupCard = (BackupCardCheckBean)JSONUtil.toSimpleJavaBean((String)new String(data, "UTF-8"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            this.logger.error("\u89e3\u6790\u5ba2\u6237\u7aef\u5907\u4efd\u5361\u4fe1\u606f\u65f6\u5f02\u5e38", (Throwable)e);
        }
        if (backupCard != null) {
            if (StringUtils.isNotBlank((CharSequence)backupCard.getSn()) && StringUtils.isNotBlank((CharSequence)backupCard.getbCode()) || StringUtils.isNotBlank((CharSequence)backupCard.getSn()) && StringUtils.isNotBlank((CharSequence)backupCard.getrCode())) {
                result = this.bakcardInfoService.checkBakup(backupCard);
            } else {
                result.put("code", (String)((Object)BackupCardCheckBean.ENUM_BACKUP_CARD_ERROR.unlegal.status));
                result.put("info", BackupCardCheckBean.ENUM_BACKUP_CARD_ERROR.unlegal.value);
            }
        } else {
            result.put("code", (String)((Object)BackupCardCheckBean.ENUM_BACKUP_CARD_ERROR.unlegal.status));
            result.put("info", BackupCardCheckBean.ENUM_BACKUP_CARD_ERROR.unlegal.value);
        }
        try {
            this.logger.info("\u5907\u4efd\u5361\u4fe1\u606f\u68c0\u6d4b\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSONUtil.toJSONString(result));
        }
        catch (Exception e) {
            this.logger.error("\u6253\u5370\u5907\u4efd\u5361\u68c0\u6d4b\u7ed3\u679cjson\u5b57\u7b26\u4e32\u65f6\u5f02\u5e38", (Throwable)e);
        }
        this.logger.debug("\u5ba2\u6237\u7aef\u5907\u4efd\u5361\u68c0\u6d4b\u8bf7\u6c42\u5b8c\u6210");
        return result;
    }
}

