/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.api;

import com.xdja.cssp.ams.api.Constants;
import com.xdja.cssp.ams.api.util.VerifySignUtil;
import com.xdja.cssp.ams.assetmanager.entity.AssetBean;
import com.xdja.cssp.ams.assetmanager.entity.AssetInfo;
import com.xdja.cssp.ams.assetmanager.service.IAssetInfoService;
import com.xdja.cssp.restful.exception.BadRequestException;
import com.xdja.cssp.restful.exception.InternalServerException;
import com.xdja.platform.common.lite.kit.json.JsonMapper;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AssetCheckApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IAssetInfoService assetInfoService = (IAssetInfoService)DefaultServiceRefer.getServiceRefer(IAssetInfoService.class);

    @RequestMapping(value={"/assets/check"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public Object checkAsset(AssetInfo assetInfo, HttpServletRequest request) {
        this.logger.debug("\u6536\u5230\u5ba2\u6237\u7aef\u8d44\u4ea7\u68c0\u6d4b\u8bf7\u6c42\uff0c\u539f\u59cb\u53c2\u6570\u4e3a\uff1a\u3010{}\u3011", (Object)request.getQueryString());
        AssetBean assetBean = null;
        String result = null;
        if (null == assetInfo || StringUtils.isBlank((CharSequence)assetInfo.getCardNo()) || null == assetInfo.getActivateStatus() || StringUtils.isBlank((CharSequence)assetInfo.getImei())) {
            this.logger.error("\u83b7\u53d6\u5ba2\u6237\u7aef\u53c2\u6570\u5f02\u5e38");
            throw new BadRequestException(Constants.HOST_ID, this.genRequestId(), "request_params_not_valid", "\u83b7\u53d6\u5ba2\u6237\u7aef\u53c2\u6570\u5f02\u5e38");
        }
        try {
            assetBean = this.assetInfoService.isExistsAsset(assetInfo.getCardNo());
            if (assetBean.getCardExist() == AssetBean.CHECK_SUCCESS) {
                assetBean = this.assetInfoService.checkAsset(assetInfo);
                if (assetInfo.getActivateStatus() == AssetBean.CLIENT_ACTIVATE_STATUS && assetBean.getIsIdentical() == AssetBean.CHECK_SUCCESS && assetBean.getVerifyCert() == AssetBean.CHECK_SUCCESS && assetBean.getVerifyCos() == AssetBean.CHECK_SUCCESS) {
                    this.logger.debug("\u5ba2\u6237\u7aef\u6ee1\u8db3\u9a8c\u7b7e\u6761\u4ef6\uff0c\u5f00\u59cb\u9a8c\u7b7e");
                    if (VerifySignUtil.verifySign((HttpServletRequest)request)) {
                        assetBean.setVerifySignature(AssetBean.CHECK_SUCCESS);
                    } else {
                        assetBean.setVerifySignature(AssetBean.CHECK_FAIL);
                    }
                    this.logger.debug("\u5ba2\u6237\u7aef\u9a8c\u7b7e\u7ed3\u675f");
                }
            }
            result = JsonMapper.nonNullMapper().toJson((Object)assetBean);
            this.logger.info("\u8fd4\u56de\u5ba2\u6237\u7aef\u7684\u8d44\u4ea7\u68c0\u6d4b\u7ed3\u679c\u4e3a\uff1a\u3010{}\u3011", (Object)result);
        }
        catch (Exception e) {
            this.logger.error("\u8d44\u4ea7\u68c0\u6d4b\u65f6\u5f02\u5e38", (Throwable)e);
            throw new InternalServerException(Constants.HOST_ID, this.genRequestId(), "internal_server_error", "\u8d44\u4ea7\u68c0\u6d4b\u65f6\u5f02\u5e38");
        }
        this.logger.debug("\u5ba2\u6237\u7aef\u8d44\u4ea7\u68c0\u6d4b\u8bf7\u6c42\u5b8c\u6210");
        return result;
    }

    private String genRequestId() {
        return UUID.randomUUID().toString();
    }
}

