/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xdja.cssp.ams.api.Constants;
import com.xdja.cssp.ams.api.util.IoReadUtil;
import com.xdja.cssp.restful.exception.BadRequestException;
import com.xdja.cssp.restful.exception.InternalServerException;
import com.xdja.log.analysis.aop.annoation.AopLog;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.util.json.JSONUtil;
import com.xdja.safecenter.secret.bean.BackupData;
import com.xdja.safecenter.secret.provider.external.IBackupDataSyncProvider;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MiniKeyApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IBackupDataSyncProvider miniKeyService = (IBackupDataSyncProvider)DefaultServiceRefer.getServiceRefer(IBackupDataSyncProvider.class);

    @RequestMapping(value={"/assets/usbkey"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @AopLog
    public Object saveUsbkeys(@RequestBody List<BackupData> bcUsbKeyBeans, HttpServletRequest request) {
        this.logger.debug("\u5f00\u59cb\u5904\u7406\u540c\u6b65MINI USBKEY\u6570\u636e\u8bf7\u6c42");
        String requestId = this.genRequestId();
        if (null == bcUsbKeyBeans || bcUsbKeyBeans.size() == 0) {
            throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_error", "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
        this.logger.debug("\u6570\u636e\u957f\u5ea6\uff1a" + bcUsbKeyBeans.size());
        ArrayList<Map> failureDesc = new ArrayList<Map>();
        ArrayList usbkeyList = new ArrayList();
        this.checkParams(bcUsbKeyBeans, usbkeyList, failureDesc, requestId);
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        if (usbkeyList.size() == 0) {
            result.put("successCount", Integer.valueOf(0));
            result.put("failureCount", Integer.valueOf(failureDesc.size()));
            result.put("failureList", failureDesc);
            return result;
        }
        Map failResult = null;
        try {
            failResult = this.miniKeyService.doSyncBackupData(usbkeyList);
        }
        catch (Exception e) {
            this.logger.error("\u5904\u7406\u540c\u6b65MINI USBKEY\u6570\u636e\u8bf7\u6c42\u5f02\u5e38", (Throwable)e);
            throw new InternalServerException(Constants.HOST_ID, requestId, "internal_server_error", "\u5904\u7406\u540c\u6b65MINI USBKEY\u6570\u636e\u8bf7\u6c42\u5f02\u5e38");
        }
        if (!failResult.isEmpty()) {
            for (Map.Entry entry : failResult.entrySet()) {
                String cardNo = (String)entry.getKey();
                String message = (String)entry.getValue();
                failureDesc.add(this.bulidFailureResult(cardNo, Integer.valueOf(4), message));
            }
        }
        result.put("successCount", Integer.valueOf(bcUsbKeyBeans.size() - failureDesc.size()));
        result.put("failureCount", Integer.valueOf(failureDesc.size()));
        result.put("failureList", failureDesc);
        try {
            this.logger.info("\u5411ckms\u540c\u6b65\u5907\u4efd\u6062\u590dUsbkey\u8d44\u4ea7\u4fe1\u606f\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSONUtil.toJSONString(result));
        }
        catch (Exception e) {
            this.logger.error("\u6253\u5370\u5411ckms\u540c\u6b65\u5907\u4efd\u6062\u590dUsbkey\u8d44\u4ea7\u4fe1\u606f\u7ed3\u679c\u4e3ajson\u5b57\u7b26\u4e32\u65f6\u5f02\u5e38", (Throwable)e);
        }
        this.logger.debug("\u5904\u7406\u540c\u6b65MINI USBKEY\u6570\u636e\u8bf7\u6c42\u5b8c\u6210");
        return result;
    }

    private void checkParams(List<BackupData> bcUsbKeyBeans, List<BackupData> usbkeyList, List<Map<String, Object>> failureDesc, String requestId) {
        for (BackupData item : bcUsbKeyBeans) {
            try {
                this.checkUsbkey(item, requestId);
            }
            catch (BadRequestException e) {
                failureDesc.add(this.bulidFailureResult(item.getChipNo(), Integer.valueOf(4), e.getMessage()));
                continue;
            }
            usbkeyList.add(item);
        }
    }

    private void checkUsbkey(BackupData item, String requestId) {
        if (null == item.getbKek() || StringUtils.isBlank((CharSequence)item.getbKeySn()) || StringUtils.isBlank((CharSequence)item.getChipNo()) || null == item.getKek() || StringUtils.isBlank((CharSequence)item.getKekId()) || StringUtils.isBlank((CharSequence)item.getSn())) {
            throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_not_valid", item.getChipNo() + "\u5fc5\u586b\u9879\u4e3a\u7a7a");
        }
        if (item.getbKeySn().equalsIgnoreCase(item.getSn())) {
            throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_not_valid", item.getChipNo() + "mini key\u548c\u5907\u4efdkey\u7684\u7b7e\u540dsn\u4e00\u6837");
        }
    }

    private Map<String, Object> bulidFailureResult(String key, Integer type, String desc) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("cardNo", key);
        result.put("type", type);
        result.put("desc", desc);
        return result;
    }

    private String genRequestId() {
        return UUID.randomUUID().toString();
    }

    private List<BackupData> convertRequestData(HttpServletRequest request) throws Exception {
        byte[] data = IoReadUtil.readFixedLenDataFromInputStream((InputStream)request.getInputStream(), (int)request.getContentLength());
        String result = new String(data, "UTF-8");
        this.logger.debug("\u767b\u5f55\u539f\u59cb\u8bf7\u6c42\uff1a{}", (Object)result);
        return (List)JSONUtil.toSimpleJavaBean((String)result, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }
}

