/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xdja.cssp.ams.api.Constants;
import com.xdja.cssp.ams.api.util.IoReadUtil;
import com.xdja.cssp.ams.assetmanager.service.IAssetManagerService;
import com.xdja.cssp.restful.exception.BadRequestException;
import com.xdja.cssp.restful.exception.InternalServerException;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.util.json.JSONUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProductCheckApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IAssetManagerService assetManagerService = (IAssetManagerService)DefaultServiceRefer.getServiceRefer(IAssetManagerService.class);

    @RequestMapping(value={"/products/check"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public Object checkProducts(HttpServletRequest request) {
        List assetList;
        this.logger.debug("\u6536\u5230\u5ba2\u6237\u7aef\u8d44\u4ea7\u51fa\u5382\u68c0\u6d4b\u8bf7\u6c42\uff0c\u539f\u59cb\u53c2\u6570\u4e3a\uff1a\u3010{}\u3011", (Object)request.getQueryString());
        String requestId = this.genRequestId();
        try {
            assetList = this.convertRequestData(request);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8bf7\u6c42\u6570\u636e\u5f02\u5e38", (Throwable)e);
            throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_error", "\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u9519\u8bef");
        }
        this.logger.debug("\u6570\u636e\u957f\u5ea6\uff1a" + assetList.size());
        ArrayList failureDesc = new ArrayList();
        ArrayList cardList = new ArrayList();
        ArrayList mobileList = new ArrayList();
        ArrayList backupCardList = new ArrayList();
        this.checkParams(assetList, cardList, mobileList, backupCardList, failureDesc, requestId, 5);
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        if (cardList.isEmpty() && mobileList.isEmpty() && backupCardList.isEmpty()) {
            result.put("successCount", Integer.valueOf(0));
            result.put("failureCount", Integer.valueOf(failureDesc.size()));
            result.put("failureList", failureDesc);
            return result;
        }
        List failResult = null;
        try {
            failResult = this.assetManagerService.checkOutProducts(cardList, mobileList, backupCardList);
        }
        catch (Exception e) {
            this.logger.error("\u68c0\u6d4b\u8d44\u4ea7\u51fa\u5382\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new InternalServerException(Constants.HOST_ID, requestId, "internal_server_error", "\u68c0\u6d4b\u8d44\u4ea7\u51fa\u5382\u4fe1\u606f\u5f02\u5e38");
        }
        if (!failResult.isEmpty()) {
            failureDesc.addAll(failResult);
        }
        result.put("successCount", Integer.valueOf(assetList.size() - failureDesc.size()));
        result.put("failureCount", Integer.valueOf(failureDesc.size()));
        result.put("failureList", failureDesc);
        try {
            this.logger.info("\u68c0\u6d4b\u8d44\u4ea7\u51fa\u5382\u4fe1\u606f\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSONUtil.toJSONString(result));
        }
        catch (Exception e) {
            this.logger.error("\u68c0\u6d4b\u8d44\u4ea7\u51fa\u5382\u4fe1\u606f\u7ed3\u679c\u4e3ajson\u5b57\u7b26\u4e32\u65f6\u5f02\u5e38", (Throwable)e);
        }
        this.logger.debug("\u68c0\u6d4b\u8d44\u4ea7\u51fa\u5382\u4fe1\u606f\u5b8c\u6210");
        return result;
    }

    private String genRequestId() {
        return UUID.randomUUID().toString();
    }

    private List<Map<String, Object>> convertRequestData(HttpServletRequest request) throws Exception {
        byte[] data = IoReadUtil.readFixedLenDataFromInputStream((InputStream)request.getInputStream(), (int)request.getContentLength());
        String result = new String(data, "UTF-8");
        this.logger.debug("\u767b\u5f55\u539f\u59cb\u8bf7\u6c42\uff1a{}", (Object)result);
        return (List)JSONUtil.toSimpleJavaBean((String)result, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void checkParams(List<Map<String, Object>> assetList, List<Map<String, Object>> cardList, List<Map<String, Object>> mobileList, List<Map<String, Object>> backupCardList, List<Map<String, Object>> failureDesc, String requestId, int save) {
        if (null == assetList || assetList.size() <= 0) {
            this.logger.error("\u6536\u5230\u8d44\u4ea7\u4fe1\u606f\u4e3a\u7a7a");
            throw new BadRequestException(Constants.HOST_ID, requestId, "request_params_not_valid", "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
        for (Map<String, Object> item : assetList) {
            item.put("randomId", UUID.randomUUID().toString());
            Integer type = (Integer)item.get("type");
            switch (type) {
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    if (StringUtils.isBlank((CharSequence)((String)item.get("cardNo")))) {
                        failureDesc.add(this.bulidFailureResult((String)item.get("cardNo"), type, "\u82af\u7247\u5361\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
                        break;
                    }
                    cardList.add(item);
                    break;
                }
                case 1: 
                case 2: {
                    if (StringUtils.isBlank((CharSequence)((String)item.get("imei")))) {
                        failureDesc.add(this.bulidFailureResult((String)item.get("imei"), type, "imei\u4e0d\u80fd\u4e3a\u7a7a"));
                        break;
                    }
                    mobileList.add(item);
                    break;
                }
                case 7: {
                    if (StringUtils.isBlank((CharSequence)((String)item.get("cardNo")))) {
                        failureDesc.add(this.bulidFailureResult((String)item.get("cardNo"), type, "\u5907\u4efd\u5361SN\u4e0d\u80fd\u4e3a\u7a7a"));
                        break;
                    }
                    backupCardList.add(item);
                }
            }
        }
        if (cardList.isEmpty() && mobileList.isEmpty() && backupCardList.isEmpty()) {
            return;
        }
    }

    private Map<String, Object> bulidFailureResult(String key, Integer type, String desc) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("cardNo", key);
        result.put("type", type);
        result.put("desc", desc);
        return result;
    }
}

