/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.api.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;

/*
 * Exception performing whole class analysis ignored.
 */
public class Constants {
    public static final String HTTP_HEADER_SIGN_METHOD_RSA = "SHA1WITHRSA";
    public static final String HTTP_HEADER_SIGN_METHOD_SM2 = "SM3WITHSM2";
    public static final String HEADER_NAME_START = "x-at-";
    public static final String VERSION_HEADER_NAME = "x-at-version";
    public static final String SIGNATURE_SN_HEADER_NAME = "x-at-signature-sn";
    public static final String SIGNATURE_DN_HEADER_NAME = "x-at-signature-dn";
    public static final String SIGNATURE_METHOD_HEADER_NAME = "x-at-signature-method";
    public static final String TIMESTAMP_HEADER_NAME = "x-at-timestamp";
    public static final String SIGNATURE_VERSION_HEADER_NAME = "x-at-signature-version";
    public static final String SIGNATURE_NONCE_HEADER_NAME = "x-at-signature-nonce";
    public static String AUTHORIZATION_HEADER_NAME = "Authorization";

    public static Date parseTimestamp(String timestamp) throws ParseException {
        String formatTimestamp = timestamp.substring(0, 10) + " " + timestamp.substring(11, 19);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.parse(formatTimestamp);
    }

    public static String generateCanonicalizeRequest(String method, String uri, String queryString, List<Header> headers, String requestBody) throws UnsupportedEncodingException {
        String canonicalizeUri = Constants.canonicalizeUri((String)uri);
        String canonicalizeQueryString = Constants.canonicalizeQueryString((String)queryString);
        String canonicalizeHeaders = Constants.canonicalizeHeaders(headers);
        String canonicalizeRequest = Constants.canonicalizeRequest((String)method, (String)canonicalizeUri, (String)canonicalizeQueryString, (String)canonicalizeHeaders, (String)requestBody);
        return canonicalizeRequest;
    }

    private static String canonicalizeQueryString(String queryString) throws UnsupportedEncodingException {
        StringBuffer result = new StringBuffer();
        if (StringUtils.isBlank((CharSequence)queryString)) {
            return result.toString();
        }
        String[] queryData = StringUtils.split((String)queryString, (String)"&");
        ArrayList<String> queryList = new ArrayList<String>();
        String[] temp = null;
        String value = null;
        for (int i = 0; i < queryData.length; ++i) {
            value = queryData[i];
            if (StringUtils.isBlank((CharSequence)value) || (temp = StringUtils.split((String)value, (String)"="))[0].equalsIgnoreCase(AUTHORIZATION_HEADER_NAME)) continue;
            if (temp.length == 1) {
                queryList.add(URLEncoder.encode(temp[0], "UTF-8") + "=");
                continue;
            }
            if (temp.length < 2) continue;
            queryList.add(URLEncoder.encode(temp[0], "UTF-8") + "=" + URLEncoder.encode(value.substring(value.indexOf("=") + 1), "UTF-8"));
        }
        Collections.sort(queryList);
        for (String item : queryList) {
            result.append(item).append("&");
        }
        if (result.length() > 0) {
            return result.substring(0, result.lastIndexOf("&"));
        }
        return result.toString();
    }

    private static String canonicalizeUri(String uri) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        byte[] bytes = uri.getBytes("utf-8");
        for (int i = 0; i < bytes.length; ++i) {
            byte[] tmp;
            if (bytes[i] >= 65 && bytes[i] <= 90 || bytes[i] >= 97 && bytes[i] <= 122 || bytes[i] >= 48 && bytes[i] <= 57 || bytes[i] == 95 || bytes[i] == 45 || bytes[i] == 126 || bytes[i] == 46) {
                tmp = new byte[]{bytes[i]};
                result.append(new String(tmp, "utf-8"));
                continue;
            }
            tmp = new byte[]{bytes[i]};
            result.append('%' + Constants.byte2hex((byte[])tmp).toUpperCase());
        }
        return result.toString();
    }

    private static String byte2hex(byte[] bytes) {
        String hs = "";
        String stmp = "";
        for (int n = 0; n < bytes.length; ++n) {
            stmp = Integer.toHexString(bytes[n] & 0xFF);
            hs = stmp.length() == 1 ? hs + "0" + stmp : hs + stmp;
        }
        return hs;
    }

    private static String canonicalizeHeaders(List<Header> headers) {
        String canonicalHeaders = "";
        if (headers != null) {
            for (Header header : headers) {
                canonicalHeaders = canonicalHeaders + header.getName().toLowerCase().trim() + ":" + header.getValue().trim() + "\n";
            }
        }
        if ("" == canonicalHeaders) {
            canonicalHeaders = canonicalHeaders + "\n";
        }
        return canonicalHeaders;
    }

    private static String canonicalizeRequest(String method, String canonicalizeUri, String canonicalizeQueryString, String canonicalizeHeaders, String requestBody) {
        String canonicalizeRequest = method.toUpperCase() + "\n" + canonicalizeUri + "\n" + canonicalizeQueryString + "\n" + canonicalizeHeaders + requestBody;
        return canonicalizeRequest;
    }
}

