/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.api.util;

import com.xdja.cssp.ams.api.util.Constants;
import com.xdja.cssp.ams.assetmanager.entity.Cert;
import com.xdja.cssp.ams.assetmanager.service.ICertService;
import com.xdja.cssp.as.auth.sort.ComparatorHeader;
import com.xdja.cssp.as.auth.util.ByteUtils;
import com.xdja.cssp.as.auth.util.CertUtil;
import com.xdja.cssp.as.auth.util.SignUtils;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VerifySignUtil {
    private static Logger logger = LoggerFactory.getLogger(VerifySignUtil.class);
    private static ICertService service = (ICertService)DefaultServiceRefer.getServiceRefer(ICertService.class);

    public static boolean verifySign(HttpServletRequest httpRequest) throws UnsupportedEncodingException {
        boolean flag = false;
        logger.debug("\u5f00\u59cb\u9a8c\u8bc1\u5ba2\u6237\u7aef\u8eab\u4efd");
        String signatureMethod = httpRequest.getHeader("x-at-signature-method");
        if (StringUtils.isBlank((CharSequence)signatureMethod)) {
            logger.warn("\u5ba2\u6237\u7aef\u9a8c\u7b7e\u5931\u8d25\uff0c\u7b7e\u540d\u65b9\u5f0f\u4e3a\u7a7a.");
            return flag;
        }
        if (!signatureMethod.equals("SHA1WITHRSA") && !signatureMethod.equals("SM3WITHSM2")) {
            logger.warn("\u5ba2\u6237\u7aef\u9a8c\u7b7e\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5\u3010{}\u3011.", (Object)signatureMethod);
            return flag;
        }
        String authorization = httpRequest.getHeader(Constants.AUTHORIZATION_HEADER_NAME);
        if (StringUtils.isBlank((CharSequence)authorization)) {
            logger.warn("\u5ba2\u6237\u7aef\u9a8c\u7b7e\u5931\u8d25\uff0c\u7b7e\u540d\u4fe1\u606f\u4e3a\u7a7a.");
            return flag;
        }
        String signatureSn = httpRequest.getHeader("x-at-signature-sn");
        if (StringUtils.isBlank((CharSequence)signatureSn)) {
            logger.warn("\u5ba2\u6237\u7aef\u9a8c\u7b7e\u5931\u8d25\uff0c\u7ec8\u7aef\u7b7e\u540d\u8bc1\u4e66SN\u4e3a\u7a7a.");
            return flag;
        }
        int caAlg = signatureMethod.equals("SM3WITHSM2") ? 2 : 1;
        ArrayList<String> certList = new ArrayList<String>();
        certList.add(signatureSn);
        List cert = service.queryCertBySnList(certList, caAlg);
        if (null == cert || cert.size() == 0) {
            logger.warn("\u5ba2\u6237\u7aef\u9a8c\u7b7e\u5931\u8d25\uff0c\u8bc1\u4e66\u4e0d\u5b58\u5728.");
            return flag;
        }
        String queryString = URLDecoder.decode(httpRequest.getQueryString(), "UTF-8");
        String method = httpRequest.getMethod();
        String uri = httpRequest.getServletPath();
        ArrayList<BasicHeader> list = new ArrayList<BasicHeader>();
        Enumeration headers = httpRequest.getHeaderNames();
        while (headers.hasMoreElements()) {
            String headerName = (String)headers.nextElement();
            if (!headerName.startsWith("x-at-")) continue;
            list.add(new BasicHeader(headerName, httpRequest.getHeader(headerName)));
        }
        ComparatorHeader comparatorHeader = new ComparatorHeader();
        Collections.sort(list, comparatorHeader);
        try {
            ServletInputStream in = httpRequest.getInputStream();
            byte[] contentIn = ByteUtils.inputStreamToBytes((InputStream)in);
            String requestBody = new String(contentIn, "UTF-8");
            String canonicalizeRequest = Constants.generateCanonicalizeRequest((String)method, (String)uri, (String)queryString, list, (String)requestBody);
            logger.debug("====>>\u9a8c\u7b7e\u539f\u6587\uff1a\r\n{}", (Object)canonicalizeRequest);
            logger.debug("====>>\u9a8c\u7b7e\u7b7e\u540d\uff1a\r\n{}", (Object)authorization);
            PublicKey publicKey = CertUtil.getCertFromStr((String)((Cert)cert.get(0)).getCert()).getPublicKey();
            flag = SignUtils.verifySignature((String)signatureMethod, (PublicKey)publicKey, (byte[])canonicalizeRequest.getBytes("UTF-8"), (byte[])Base64.decodeBase64((String)authorization));
        }
        catch (Exception e) {
            logger.error("\u9a8c\u8bc1\u8bf7\u6c42\u7b7e\u540d\u5f02\u5e38", (Throwable)e);
            return flag;
        }
        logger.debug("\u9a8c\u8bc1\u5ba2\u6237\u7aef\u8eab\u4efd\u5b8c\u6210\uff0c\u7ed3\u679c\u4e3a\u3010{}\u3011", (Object)(flag ? "\u9a8c\u7b7e\u901a\u8fc7" : "\u9a8c\u7b7e\u4e0d\u901a\u8fc7"));
        return flag;
    }
}

