/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.assetmanager.business.impl;

import com.xdja.cssp.ams.assetmanager.bean.AssetStatisticsBean;
import com.xdja.cssp.ams.assetmanager.business.AssetStatisticsBusiness;
import com.xdja.cssp.ams.assetmanager.dao.AssetManagerJdbcDao;
import com.xdja.cssp.ams.assetmanager.entity.AssetStatisticsInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AssetStatisticsBusinessImpl
implements AssetStatisticsBusiness {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AssetManagerJdbcDao assetManagerJdbcDao;

    @Override
    public List<AssetStatisticsInfo> getAssetStatisticsInfo() {
        Map<String, Integer> assetMap = this.assetManagerJdbcDao.queryAssetStatisticsInfoMap();
        return this.convertAssetStaticsMapToList(assetMap);
    }

    private List<AssetStatisticsInfo> convertAssetStaticsMapToList(Map<String, Integer> assetMap) {
        ArrayList<AssetStatisticsInfo> assetStatisticsInfoList = new ArrayList<AssetStatisticsInfo>();
        Set<String> assetTypes = assetMap.keySet();
        Iterator<String> assetIter = assetTypes.iterator();
        int key = 0;
        while (assetIter.hasNext()) {
            if (assetIter.next() == null || assetIter.next().isEmpty()) continue;
            key = Integer.parseInt(assetIter.next());
            AssetStatisticsInfo assetStatisticsInfo = new AssetStatisticsInfo();
            if (key == AssetStatisticsBean.AssetTypeCovert.mobile.getType()) {
                assetStatisticsInfo.setAssetType(AssetStatisticsBean.AssetTypeCovert.mobile.getDesc());
                assetStatisticsInfo.setAssetCount(assetMap.get(key));
                assetStatisticsInfoList.add(assetStatisticsInfo);
                continue;
            }
            if (key == AssetStatisticsBean.AssetTypeCovert.pad.getType()) {
                assetStatisticsInfo.setAssetType(AssetStatisticsBean.AssetTypeCovert.pad.getDesc());
                assetStatisticsInfo.setAssetCount(assetMap.get(key));
                assetStatisticsInfoList.add(assetStatisticsInfo);
                continue;
            }
            if (key == AssetStatisticsBean.AssetTypeCovert.route.getType()) {
                assetStatisticsInfo.setAssetType(AssetStatisticsBean.AssetTypeCovert.route.getDesc());
                assetStatisticsInfo.setAssetCount(assetMap.get(key));
                assetStatisticsInfoList.add(assetStatisticsInfo);
                continue;
            }
            if (key == AssetStatisticsBean.AssetTypeCovert.usbkey.getType()) {
                assetStatisticsInfo.setAssetType(AssetStatisticsBean.AssetTypeCovert.usbkey.getDesc());
                assetStatisticsInfo.setAssetCount(assetMap.get(key));
                assetStatisticsInfoList.add(assetStatisticsInfo);
                continue;
            }
            if (key == AssetStatisticsBean.AssetTypeCovert.tfcard.getType()) {
                assetStatisticsInfo.setAssetType(AssetStatisticsBean.AssetTypeCovert.tfcard.getDesc());
                assetStatisticsInfo.setAssetCount(assetMap.get(key));
                assetStatisticsInfoList.add(assetStatisticsInfo);
                continue;
            }
            if (key == AssetStatisticsBean.AssetTypeCovert.chip.getType()) {
                assetStatisticsInfo.setAssetType(AssetStatisticsBean.AssetTypeCovert.chip.getDesc());
                assetStatisticsInfo.setAssetCount(assetMap.get(key));
                assetStatisticsInfoList.add(assetStatisticsInfo);
                continue;
            }
            if (key == AssetStatisticsBean.AssetTypeCovert.backcard.getType()) {
                assetStatisticsInfo.setAssetType(AssetStatisticsBean.AssetTypeCovert.backcard.getDesc());
                assetStatisticsInfo.setAssetCount(assetMap.get(key));
                assetStatisticsInfoList.add(assetStatisticsInfo);
                continue;
            }
            if (key != AssetStatisticsBean.AssetTypeCovert.smartcard.getType()) continue;
            assetStatisticsInfo.setAssetType(AssetStatisticsBean.AssetTypeCovert.smartcard.getDesc());
            assetStatisticsInfo.setAssetCount(assetMap.get(key));
            assetStatisticsInfoList.add(assetStatisticsInfo);
        }
        return assetStatisticsInfoList;
    }
}

