/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.assetmanager.dao;

import com.xdja.cssp.ams.assetmanager.bean.AmsAsset;
import com.xdja.cssp.ams.assetmanager.bean.AmsAssetMobilesInfo;
import com.xdja.cssp.ams.assetmanager.bean.AmsCertInfo;
import com.xdja.cssp.ams.assetmanager.bean.AmsTerminalUnlockCode;
import com.xdja.cssp.ams.assetmanager.bean.CertInfo;
import com.xdja.cssp.ams.assetmanager.entity.AccountBean;
import com.xdja.cssp.ams.assetmanager.entity.AssetStatisticsInfo;
import com.xdja.cssp.ams.assetmanager.entity.BackupCardScBean;
import com.xdja.cssp.ams.assetmanager.entity.BakcardCondition;
import com.xdja.cssp.ams.assetmanager.entity.CertBean;
import com.xdja.cssp.ams.assetmanager.entity.ProjectCustomerBean;
import com.xdja.cssp.ams.assetmanager.entity.TAssetHistory;
import com.xdja.cssp.ams.assetmanager.entity.TAssetInfo;
import com.xdja.cssp.ams.assetmanager.entity.TBakcardInfo;
import com.xdja.cssp.ams.assetmanager.entity.TBakcardInfoHistory;
import com.xdja.cssp.ams.assetmanager.utils.AMSLogRecord;
import com.xdja.cssp.ams.assetmanager.utils.Constants;
import com.xdja.cssp.ams.customer.util.CertUtil;
import com.xdja.platform.datacenter.jpa.dao.BaseJdbcDao;
import com.xdja.platform.microservice.db.nutz.Dao;
import com.xdja.platform.util.DateTimeUtil;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class AssetManagerJdbcDao
extends BaseJdbcDao {
    private Dao dao = Dao.use((String)"db::u8");

    public void updateActivateLogStatus(List<String> cardNos) {
        StringBuffer sqlBuffer = new StringBuffer(" UPDATE t_activate_log SET n_status = 2,n_synch_time = " + System.currentTimeMillis());
        sqlBuffer.append(" WHERE 1=0");
        if (cardNos != null && cardNos.size() > 0) {
            for (int i = 0; i < cardNos.size(); ++i) {
                sqlBuffer.append(" OR c_card_no = '" + cardNos.get(i) + "' ");
            }
        }
        this.executeSql(sqlBuffer.toString(), null);
    }

    public void updateAssetInfoStatus(List<String> cardNos) {
        StringBuffer sqlBuffer = new StringBuffer(" UPDATE t_asset_info SET n_status = 1");
        sqlBuffer.append(" WHERE 1=0");
        if (cardNos != null && cardNos.size() > 0) {
            for (int i = 0; i < cardNos.size(); ++i) {
                sqlBuffer.append(" OR c_card_no = '" + cardNos.get(i) + "' ");
            }
        }
        this.executeSql(sqlBuffer.toString(), null);
    }

    public List<AmsAsset> findunSyncAssetInfoCardnos() {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT info.c_asset_identify AS assetIdentify,info.c_asset_type AS assetType, info.c_card_no AS cardNo, ");
        sqlBuffer.append(" info.c_serial_code AS serialCode,info.n_time AS time,info.c_relation_asset_identify AS relationAssetIdentify");
        sqlBuffer.append(" FROM t_asset_info info ");
        sqlBuffer.append(" JOIN t_activate_log log ON log.c_card_no = info.c_card_no ");
        sqlBuffer.append(" WHERE log.n_status = :status AND log.n_activate_status = :activateStatus");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("status", (Object)"1");
        params.addValue("activateStatus", (Object)Constants.ACTIVATE_REPORT_RESULT);
        return this.queryForList(sqlBuffer.toString(), (SqlParameterSource)params, (RowMapper)new BeanPropertyRowMapper(AmsAsset.class));
    }

    public List<AmsAssetMobilesInfo> findAmsAssetMobilesByCardNos(List<String> unSyncCardNos) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT mobile.n_asset_id AS assetId,mobile.c_model AS model,mobile.c_os_name AS osName, ");
        sqlBuffer.append(" mobile.c_os_version AS osVersion,mobile.c_chip_code AS chipCode,mobile.c_imei AS imei,asset.c_card_no AS cardno,c_sn_no AS snNo, ");
        sqlBuffer.append(" asset.c_cos_version AS cosVersion ");
        sqlBuffer.append(" FROM t_asset_mobiles_info mobile ");
        sqlBuffer.append(" JOIN t_asset_info asset ON asset.n_id = mobile.n_asset_id ");
        sqlBuffer.append(" WHERE 1=0");
        for (int i = 0; i < unSyncCardNos.size(); ++i) {
            sqlBuffer.append(" OR asset.c_card_no = '" + unSyncCardNos.get(i) + "' ");
        }
        return this.queryForList(sqlBuffer.toString(), null, (RowMapper)new BeanPropertyRowMapper(AmsAssetMobilesInfo.class));
    }

    public List<AmsCertInfo> findCertsByCardNos(List<String> unSyncCardNos) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT cert.c_card_no AS cardNo,cert.c_cert_sn AS certSn, ");
        sqlBuffer.append(" cert.n_ca_alg AS caAlg,cert.n_cert_type AS certType,cert.n_cert_state AS certState, ");
        sqlBuffer.append(" cert.c_cert AS cert,cert.c_public_key AS publicKey,cert.n_not_before AS notBefore,cert.n_not_after AS notAfter ");
        sqlBuffer.append(" FROM t_cert_info cert ");
        sqlBuffer.append(" WHERE 1=0");
        for (int i = 0; i < unSyncCardNos.size(); ++i) {
            sqlBuffer.append(" OR cert.c_card_no = '" + unSyncCardNos.get(i) + "' ");
        }
        return this.queryForList(sqlBuffer.toString(), null, (RowMapper)new BeanPropertyRowMapper(AmsCertInfo.class));
    }

    public List<AmsTerminalUnlockCode> findTerminalUnlockCodeByCardNos(List<String> unSyncCardNos) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT c_card_no AS cardNo,c_card_uid AS cardUid,c_unlock_code AS unlockCode,c_disk_code AS diskCode,n_time AS time ");
        sqlBuffer.append(" FROM t_terminal_unlock_code ");
        sqlBuffer.append(" WHERE 1=0");
        for (int i = 0; i < unSyncCardNos.size(); ++i) {
            sqlBuffer.append(" OR c_card_no = '" + unSyncCardNos.get(i) + "' ");
        }
        return this.queryForList(sqlBuffer.toString(), null, (RowMapper)new BeanPropertyRowMapper(AmsTerminalUnlockCode.class));
    }

    public List<AmsCertInfo> updateCerts(Map<String, List<CertBean>> datas, Map<String, CertInfo> certMap) {
        ArrayList<AmsCertInfo> amsCertList = new ArrayList<AmsCertInfo>();
        AmsCertInfo amsCert = null;
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO t_cert_info(n_record_id, c_card_no, c_cert_sn, n_ca_alg,");
        sql.append(" n_cert_type, n_cert_state, c_cert, c_public_key, n_not_before, n_not_after) VALUES(");
        sql.append(":recordId, :cardNo, :certSn, :caAlg, :certType, :certState, :cert,");
        sql.append(" :publicKey, :notBefore, :notAfter)");
        MapSqlParameterSource[] params = new MapSqlParameterSource[datas.size() * 4];
        MapSqlParameterSource parameter = null;
        List<CertBean> certList = null;
        CertInfo info = null;
        int index = 0;
        if (!datas.isEmpty()) {
            for (String cardNo : datas.keySet()) {
                certList = datas.get(cardNo);
                info = certMap.get(cardNo);
                for (int i = 0; i < certList.size(); ++i) {
                    CertBean certBean = certList.get(i);
                    parameter = new MapSqlParameterSource();
                    amsCert = new AmsCertInfo();
                    parameter.addValue("recordId", (Object)info.getRecordId());
                    parameter.addValue("cardNo", (Object)cardNo.toLowerCase());
                    parameter.addValue("certSn", (Object)certBean.getSn());
                    parameter.addValue("caAlg", (Object)certBean.getCaAlg());
                    parameter.addValue("certType", (Object)certBean.getCertType());
                    parameter.addValue("certState", (Object)certBean.getCertState());
                    parameter.addValue("cert", (Object)certBean.getCert());
                    parameter.addValue("publicKey", (Object)certBean.getPublicKey());
                    parameter.addValue("notBefore", (Object)certBean.getBefore());
                    parameter.addValue("notAfter", (Object)certBean.getAfter());
                    params[index] = parameter;
                    ++index;
                    amsCert.setCardNo(cardNo.toLowerCase());
                    amsCert.setCertSn(certBean.getSn());
                    amsCert.setCaAlg(certBean.getCaAlg());
                    amsCert.setCertType(certBean.getCertType());
                    amsCert.setCertState(certBean.getCertState());
                    amsCert.setCert(certBean.getCert());
                    amsCert.setPublicKey(certBean.getPublicKey());
                    amsCert.setNotBefore(certBean.getBefore());
                    amsCert.setNotAfter(certBean.getAfter());
                    amsCertList.add(amsCert);
                }
            }
            this.addOrUpdate(sql.toString(), (SqlParameterSource[])params);
        }
        return amsCertList;
    }

    public List<AmsCertInfo> findunSyncCertInfo() {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT cert.c_card_no AS cardNo,cert.c_cert_sn AS certSn, ");
        sqlBuffer.append(" cert.n_ca_alg AS caAlg,cert.n_cert_type AS certType,cert.n_cert_state AS certState, ");
        sqlBuffer.append(" cert.c_cert AS cert,cert.c_public_key AS publicKey,cert.n_not_before AS notBefore,cert.n_not_after AS notAfter ");
        sqlBuffer.append(" FROM t_cert_info cert ");
        sqlBuffer.append(" WHERE cert.n_sync_change_status = :changeStatus ");
        MapSqlParameterSource param = new MapSqlParameterSource();
        param.addValue("changeStatus", (Object)"1");
        return this.queryForList(sqlBuffer.toString(), (SqlParameterSource)param, (RowMapper)new BeanPropertyRowMapper(AmsCertInfo.class));
    }

    public void updateCertSyncStatus(List<AmsCertInfo> list) {
        StringBuffer sqlBuffer = new StringBuffer(" UPDATE t_cert_info SET n_sync_change_status = 2");
        sqlBuffer.append(" WHERE 1=0");
        if (list != null && list.size() > 0) {
            for (AmsCertInfo cert : list) {
                sqlBuffer.append(" OR c_card_no = '" + cert.getCardNo() + "' ");
            }
        }
        this.executeSql(sqlBuffer.toString(), null);
    }

    public List<String> checkAssetExist(List<String> identifyList) {
        String sql = "SELECT c_asset_identify FROM t_asset_info WHERE c_asset_identify IN (:identifyList)";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("identifyList", identifyList);
        return this.queryForList(sql, (SqlParameterSource)params, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString("c_asset_identify");
            }
        });
    }

    public List<String> checkUnLockExist(List<String> cardNoList) {
        String sql = "SELECT c_card_no FROM t_terminal_unlock_code WHERE c_card_no IN (:cardNoList)";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("cardNoList", cardNoList);
        return this.queryForList(sql, (SqlParameterSource)params, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString("c_card_no");
            }
        });
    }

    public List<String> checkCertExist(List<String> cardNoList) {
        String sql = "SELECT c_card_no FROM t_cert_info WHERE c_card_no IN (:cardNoList)";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("cardNoList", cardNoList);
        return this.queryForList(sql, (SqlParameterSource)params, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString("c_card_no");
            }
        });
    }

    public List<String> checkRelationExist(List<String> relationCardNo) {
        String sql = "SELECT c_relation_asset_identify FROM t_asset_info WHERE c_relation_asset_identify IN (:relationCardNo)";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("relationCardNo", relationCardNo);
        return this.queryForList(sql, (SqlParameterSource)params, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString("c_relation_asset_identify");
            }
        });
    }

    public List<String> checkRelationCardNoExist(List<String> relationCardNo) {
        String sql = "SELECT c_asset_identify FROM t_asset_info WHERE c_asset_identify IN (:relationCardNo) AND c_relation_asset_identify IS NULL OR c_relation_asset_identify = ''";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("relationCardNo", relationCardNo);
        return this.queryForList(sql, (SqlParameterSource)params, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString("c_asset_identify");
            }
        });
    }

    public List<String> saveMobiles(List<String[]> datas, final Map<String, String[]> temp, Map<String, String[]> tempUsbKey, int assetType) {
        ArrayList<String> cardNoList = new ArrayList<String>();
        String cardNo = null;
        StringBuffer sql = new StringBuffer();
        if (!datas.isEmpty()) {
            StringBuffer sqlAssetPhone = new StringBuffer();
            sqlAssetPhone.append("UPDATE t_asset_info SET c_asset_type = :assetType, c_serial_code = :serialCode,").append(" c_relation_asset_identify = :relationIdentify").append(" WHERE c_asset_identify = :identify");
            MapSqlParameterSource[] params = new MapSqlParameterSource[datas.size()];
            MapSqlParameterSource parameter = null;
            String[] item = null;
            for (int i = 0; i < params.length; ++i) {
                item = datas.get(i);
                cardNo = item[0].toLowerCase();
                parameter = new MapSqlParameterSource();
                parameter.addValue("assetType", (Object)assetType);
                parameter.addValue("serialCode", (Object)item[1]);
                parameter.addValue("relationIdentify", StringUtils.isNotBlank((CharSequence)item[2]) ? item[2].toLowerCase() : null);
                parameter.addValue("identify", (Object)cardNo);
                params[i] = parameter;
                cardNoList.add(cardNo);
            }
            this.addOrUpdate(sqlAssetPhone.toString(), (SqlParameterSource[])params);
            if (tempUsbKey != null && tempUsbKey.size() > 0) {
                StringBuffer sqlAssetUsb = new StringBuffer();
                sqlAssetUsb.append("UPDATE t_asset_info SET c_asset_type = :assetType, c_serial_code = :serialCode, c_norms = :norms,").append(" c_relation_asset_identify = :relationIdentify").append(" WHERE c_asset_identify = :identify");
                MapSqlParameterSource[] paramUsbKeys = new MapSqlParameterSource[tempUsbKey.size()];
                int i = 0;
                for (String key : tempUsbKey.keySet()) {
                    item = tempUsbKey.get(key);
                    cardNo = key.toLowerCase();
                    parameter = new MapSqlParameterSource();
                    parameter.addValue("assetType", (Object)4);
                    parameter.addValue("serialCode", (Object)item[3]);
                    parameter.addValue("relationIdentify", (Object)item[0].toLowerCase());
                    parameter.addValue("identify", (Object)cardNo);
                    parameter.addValue("norms", (Object)item[4]);
                    paramUsbKeys[i] = parameter;
                    ++i;
                    cardNoList.add(cardNo);
                }
                this.addOrUpdate(sqlAssetUsb.toString(), (SqlParameterSource[])paramUsbKeys);
            }
            sql = new StringBuffer();
            sql.append("SELECT n_id, c_asset_identify, n_record_id FROM t_asset_info WHERE c_asset_identify IN (:identifyList)");
            parameter = new MapSqlParameterSource();
            parameter.addValue("identifyList", new ArrayList<String>(temp.keySet()));
            final ArrayList paramList = new ArrayList();
            this.queryForList(sql.toString(), (SqlParameterSource)parameter, (RowMapper)new RowMapper<String>(){
                MapSqlParameterSource parameter = null;
                String[] item = null;
                String identify = null;
                Long recordId = null;
                long id = 0L;

                public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                    this.id = rs.getLong("n_id");
                    this.identify = rs.getString("c_asset_identify");
                    this.recordId = rs.getLong("n_record_id");
                    this.item = (String[])temp.get(this.identify);
                    this.parameter = new MapSqlParameterSource();
                    this.parameter.addValue("assetId", (Object)this.id);
                    this.parameter.addValue("recordId", (Object)this.recordId);
                    this.parameter.addValue("imei", (Object)this.item[5]);
                    this.parameter.addValue("model", (Object)this.item[7]);
                    this.parameter.addValue("snNo", (Object)this.item[6]);
                    paramList.add(this.parameter);
                    return null;
                }
            });
            StringBuffer insertSql = new StringBuffer();
            insertSql.append("INSERT INTO t_asset_mobiles_info(n_asset_id, n_record_id, c_model, c_imei, c_sn_no)");
            insertSql.append(" VALUES(:assetId, :recordId, :model, :imei, :snNo)");
            MapSqlParameterSource[] param = new MapSqlParameterSource[paramList.size()];
            this.addOrUpdate(insertSql.toString(), (SqlParameterSource[])paramList.toArray(param));
        }
        return cardNoList;
    }

    public void saveChipAsset(List<String[]> datas, Map<String, String[]> temp, final Map<String, Long> orderInfo, Map<String, Long> customerInfo, int type, boolean status1, long recordId, Map<String, String> orderTypeMap, Map<String, String> correctOrderStateMap) {
        final HashMap<String, String> orderMap = new HashMap<String, String>();
        if (!datas.isEmpty()) {
            StringBuffer sql = new StringBuffer();
            sql.append("INSERT INTO t_asset_info(c_asset_identify, n_customer_id, n_record_id, c_asset_type, c_card_no,");
            sql.append(" n_production_time, n_time, n_status, c_cos_version, c_senior_public, c_firmware_version, c_init_script)");
            sql.append(" VALUES(:identify, :customerId, :recordId, :assetType, :cardNo, :productionTime,");
            sql.append(" :time, :status, :cosVersion, :seniorPublic, :firmwareVersion, :initScript)");
            MapSqlParameterSource[] params = new MapSqlParameterSource[datas.size()];
            MapSqlParameterSource parameter = null;
            String[] item = null;
            for (int i = 0; i < params.length; ++i) {
                item = datas.get(i);
                String orderType = orderTypeMap.get(item[0].toLowerCase());
                orderMap.put(item[0].toLowerCase(), item[4].trim().substring(orderType.length(), orderType.length() + (Integer)Constants.CUSTOMER_ORDER_TYPE.get(orderType)));
                String orderName = item[4].trim().substring(orderType.length(), orderType.length() + (Integer)Constants.CUSTOMER_ORDER_TYPE.get(orderType));
                parameter = new MapSqlParameterSource();
                parameter.addValue("identify", (Object)item[0].toLowerCase());
                parameter.addValue("customerId", (Object)customerInfo.get(item[5].trim()));
                parameter.addValue("recordId", (Object)recordId);
                parameter.addValue("assetType", (Object)type);
                parameter.addValue("cardNo", (Object)item[0].toLowerCase());
                parameter.addValue("productionTime", (Object)DateTimeUtil.dateTimeStrToLong((String)item[2]));
                parameter.addValue("time", (Object)DateTimeUtil.getStartTime((String)item[3]));
                parameter.addValue("status", (Object)(correctOrderStateMap.get(orderName).equals("1") ? "1" : "2"));
                parameter.addValue("cosVersion", (Object)item[1]);
                parameter.addValue("seniorPublic", (Object)item[6]);
                parameter.addValue("firmwareVersion", (Object)item[7]);
                parameter.addValue("initScript", (Object)item[8]);
                params[i] = parameter;
                HashMap<String, Object> logMap = new HashMap<String, Object>();
                logMap.put("logType", 4);
                logMap.put("AssetId", item[0].toLowerCase());
                logMap.put("AssetType", type);
                AMSLogRecord.logRecord(logMap);
            }
            this.addOrUpdate(sql.toString(), (SqlParameterSource[])params);
            sql = new StringBuffer();
            sql.append("SELECT n_id, c_asset_identify FROM t_asset_info WHERE c_asset_identify IN (:identifyList)");
            parameter = new MapSqlParameterSource();
            parameter.addValue("identifyList", new ArrayList<String>(temp.keySet()));
            final ArrayList paramList = new ArrayList();
            this.queryForList(sql.toString(), (SqlParameterSource)parameter, (RowMapper)new RowMapper<String>(){
                MapSqlParameterSource parameter = null;
                String identify = null;
                long id = 0L;

                public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                    this.id = rs.getLong("n_id");
                    this.identify = rs.getString("c_asset_identify");
                    this.parameter = new MapSqlParameterSource();
                    this.parameter.addValue("orderId", orderInfo.get(orderMap.get(this.identify)));
                    this.parameter.addValue("assetId", (Object)this.id);
                    paramList.add(this.parameter);
                    return null;
                }
            });
            StringBuffer sqlOrderAsset = new StringBuffer();
            sqlOrderAsset.append("INSERT INTO t_order_asset(n_order_id, n_asset_id)");
            sqlOrderAsset.append(" VALUES(:orderId, :assetId)");
            MapSqlParameterSource[] param = new MapSqlParameterSource[paramList.size()];
            this.addOrUpdate(sqlOrderAsset.toString(), (SqlParameterSource[])paramList.toArray(param));
        }
    }

    public List<AmsTerminalUnlockCode> saveUnLock(List<String[]> datas, long recordId) {
        ArrayList<AmsTerminalUnlockCode> terminalUnlockCodeList = new ArrayList<AmsTerminalUnlockCode>();
        AmsTerminalUnlockCode terminalUnlockCode = null;
        if (!datas.isEmpty()) {
            StringBuffer sql = new StringBuffer();
            sql.append("INSERT INTO t_terminal_unlock_code(n_record_id, c_card_no, c_card_uid,");
            sql.append(" c_unlock_code, c_disk_code, n_time) VALUES(:recordId, :cardNo, :cardUId, :unLockCode, :diskCode, :time)");
            MapSqlParameterSource[] params = new MapSqlParameterSource[datas.size()];
            long nowTime = System.currentTimeMillis();
            MapSqlParameterSource parameter = null;
            String[] item = null;
            for (int i = 0; i < params.length; ++i) {
                item = datas.get(i);
                parameter = new MapSqlParameterSource();
                parameter.addValue("recordId", (Object)recordId);
                parameter.addValue("cardNo", (Object)item[0].toLowerCase());
                parameter.addValue("cardUId", (Object)item[1]);
                parameter.addValue("unLockCode", (Object)item[2]);
                parameter.addValue("diskCode", (Object)item[3]);
                parameter.addValue("time", (Object)nowTime);
                params[i] = parameter;
                terminalUnlockCode = new AmsTerminalUnlockCode();
                terminalUnlockCode.setCardNo(item[0].toLowerCase());
                terminalUnlockCode.setCardUid(item[1]);
                terminalUnlockCode.setUnlockCode(item[2]);
                terminalUnlockCode.setTime(nowTime);
                terminalUnlockCode.setDiskCode(item[3]);
                terminalUnlockCodeList.add(terminalUnlockCode);
            }
            this.addOrUpdate(sql.toString(), (SqlParameterSource[])params);
        }
        return terminalUnlockCodeList;
    }

    public List<AmsCertInfo> saveCert(Map<String, List<CertBean>> datas, long recordId) {
        ArrayList<AmsCertInfo> amsCertList = new ArrayList<AmsCertInfo>();
        AmsCertInfo amsCert = null;
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO t_cert_info(n_record_id, c_card_no, c_cert_sn, n_ca_alg,");
        sql.append(" n_cert_type, n_cert_state, c_cert, c_public_key, n_not_before, n_not_after) VALUES(");
        sql.append(" :recordId, :cardNo, :certSn, :caAlg, :certType, :certState, :cert,");
        sql.append(" :publicKey, :notBefore, :notAfter)");
        MapSqlParameterSource[] params = new MapSqlParameterSource[datas.size() * 4];
        MapSqlParameterSource parameter = null;
        List<CertBean> certList = null;
        int index = 0;
        if (!datas.isEmpty()) {
            for (String cardNo : datas.keySet()) {
                certList = datas.get(cardNo);
                for (int i = 0; i < certList.size(); ++i) {
                    CertBean certBean = certList.get(i);
                    parameter = new MapSqlParameterSource();
                    parameter.addValue("recordId", (Object)recordId);
                    parameter.addValue("cardNo", (Object)cardNo.toLowerCase());
                    parameter.addValue("certSn", (Object)certBean.getSn());
                    parameter.addValue("caAlg", (Object)certBean.getCaAlg());
                    parameter.addValue("certType", (Object)certBean.getCertType());
                    parameter.addValue("certState", (Object)certBean.getCertState());
                    parameter.addValue("cert", (Object)certBean.getCert());
                    parameter.addValue("publicKey", (Object)certBean.getPublicKey());
                    parameter.addValue("notBefore", (Object)certBean.getBefore());
                    parameter.addValue("notAfter", (Object)certBean.getAfter());
                    params[index] = parameter;
                    ++index;
                    amsCert = new AmsCertInfo();
                    amsCert.setCardNo(cardNo.toLowerCase());
                    amsCert.setCertSn(certBean.getSn());
                    amsCert.setCaAlg(certBean.getCaAlg());
                    amsCert.setCertType(certBean.getCertType());
                    amsCert.setCertState(certBean.getCertState());
                    amsCert.setCert(certBean.getCert());
                    amsCert.setPublicKey(certBean.getPublicKey());
                    amsCert.setNotBefore(certBean.getBefore());
                    amsCert.setNotAfter(certBean.getAfter());
                    amsCertList.add(amsCert);
                }
            }
            this.addOrUpdate(sql.toString(), (SqlParameterSource[])params);
        }
        return amsCertList;
    }

    public Map<String, CertInfo> findCertInfos(List<String> cardNos, Integer algType) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT c_card_no AS cardno,n_record_id AS recordId FROM t_cert_info WHERE 1=0 ");
        MapSqlParameterSource parameter = new MapSqlParameterSource();
        if (cardNos != null && cardNos.size() > 0) {
            for (int i = 0; i < cardNos.size(); ++i) {
                sqlBuffer.append(" OR c_card_no = :cardno" + i + " ");
                parameter.addValue("cardno" + i, (Object)cardNos.get(i));
            }
        }
        if (null != algType) {
            sqlBuffer.append(" AND n_ca_alg =:algType ");
            parameter.addValue("algType", (Object)algType);
        }
        List certInfos = this.queryForList(sqlBuffer.toString(), (SqlParameterSource)parameter, (RowMapper)new BeanPropertyRowMapper(CertInfo.class));
        HashMap<String, CertInfo> map = new HashMap<String, CertInfo>();
        if (certInfos != null && certInfos.size() > 0) {
            for (CertInfo info : certInfos) {
                map.put(info.getCardno(), info);
            }
        }
        return map;
    }

    public void deleteCerts(List<String> cardNos, Integer algType) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" DELETE FROM t_cert_info WHERE 1=0");
        MapSqlParameterSource parameter = new MapSqlParameterSource();
        if (cardNos != null && cardNos.size() > 0) {
            for (int i = 0; i < cardNos.size(); ++i) {
                sqlBuffer.append(" OR c_card_no = :cardno" + i + " ");
                parameter.addValue("cardno" + i, (Object)cardNos.get(i));
            }
        }
        if (null != algType) {
            sqlBuffer.append(" AND n_ca_alg =:algType ");
            parameter.addValue("algType", (Object)algType);
        }
        this.deleteBySql(sqlBuffer.toString(), (SqlParameterSource)parameter);
    }

    public List<String> checkUidExist(ArrayList<String> uidList) {
        String sql = "SELECT c_card_uid FROM t_terminal_unlock_code WHERE c_card_uid IN (:uidList)";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("uidList", uidList);
        return this.queryForList(sql, (SqlParameterSource)params, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString("c_card_uid");
            }
        });
    }

    public List<String> checkMobileSnExist(ArrayList<String> snList) {
        String sql = "SELECT c_sn_no FROM t_asset_mobiles_info WHERE c_sn_no IN (:snList)";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("snList", snList);
        return this.queryForList(sql, (SqlParameterSource)params, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString("c_sn_no");
            }
        });
    }

    public Map<String, Integer> queryAssetChip(List<String> identifyList) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String sql = "SELECT c_asset_identify AS assetIdentify FROM t_asset_info WHERE c_asset_identify IN (:identifyList) AND c_asset_type = :assetType";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("identifyList", identifyList);
        params.addValue("assetType", (Object)6);
        List assetInfos = this.queryForList(sql, (SqlParameterSource)params, (RowMapper)new BeanPropertyRowMapper(TAssetInfo.class));
        if (assetInfos != null && assetInfos.size() > 0) {
            for (TAssetInfo info : assetInfos) {
                map.put(info.getAssetIdentify(), 1);
            }
        }
        return map;
    }

    public List<String> checkAssetUnChipExist(ArrayList<String> identifyList) {
        String sql = "SELECT c_asset_identify FROM t_asset_info WHERE c_asset_identify IN (:identifyList) AND c_asset_type != :assetType";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("identifyList", identifyList);
        params.addValue("assetType", (Object)6);
        return this.queryForList(sql, (SqlParameterSource)params, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString("c_asset_identify");
            }
        });
    }

    public List<String> updateAssetInfo(List<String[]> datas, int type, long recordId) {
        if (type == 10) {
            type = 8;
        }
        ArrayList<String> cardNoList = new ArrayList<String>();
        String cardNo = null;
        if (!datas.isEmpty()) {
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE t_asset_info SET c_asset_type = :assetType, c_serial_code = :serialCode,");
            sql.append(" c_norms = :norms WHERE c_asset_identify = :identify");
            MapSqlParameterSource[] params = new MapSqlParameterSource[datas.size()];
            MapSqlParameterSource parameter = null;
            String[] item = null;
            for (int i = 0; i < params.length; ++i) {
                item = datas.get(i);
                cardNo = item[0].toLowerCase();
                parameter = new MapSqlParameterSource();
                parameter.addValue("assetType", (Object)type);
                parameter.addValue("serialCode", (Object)item[1]);
                parameter.addValue("norms", (Object)item[2]);
                parameter.addValue("identify", (Object)cardNo);
                params[i] = parameter;
                cardNoList.add(cardNo);
            }
            this.addOrUpdate(sql.toString(), (SqlParameterSource[])params);
        }
        return cardNoList;
    }

    public Map<String, Integer> queryAssetCert(ArrayList<String> identifyList) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String sql = "SELECT c_card_no AS assetIdentify FROM t_cert_info WHERE c_card_no IN (:identifyList)";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("identifyList", identifyList);
        List assetInfos = this.queryForList(sql, (SqlParameterSource)params, (RowMapper)new BeanPropertyRowMapper(TAssetInfo.class));
        if (assetInfos != null && assetInfos.size() > 0) {
            for (TAssetInfo info : assetInfos) {
                map.put(info.getAssetIdentify(), 1);
            }
        }
        return map;
    }

    public List<String> checkCertSnExist(List<String> snList) {
        String sql = "SELECT c_cert_sn FROM t_cert_info WHERE c_cert_sn IN (:snList)";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("snList", snList);
        return this.queryForList(sql, (SqlParameterSource)params, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString("c_cert_sn");
            }
        });
    }

    public List<CertBean> getCertSnExist(List<String> cardNoList) {
        String sql = "SELECT c_card_no AS cardNo, c_cert_sn AS sn, n_cert_type AS certType, n_ca_alg AS caAlg FROM t_cert_info WHERE c_card_no IN (:cardNoList)";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("cardNoList", cardNoList);
        return this.queryForList(sql, (SqlParameterSource)params, (RowMapper)new BeanPropertyRowMapper(CertBean.class));
    }

    public void saveAccountInfo(List<AccountBean> accountList) {
        MapSqlParameterSource parameter = null;
        AccountBean accBean = null;
        StringBuffer sqlAccount = new StringBuffer();
        sqlAccount.append("INSERT INTO t_account_asset(n_record_id, c_account, c_asset_identify)");
        sqlAccount.append(" VALUES(:recordId, :account, :identify)");
        if (!accountList.isEmpty()) {
            MapSqlParameterSource[] paramAccounts = new MapSqlParameterSource[accountList.size()];
            for (int i = 0; i < accountList.size(); ++i) {
                accBean = accountList.get(i);
                parameter = new MapSqlParameterSource();
                parameter.addValue("recordId", (Object)accBean.getRecordId());
                parameter.addValue("account", (Object)accBean.getAccount());
                parameter.addValue("identify", (Object)accBean.getCardNo().toLowerCase());
                paramAccounts[i] = parameter;
            }
            this.addOrUpdate(sqlAccount.toString(), (SqlParameterSource[])paramAccounts);
        }
    }

    public Map<String, Integer> queryAssetForMap(List<String> identifyList) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String sql = "SELECT c_asset_identify AS assetIdentify FROM t_asset_info WHERE c_asset_identify IN (:identifyList)";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("identifyList", identifyList);
        List assetInfos = this.queryForList(sql, (SqlParameterSource)params, (RowMapper)new BeanPropertyRowMapper(TAssetInfo.class));
        if (assetInfos != null && assetInfos.size() > 0) {
            for (TAssetInfo info : assetInfos) {
                map.put(info.getAssetIdentify(), 1);
            }
        }
        return map;
    }

    public Map<String, Integer> queryAssetForMapByOrderName(List<String> orderNameList) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT asset.c_asset_identify AS assetIdentify FROM t_asset_info asset").append(" JOIN t_customer customer ON customer.n_id = asset.n_customer_id").append(" JOIN t_order_asset oass ON oass.n_asset_id = asset.n_id").append(" JOIN t_order oder ON oder.n_id = oass.n_order_id").append(" WHERE oder.c_name IN (:orderNameList)");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("orderNameList", orderNameList);
        List assetInfos = this.queryForList(sqlBuffer.toString(), (SqlParameterSource)params, (RowMapper)new BeanPropertyRowMapper(TAssetInfo.class));
        if (assetInfos != null && assetInfos.size() > 0) {
            for (TAssetInfo info : assetInfos) {
                map.put(info.getAssetIdentify(), 1);
            }
        }
        return map;
    }

    public Map<String, Integer> queryAssetCertForMap(List<String> identifyList) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String sql = "SELECT c_card_no AS assetIdentify FROM t_cert_info WHERE c_card_no IN (:identifyList)";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("identifyList", identifyList);
        List assetInfos = this.queryForList(sql, (SqlParameterSource)params, (RowMapper)new BeanPropertyRowMapper(TAssetInfo.class));
        if (assetInfos != null && assetInfos.size() > 0) {
            for (TAssetInfo info : assetInfos) {
                map.put(info.getAssetIdentify(), 1);
            }
        }
        return map;
    }

    public void delUnlockCodeBatch(List<String> cardNos) {
        String sql = "DELETE FROM t_terminal_unlock_code WHERE c_card_no IN (:cardNos)";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("cardNos", cardNos);
        this.deleteBySql(sql, (SqlParameterSource)params);
    }

    private void constructCerts(Map<String, Object> data, List<MapSqlParameterSource> certParams) {
        String cardNo = (String)data.get("cardNo");
        certParams.add(this.constructData(cardNo.toLowerCase(), 1, 2, (String)data.get("rsaSignCert")));
        certParams.add(this.constructData(cardNo.toLowerCase(), 1, 1, (String)data.get("rsaEncCert")));
        certParams.add(this.constructData(cardNo.toLowerCase(), 2, 2, (String)data.get("sm2SignCert")));
        certParams.add(this.constructData(cardNo.toLowerCase(), 2, 1, (String)data.get("sm2EncCert")));
    }

    private MapSqlParameterSource constructData(String cardNo, int caAlg, int certType, String cert) {
        X509Certificate x509 = CertUtil.getCertFromStr((String)cert);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("recordId", (Object)-1);
        params.addValue("cardNo", (Object)cardNo.toLowerCase());
        params.addValue("certSn", (Object)CertUtil.getSn((X509Certificate)x509));
        params.addValue("caAlg", (Object)caAlg);
        params.addValue("certType", (Object)certType);
        params.addValue("certState", (Object)CertBean.ENUM_CERT_STATE.normal.value);
        params.addValue("cert", (Object)CertUtil.certToFullB64((Certificate)x509).replace("\r", "\\r").replace("\n", "\\n"));
        params.addValue("publicKey", (Object)CertUtil.getPubKey((String)cert, (int)caAlg));
        params.addValue("notBefore", (Object)x509.getNotBefore().getTime());
        params.addValue("notAfter", (Object)x509.getNotAfter().getTime());
        return params;
    }

    private void delCertAndUnlockCode(List<String> cardNos) {
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM t_cert_info WHERE c_card_no IN (:cardNos)");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("cardNos", cardNos);
        this.deleteBySql(sql.toString(), (SqlParameterSource)params);
        sql = new StringBuffer();
        sql.append("DELETE FROM t_terminal_unlock_code WHERE c_card_no IN (:cardNos)");
        this.deleteBySql(sql.toString(), (SqlParameterSource)params);
    }

    private MapSqlParameterSource constructMobileInfoData(Map<String, Object> mobile) {
        MapSqlParameterSource child = new MapSqlParameterSource();
        child.addValue("recordId", (Object)-1);
        child.addValue("model", (Object)((String)mobile.get("model")));
        child.addValue("imei", (Object)((String)mobile.get("imei")));
        child.addValue("snNo", (Object)((String)mobile.get("sn")));
        return child;
    }

    public List<AmsAsset> findunSyncAssetProInfoCardnos(List<String> cardNoList) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT info.c_asset_identify AS assetIdentify,info.c_asset_type AS assetType, info.c_card_no AS cardNo, ");
        sqlBuffer.append(" info.c_serial_code AS serialCode,info.n_time AS time,info.c_relation_asset_identify AS relationAssetIdentify, ");
        sqlBuffer.append(" n_status AS status,info.c_cos_version AS cosVersion, c_norms AS norms, c_firmware_version AS firmwareVersion, ");
        sqlBuffer.append(" c_init_script AS initScript, c_senior_public AS seniorPublic, n_chip_type AS chipType ");
        sqlBuffer.append(" FROM t_asset_info info WHERE info.c_card_no IN (:cardNoList)");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("cardNoList", cardNoList);
        return this.queryForList(sqlBuffer.toString(), (SqlParameterSource)params, (RowMapper)new BeanPropertyRowMapper(AmsAsset.class));
    }

    public List<String> queryExistSn(List<String> snList) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT mobiles.c_sn_no FROM t_asset_mobiles_info mobiles");
        sql.append(" WHERE mobiles.c_sn_no IN (:snList)");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("snList", snList);
        return this.queryForList(sql.toString(), (SqlParameterSource)params, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString("c_sn_no");
            }
        });
    }

    public void deleteAccountInfo(List<String> cardNos) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" DELETE FROM t_account_asset WHERE 1=0");
        MapSqlParameterSource parameter = new MapSqlParameterSource();
        if (cardNos != null && cardNos.size() > 0) {
            for (int i = 0; i < cardNos.size(); ++i) {
                sqlBuffer.append(" OR c_asset_identify = :cardno" + i + " ");
                parameter.addValue("cardno" + i, (Object)cardNos.get(i));
            }
        }
        this.deleteBySql(sqlBuffer.toString(), (SqlParameterSource)parameter);
    }

    public List<String> checkMobileImeiExist(ArrayList<String> arrayList) {
        String sql = "SELECT c_imei FROM t_asset_mobiles_info WHERE c_imei IN (:imeiList)";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("imeiList", arrayList);
        return this.queryForList(sql, (SqlParameterSource)params, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString("c_imei");
            }
        });
    }

    public Map<String, String> queryCustomerInfo(ArrayList<String> orderList) {
        final HashMap<String, String> orderMap = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer("SELECT");
        sql.append(" der.c_name AS orderName,");
        sql.append(" cus.c_name AS customerName");
        sql.append(" FROM");
        sql.append(" t_order der");
        sql.append(" JOIN t_customer cus ON der.n_customer_id = cus.n_id");
        sql.append(" WHERE der.c_name IN (:orderList)");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("orderList", orderList);
        this.queryForList(sql.toString(), (SqlParameterSource)params, (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                orderMap.put(rs.getString("orderName"), rs.getString("customerName"));
                return null;
            }
        });
        return orderMap;
    }

    public void queryOrderProject(ArrayList<String> orderList, final Map<String, String> orderProjectMap, final Map<String, String> orderActiveMap) {
        StringBuffer sql = new StringBuffer("SELECT");
        sql.append(" der.c_name AS orderName, der.n_order_type AS orderType,");
        sql.append(" pro.c_name AS projectName");
        sql.append(" FROM");
        sql.append(" t_order der");
        sql.append(" JOIN t_project pro ON der.n_project_id = pro.n_id");
        sql.append(" WHERE der.c_name IN (:orderList)");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("orderList", orderList);
        this.queryForList(sql.toString(), (SqlParameterSource)params, (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                orderProjectMap.put(rs.getString("orderName"), rs.getString("projectName"));
                orderActiveMap.put(rs.getString("orderName"), rs.getString("orderType"));
                return null;
            }
        });
    }

    public void queryCustomersByName(final Map<String, Long> customerNameMap, ArrayList<String> customerNameList) {
        if (customerNameList != null && customerNameList.size() > 0) {
            StringBuffer sql = new StringBuffer("SELECT n_id, c_name FROM t_customer WHERE c_name IN (:customerNames)");
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("customerNames", customerNameList);
            this.queryForList(sql.toString(), (SqlParameterSource)params, (RowMapper)new RowMapper<Object>(){

                public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                    customerNameMap.put(rs.getString("c_name"), rs.getLong("n_id"));
                    return null;
                }
            });
        }
    }

    public void queryOrdersByName(final Map<String, Long> orderNameMap, Map<String, String> orderCustomerInfo) {
        StringBuffer sql = new StringBuffer("SELECT n_id, c_name FROM t_order WHERE c_name IN (:orderNames)");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("orderNames", new ArrayList<String>(orderCustomerInfo.keySet()));
        this.queryForList(sql.toString(), (SqlParameterSource)params, (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                orderNameMap.put(rs.getString("c_name"), rs.getLong("n_id"));
                return null;
            }
        });
    }

    public Map<String, Long> saveCustomerInfo(Map<String, Integer> customerMap) {
        HashMap<String, Long> customerNameMap = new HashMap<String, Long>();
        MapSqlParameterSource params = null;
        StringBuffer sql = null;
        this.queryCustomersByName(customerNameMap, new ArrayList<String>(customerMap.keySet()));
        ArrayList<String> customerList = new ArrayList<String>();
        for (String customerName : customerMap.keySet()) {
            if (null != customerNameMap.get(customerName)) continue;
            customerList.add(customerName);
        }
        if (!customerList.isEmpty()) {
            MapSqlParameterSource[] paramsArr = new MapSqlParameterSource[customerList.size()];
            MapSqlParameterSource[] paramsUpdateArr = new MapSqlParameterSource[customerList.size()];
            sql = new StringBuffer("INSERT INTO t_customer(c_name, n_reg_time) VALUES(:name, :regTime)");
            int index = 0;
            int index1 = 0;
            for (String customerName : customerList) {
                params = new MapSqlParameterSource();
                params.addValue("name", (Object)customerName);
                params.addValue("regTime", (Object)System.currentTimeMillis());
                paramsArr[index++] = params;
                params = new MapSqlParameterSource();
                params.addValue("name", (Object)customerName);
                paramsUpdateArr[index1++] = params;
            }
            this.addOrUpdate(sql.toString(), (SqlParameterSource[])paramsArr);
            sql = new StringBuffer("UPDATE t_customer SET c_code = n_id WHERE c_name = :name");
            this.addOrUpdate(sql.toString(), (SqlParameterSource[])paramsUpdateArr);
            this.queryCustomersByName(customerNameMap, new ArrayList<String>(customerMap.keySet()));
        }
        return customerNameMap;
    }

    public Map<String, Long> saveOrderInfo(Map<String, String> correctOrderMap, Map<String, String> correctOrderStateMap, Map<String, String> correctOrderCustomerMap, Map<String, Long> customerInfo, Map<String, Long> projectInfo, Map<String, Integer> orderOriginMap) {
        HashMap<String, Long> orderNameMap = new HashMap<String, Long>();
        MapSqlParameterSource params = null;
        StringBuffer sql = null;
        this.queryOrdersByName(orderNameMap, correctOrderMap);
        ArrayList<String> orderList = new ArrayList<String>();
        for (String orderName : correctOrderMap.keySet()) {
            if (null != orderNameMap.get(orderName)) continue;
            orderList.add(orderName);
        }
        if (!orderList.isEmpty()) {
            MapSqlParameterSource[] paramsArr = new MapSqlParameterSource[orderList.size()];
            sql = new StringBuffer("INSERT INTO t_order(n_project_id, n_order_type, n_customer_id, c_name, n_time, n_origin)");
            sql.append(" VALUES(:projectId, :orderType, :customerId, :name, :regTime, :origin)");
            int index = 0;
            for (String orderName : orderList) {
                params = new MapSqlParameterSource();
                String projectName = correctOrderMap.get(orderName);
                String customerName = correctOrderCustomerMap.get(orderName);
                params.addValue("projectId", (Object)projectInfo.get(projectName + "|" + customerName));
                params.addValue("orderType", (Object)correctOrderStateMap.get(orderName));
                params.addValue("customerId", (Object)customerInfo.get(customerName));
                params.addValue("name", (Object)orderName);
                params.addValue("regTime", (Object)System.currentTimeMillis());
                params.addValue("origin", (Object)orderOriginMap.get(orderName));
                paramsArr[index++] = params;
            }
            this.addOrUpdate(sql.toString(), (SqlParameterSource[])paramsArr);
            this.queryOrdersByName(orderNameMap, correctOrderMap);
        }
        return orderNameMap;
    }

    public void deleteAssetFormat(ArrayList<String> cardNos) {
        StringBuffer sql = null;
        MapSqlParameterSource[] params = new MapSqlParameterSource[cardNos.size()];
        MapSqlParameterSource parameter = new MapSqlParameterSource();
        parameter.addValue("cardNos", cardNos);
        sql = new StringBuffer("DELETE FROM t_order_asset WHERE n_asset_id IN ").append(" (SELECT asset.n_id FROM t_asset_info asset WHERE asset.c_asset_identify IN (:cardNos))");
        this.deleteBySql(sql.toString(), (SqlParameterSource)parameter);
        sql = new StringBuffer("DELETE FROM t_asset_mobiles_info WHERE n_asset_id IN ").append(" (SELECT asset.n_id FROM t_asset_info asset WHERE asset.c_asset_identify IN (:cardNos))");
        this.deleteBySql(sql.toString(), (SqlParameterSource)parameter);
        sql = new StringBuffer("DELETE FROM t_asset_info WHERE c_asset_identify IN  (:cardNos)");
        this.deleteBySql(sql.toString(), (SqlParameterSource)parameter);
        sql = new StringBuffer("DELETE FROM t_cert_info WHERE c_card_no IN  (:cardNos)");
        this.deleteBySql(sql.toString(), (SqlParameterSource)parameter);
        sql = new StringBuffer("DELETE FROM t_terminal_unlock_code WHERE c_card_no IN  (:cardNos)");
        this.deleteBySql(sql.toString(), (SqlParameterSource)parameter);
        sql = new StringBuffer("DELETE FROM t_activate_log WHERE c_card_no IN  (:cardNos)");
        this.deleteBySql(sql.toString(), (SqlParameterSource)parameter);
        sql = new StringBuffer("UPDATE t_asset_info SET c_relation_asset_identify = NULL WHERE c_relation_asset_identify = :cardNos");
        for (int i = 0; i < params.length; ++i) {
            parameter = new MapSqlParameterSource();
            parameter.addValue("cardNos", (Object)cardNos.get(i));
            params[i] = parameter;
        }
        this.addOrUpdate(sql.toString(), (SqlParameterSource[])params);
    }

    public void updateAssetInfo(Map<String, String[]> assetMap) {
        MapSqlParameterSource[] params = new MapSqlParameterSource[assetMap.size()];
        MapSqlParameterSource parameter = null;
        StringBuffer sql = new StringBuffer();
        Integer index = 0;
        String[] assetInfo = null;
        if (!assetMap.isEmpty()) {
            sql.append("UPDATE t_asset_info SET c_cos_version = :cosVersion, c_serial_code = :serialCode,").append(" c_senior_public = :seniorPublic, c_firmware_version = :firmwareVersion, c_init_script = :initScript").append(" WHERE c_asset_identify = :identify");
            for (String cardNo : assetMap.keySet()) {
                parameter = new MapSqlParameterSource();
                assetInfo = assetMap.get(cardNo);
                parameter.addValue("cosVersion", (Object)assetInfo[1]);
                parameter.addValue("serialCode", (Object)assetInfo[4]);
                parameter.addValue("seniorPublic", (Object)assetInfo[5]);
                parameter.addValue("firmwareVersion", (Object)assetInfo[6]);
                parameter.addValue("initScript", (Object)assetInfo[7]);
                parameter.addValue("identify", (Object)cardNo);
                params[index.intValue()] = parameter;
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
            this.addOrUpdate(sql.toString(), (SqlParameterSource[])params);
        }
    }

    public void updateAssetActivateDeadLine(Map<String, String> assetMap) {
        MapSqlParameterSource[] params = new MapSqlParameterSource[assetMap.size()];
        MapSqlParameterSource parameter = null;
        StringBuffer sql = new StringBuffer();
        Integer index = 0;
        String deadLineTime = null;
        if (!assetMap.isEmpty()) {
            sql.append("UPDATE t_asset_info SET n_activate_deadline_time = :activeLimitTime").append(" WHERE c_asset_identify = :identify");
            for (String cardNo : assetMap.keySet()) {
                parameter = new MapSqlParameterSource();
                deadLineTime = assetMap.get(cardNo);
                parameter.addValue("activeLimitTime", (Object)DateTimeUtil.getStartTime((String)deadLineTime));
                parameter.addValue("identify", (Object)cardNo);
                params[index.intValue()] = parameter;
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
            this.addOrUpdate(sql.toString(), (SqlParameterSource[])params);
        }
    }

    public void updateAssetAllowActivateStatus(Map<String, String> assetMap) {
        MapSqlParameterSource[] params = new MapSqlParameterSource[assetMap.size()];
        MapSqlParameterSource parameter = null;
        StringBuffer sql = new StringBuffer();
        Integer index = 0;
        String isAllowedActivateStatus = null;
        if (!assetMap.isEmpty()) {
            sql.append("UPDATE t_asset_info SET n_allow_activate_status = :isAllowedActivate").append(" WHERE c_asset_identify = :identify");
            for (String cardNo : assetMap.keySet()) {
                parameter = new MapSqlParameterSource();
                isAllowedActivateStatus = assetMap.get(cardNo);
                parameter.addValue("isAllowedActivate", (Object)Integer.parseInt(isAllowedActivateStatus));
                parameter.addValue("identify", (Object)cardNo);
                params[index.intValue()] = parameter;
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
            this.addOrUpdate(sql.toString(), (SqlParameterSource[])params);
        }
    }

    public void updateSnAndImeiInfo(final Map<String, String> snMap, final Map<String, String> imeiMap) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT n_id, c_asset_identify, n_record_id FROM t_asset_info WHERE c_asset_identify IN (:identifyList)");
        MapSqlParameterSource parameter = new MapSqlParameterSource();
        parameter.addValue("identifyList", new ArrayList<String>(snMap.keySet()));
        final ArrayList paramList = new ArrayList();
        this.queryForList(sql.toString(), (SqlParameterSource)parameter, (RowMapper)new RowMapper<String>(){
            MapSqlParameterSource parameter = null;
            String identify = null;
            long id = 0L;

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                this.id = rs.getLong("n_id");
                this.identify = rs.getString("c_asset_identify");
                this.parameter = new MapSqlParameterSource();
                this.parameter.addValue("sn", snMap.get(this.identify));
                this.parameter.addValue("imei", imeiMap.get(this.identify));
                this.parameter.addValue("assetId", (Object)this.id);
                paramList.add(this.parameter);
                return null;
            }
        });
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("UPDATE t_asset_mobiles_info SET c_sn_no = :sn, c_imei = :imei WHERE n_asset_id = :assetId");
        MapSqlParameterSource[] param = new MapSqlParameterSource[paramList.size()];
        this.addOrUpdate(insertSql.toString(), (SqlParameterSource[])paramList.toArray(param));
    }

    public void updateCardsInfo(String originalCardNo, String[] cardInfoArr) {
        StringBuffer sql = new StringBuffer();
        MapSqlParameterSource param = new MapSqlParameterSource();
        sql.append("UPDATE t_asset_info SET c_asset_identify = :assetIdentify, c_card_no = :cardNo,").append(" c_cos_version = :cosVersion, n_production_time = :productionTime, n_time = :time,").append(" c_senior_public = :seniorPublic, c_firmware_version = :firmwareVersion, c_init_script = :initScript").append(" WHERE c_asset_identify = :originalCardNo");
        param.addValue("assetIdentify", (Object)cardInfoArr[0].toLowerCase());
        param.addValue("cardNo", (Object)cardInfoArr[0].toLowerCase());
        param.addValue("cosVersion", (Object)cardInfoArr[1]);
        param.addValue("productionTime", (Object)DateTimeUtil.dateTimeStrToLong((String)cardInfoArr[2]));
        param.addValue("time", (Object)DateTimeUtil.getStartTime((String)cardInfoArr[3]));
        param.addValue("originalCardNo", (Object)originalCardNo);
        param.addValue("seniorPublic", (Object)cardInfoArr[4]);
        param.addValue("firmwareVersion", (Object)cardInfoArr[5]);
        param.addValue("initScript", (Object)cardInfoArr[6]);
        this.addOrUpdate(sql.toString(), new SqlParameterSource[]{param});
    }

    public void updateCertAndRelation(String originalCardNo, String sourceCardNo, String recordId, List<CertBean> certList) {
        String sql = null;
        MapSqlParameterSource param = null;
        MapSqlParameterSource[] params = new MapSqlParameterSource[certList.size()];
        StringBuffer sqlBuffer = new StringBuffer();
        param = new MapSqlParameterSource();
        param.addValue("originalCardNo", (Object)originalCardNo);
        sql = "DELETE FROM t_cert_info WHERE c_card_no = :originalCardNo";
        this.deleteBySql(sql, (SqlParameterSource)param);
        sql = "DELETE FROM t_activate_log WHERE c_card_no = :originalCardNo";
        this.deleteBySql(sql.toString(), (SqlParameterSource)param);
        sqlBuffer.append("INSERT INTO t_cert_info(n_record_id, c_card_no, c_cert_sn, n_ca_alg,");
        sqlBuffer.append(" n_cert_type, n_cert_state, c_cert, c_public_key, n_not_before, n_not_after) VALUES(");
        sqlBuffer.append(":recordId, :cardNo, :certSn, :caAlg, :certType, :certState, :cert,");
        sqlBuffer.append(" :publicKey, :notBefore, :notAfter)");
        for (int i = 0; i < certList.size(); ++i) {
            CertBean certBean = certList.get(i);
            param = new MapSqlParameterSource();
            param.addValue("recordId", (Object)recordId);
            param.addValue("cardNo", (Object)sourceCardNo);
            param.addValue("certSn", (Object)certBean.getSn());
            param.addValue("caAlg", (Object)certBean.getCaAlg());
            param.addValue("certType", (Object)certBean.getCertType());
            param.addValue("certState", (Object)certBean.getCertState());
            param.addValue("cert", (Object)certBean.getCert());
            param.addValue("publicKey", (Object)certBean.getPublicKey());
            param.addValue("notBefore", (Object)certBean.getBefore());
            param.addValue("notAfter", (Object)certBean.getAfter());
            params[i] = param;
        }
        this.addOrUpdate(sqlBuffer.toString(), (SqlParameterSource[])params);
        this.updateAssetRelation(originalCardNo, sourceCardNo);
    }

    public void updateUnLockCode(String originalCardNo, String sourceCardNo, List<String[]> unCodes) {
        StringBuffer sql = new StringBuffer();
        MapSqlParameterSource param = new MapSqlParameterSource();
        String delSql = "DELETE FROM t_terminal_unlock_code WHERE c_card_no = :sourceCardNo OR c_card_no = :originalCardNo";
        param.addValue("sourceCardNo", (Object)sourceCardNo);
        param.addValue("originalCardNo", (Object)originalCardNo);
        this.deleteBySql(delSql, (SqlParameterSource)param);
        if (!unCodes.isEmpty()) {
            String[] unlockCodeArr = unCodes.get(0);
            param = new MapSqlParameterSource();
            sql.append("INSERT INTO t_terminal_unlock_code(n_record_id, c_card_no, c_card_uid,").append(" c_unlock_code, c_disk_code, n_time) VALUES(:recordId, :sourceCardNo, :cardUid, :unlockCode, :diskCode, :time)");
            param.addValue("recordId", (Object)-2);
            param.addValue("sourceCardNo", (Object)unlockCodeArr[0].toLowerCase());
            param.addValue("cardUid", (Object)unlockCodeArr[1]);
            param.addValue("unlockCode", (Object)unlockCodeArr[2]);
            param.addValue("diskCode", (Object)unlockCodeArr[3]);
            param.addValue("time", (Object)System.currentTimeMillis());
            this.addOrUpdate(sql.toString(), new SqlParameterSource[]{param});
        }
    }

    public void updateAssetRelation(String originalCardNo, String sourceCardNo) {
        StringBuffer sql = new StringBuffer();
        MapSqlParameterSource param = new MapSqlParameterSource();
        sql.append("UPDATE t_asset_info SET c_relation_asset_identify = :sourceCardNo").append(" WHERE c_relation_asset_identify = :originalCardNo");
        param.addValue("sourceCardNo", (Object)sourceCardNo);
        param.addValue("originalCardNo", (Object)originalCardNo);
        this.addOrUpdate(sql.toString(), new SqlParameterSource[]{param});
    }

    public String findCertInfoRecordId(String cardNo) {
        Iterator iterator;
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT c_card_no AS cardno,n_record_id AS recordId FROM t_cert_info WHERE c_card_no = :cardno ");
        MapSqlParameterSource parameter = new MapSqlParameterSource();
        parameter.addValue("cardno", (Object)cardNo);
        List certInfos = this.queryForList(sqlBuffer.toString(), (SqlParameterSource)parameter, (RowMapper)new BeanPropertyRowMapper(CertInfo.class));
        if (certInfos != null && certInfos.size() > 0 && (iterator = certInfos.iterator()).hasNext()) {
            CertInfo info = (CertInfo)iterator.next();
            return info.getRecordId();
        }
        return null;
    }

    public List<String> queryCardNoByUid(String uid) {
        String sql = "SELECT c_card_no FROM t_terminal_unlock_code WHERE c_card_uid = :uid";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("uid", (Object)uid);
        return this.queryForList(sql, (SqlParameterSource)params, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString("c_card_no");
            }
        });
    }

    public List<String> saveCardAsset(List<Map<String, Object>> cardList) {
        ArrayList<String> cardNos = new ArrayList<String>();
        ArrayList<MapSqlParameterSource> params = new ArrayList<MapSqlParameterSource>();
        ArrayList<MapSqlParameterSource> certParams = new ArrayList<MapSqlParameterSource>();
        for (Map<String, Object> item : cardList) {
            String cardNo = (String)item.get("cardNo");
            cardNos.add(cardNo.toLowerCase());
            params.add(this.constructData(item));
            this.constructCerts(item, certParams);
            HashMap<String, Object> logMap = new HashMap<String, Object>();
            logMap.put("logType", 1);
            logMap.put("AssetId", cardNo);
            logMap.put("AssetType", item.get("type"));
            AMSLogRecord.logRecord(logMap);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO t_asset_info(c_asset_identify, n_record_id,");
        sql.append(" c_asset_type, c_card_no, c_serial_code, n_production_time, ");
        sql.append(" n_status, c_relation_asset_identify, c_cos_version,");
        sql.append(" c_firmware_version, c_init_script, c_senior_public, n_chip_type)");
        sql.append(" VALUES(:assetIdentify, :recordId, :assetType, :cardNo, :serialCode,");
        sql.append(" :productionTime, :status, :relationIdentify, :cosVersion,");
        sql.append(" :firmwareVersion, :initScript, :seniorPublic, :chipType)");
        this.addOrUpdate(sql.toString(), (SqlParameterSource[])params.toArray(new MapSqlParameterSource[params.size()]));
        this.delCertAndUnlockCode(cardNos);
        sql = new StringBuffer();
        sql.append("INSERT INTO t_cert_info(n_record_id, c_card_no, c_cert_sn, n_ca_alg,");
        sql.append(" n_cert_type, n_cert_state, c_cert, c_public_key, n_not_before, n_not_after) VALUES(");
        sql.append(":recordId, :cardNo, :certSn, :caAlg, :certType, :certState, :cert,");
        sql.append(" :publicKey, :notBefore, :notAfter)");
        this.addOrUpdate(sql.toString(), (SqlParameterSource[])certParams.toArray(new MapSqlParameterSource[certParams.size()]));
        return cardNos;
    }

    private MapSqlParameterSource constructModifyData(Map<String, Object> data) {
        MapSqlParameterSource child = new MapSqlParameterSource();
        child.addValue("assetType", (Object)((Integer)data.get("type")));
        child.addValue("relationIdentify", StringUtils.isBlank((CharSequence)((String)data.get("relationCardNo"))) ? null : String.valueOf(data.get("relationCardNo")).toLowerCase());
        child.addValue("identify", (Object)((String)data.get("cardNo")).toLowerCase());
        return child;
    }

    private MapSqlParameterSource constructData(Map<String, Object> data) {
        MapSqlParameterSource child = new MapSqlParameterSource();
        child.addValue("assetIdentify", (Object)((String)data.get("cardNo")).toLowerCase());
        child.addValue("recordId", (Object)-1);
        child.addValue("assetType", (Object)((Integer)data.get("type")));
        child.addValue("cardNo", (Object)((String)data.get("cardNo")).toLowerCase());
        child.addValue("serialCode", StringUtils.isNotBlank((CharSequence)((String)data.get("serialCode"))) ? (String)data.get("serialCode") : null);
        child.addValue("productionTime", (Object)DateTimeUtil.dateTimeStrToLong((String)((String)data.get("productionTime"))));
        child.addValue("status", (Object)((Integer)data.get("isActivate")));
        child.addValue("relationIdentify", null);
        child.addValue("cosVersion", (Object)((String)data.get("cosVersion")));
        child.addValue("firmwareVersion", (Object)((String)data.get("firmwareVersion")));
        child.addValue("initScript", (Object)((String)data.get("initScript")));
        child.addValue("seniorPublic", (Object)((String)data.get("seniorPublic")));
        Object obj = data.get("chipType");
        int chipType = obj == null || StringUtils.isBlank((CharSequence)obj.toString()) ? 0 : (Integer)obj;
        child.addValue("chipType", (Object)chipType);
        return child;
    }

    public List<String> saveMobileAsset(List<Map<String, Object>> mobileList, Map<String, String> relationCardNoMap) {
        ArrayList<MapSqlParameterSource> params = new ArrayList<MapSqlParameterSource>();
        ArrayList<String> cardNos = new ArrayList<String>();
        ArrayList<MapSqlParameterSource> relationParams = new ArrayList<MapSqlParameterSource>();
        final HashMap<String, MapSqlParameterSource> mobileInfoParams = new HashMap<String, MapSqlParameterSource>();
        for (Map<String, Object> item : mobileList) {
            String cardNo = ((String)item.get("cardNo")).toLowerCase();
            String relationCardNo = (String)item.get("relationCardNo");
            cardNos.add(cardNo);
            params.add(this.constructModifyData(item));
            mobileInfoParams.put(((String)item.get("cardNo")).toLowerCase(), this.constructMobileInfoData(item));
            if (StringUtils.isNotBlank((CharSequence)relationCardNo)) {
                cardNos.add(relationCardNo.toLowerCase());
                relationParams.add(this.constructReData(item));
                relationCardNoMap.put(relationCardNo.toLowerCase(), cardNo);
            }
            HashMap<String, Object> logMap = new HashMap<String, Object>();
            logMap.put("logType", 1);
            logMap.put("AssetId", cardNo);
            logMap.put("AssetType", item.get("type"));
            AMSLogRecord.logRecord(logMap);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT n_id, c_asset_identify FROM t_asset_info WHERE c_asset_identify IN (:identifyList)");
        MapSqlParameterSource child = new MapSqlParameterSource();
        child.addValue("identifyList", mobileInfoParams.keySet());
        final HashMap assetIdCardNoMap = new HashMap();
        this.queryForList(sql.toString(), (SqlParameterSource)child, (RowMapper)new RowMapper<String>(){
            long id;
            String assetIdentify;
            MapSqlParameterSource item;

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                this.id = rs.getLong("n_id");
                this.assetIdentify = rs.getString("c_asset_identify");
                this.item = (MapSqlParameterSource)mobileInfoParams.get(this.assetIdentify);
                this.item.addValue("assetId", (Object)this.id);
                assetIdCardNoMap.put(this.assetIdentify, this.id);
                return null;
            }
        });
        if (!relationParams.isEmpty()) {
            this.updateSaveMobileRelAsset(relationParams);
        }
        if (!mobileInfoParams.isEmpty()) {
            this.insertMobileAsset(mobileInfoParams);
        }
        if (!params.isEmpty()) {
            this.updateMobileAssetType(params);
        }
        return cardNos;
    }

    private void updateMobileAssetType(List<MapSqlParameterSource> params) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE t_asset_info SET c_asset_type = :assetType,").append(" c_relation_asset_identify = :relationIdentify").append(" WHERE c_asset_identify = :identify");
        MapSqlParameterSource[] param = new MapSqlParameterSource[params.size()];
        this.addOrUpdate(sql.toString(), (SqlParameterSource[])params.toArray(param));
    }

    private void insertMobileAsset(Map<String, MapSqlParameterSource> mobileInfoParams) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO t_asset_mobiles_info(n_asset_id, n_record_id, c_model, c_imei, c_sn_no)");
        sql.append(" VALUES(:assetId, :recordId, :model, :imei, :snNo)");
        MapSqlParameterSource[] tempParams = new MapSqlParameterSource[mobileInfoParams.size()];
        this.addOrUpdate(sql.toString(), (SqlParameterSource[])mobileInfoParams.values().toArray(tempParams));
    }

    private void updateSaveMobileRelAsset(List<MapSqlParameterSource> relationParams) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE t_asset_info SET c_relation_asset_identify = :identify").append(" WHERE c_asset_identify = :relationIdentify");
        MapSqlParameterSource[] param = new MapSqlParameterSource[relationParams.size()];
        this.addOrUpdate(sql.toString(), (SqlParameterSource[])relationParams.toArray(param));
    }

    private MapSqlParameterSource constructReData(Map<String, Object> data) {
        MapSqlParameterSource child = new MapSqlParameterSource();
        child.addValue("relationIdentify", (Object)((String)data.get("relationCardNo")).toLowerCase());
        child.addValue("identify", (Object)((String)data.get("cardNo")).toLowerCase());
        return child;
    }

    private MapSqlParameterSource constructReDataUsbkey(Map<String, Object> data) {
        MapSqlParameterSource child = new MapSqlParameterSource();
        child.addValue("relationIdentify", (Object)((String)data.get("cardNo")).toLowerCase());
        child.addValue("identify", (Object)((String)data.get("relationCardNo")).toLowerCase());
        return child;
    }

    public List<String> updateMobileAsset(List<Map<String, Object>> mobileList, Map<String, String> relationCardNoMap) {
        final HashMap<String, MapSqlParameterSource> mobileInfoParams = new HashMap<String, MapSqlParameterSource>();
        final ArrayList<String> cardNos = new ArrayList<String>();
        ArrayList<String> relationCardNos = new ArrayList<String>();
        ArrayList<MapSqlParameterSource> phoneParams = new ArrayList<MapSqlParameterSource>();
        ArrayList<MapSqlParameterSource> usbkeyParams = new ArrayList<MapSqlParameterSource>();
        try {
            MapSqlParameterSource[] param;
            for (Map<String, Object> item : mobileList) {
                String cardNo = ((String)item.get("cardNo")).toLowerCase();
                cardNos.add(cardNo);
                mobileInfoParams.put(cardNo, this.assembleMobileParam(item));
                String relationCardNo = (String)item.get("relationCardNo");
                if (StringUtils.isNotBlank((CharSequence)relationCardNo)) {
                    cardNos.add(relationCardNo.toLowerCase());
                    relationCardNos.add(relationCardNo.toLowerCase());
                    phoneParams.add(this.constructReData(item));
                    usbkeyParams.add(this.constructReDataUsbkey(item));
                    relationCardNoMap.put(relationCardNo.toLowerCase(), cardNo);
                }
                HashMap<String, Object> logMap = new HashMap<String, Object>();
                logMap.put("logType", 3);
                logMap.put("AssetId", cardNo);
                AMSLogRecord.logRecord(logMap);
            }
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT n_id, c_asset_identify, c_relation_asset_identify FROM t_asset_info WHERE c_asset_identify IN (:identifyList)");
            MapSqlParameterSource child = new MapSqlParameterSource();
            child.addValue("identifyList", mobileInfoParams.keySet());
            final ArrayList usbkeyRelationParams = new ArrayList();
            this.queryForList(sql.toString(), (SqlParameterSource)child, (RowMapper)new RowMapper<String>(){
                long id;
                String assetIdentify;
                String relationAssetIdentify;
                MapSqlParameterSource item;

                public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                    this.id = rs.getLong("n_id");
                    this.assetIdentify = rs.getString("c_asset_identify");
                    this.relationAssetIdentify = rs.getString("c_relation_asset_identify");
                    this.item = (MapSqlParameterSource)mobileInfoParams.get(this.assetIdentify);
                    this.item.addValue("assetId", (Object)this.id);
                    if (StringUtils.isNotBlank((CharSequence)this.relationAssetIdentify)) {
                        usbkeyRelationParams.add(new MapSqlParameterSource().addValue("identify", (Object)this.relationAssetIdentify));
                        cardNos.add(this.relationAssetIdentify);
                    }
                    return null;
                }
            });
            if (!relationCardNos.isEmpty()) {
                sql = new StringBuffer();
                sql.append("SELECT c_relation_asset_identify FROM t_asset_info WHERE c_asset_identify IN (:identifyList)");
                this.queryForList(sql.toString(), (SqlParameterSource)new MapSqlParameterSource().addValue("identifyList", relationCardNos), (RowMapper)new RowMapper<String>(){

                    public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                        String relationAssetIdentify = rs.getString("c_relation_asset_identify");
                        if (StringUtils.isNotBlank((CharSequence)relationAssetIdentify)) {
                            usbkeyRelationParams.add(new MapSqlParameterSource().addValue("identify", (Object)relationAssetIdentify));
                            cardNos.add(relationAssetIdentify);
                        }
                        return null;
                    }
                });
            }
            if (!usbkeyRelationParams.isEmpty()) {
                param = new MapSqlParameterSource[usbkeyRelationParams.size()];
                this.addOrUpdate("UPDATE t_asset_info SET c_relation_asset_identify = NULL WHERE c_asset_identify = :identify", (SqlParameterSource[])usbkeyRelationParams.toArray(param));
            }
            if (!relationCardNos.isEmpty()) {
                this.updateSaveMobileRelAsset(usbkeyParams);
                this.updateSaveMobileRelAsset(phoneParams);
            }
            sql = new StringBuffer();
            sql.append("UPDATE t_asset_mobiles_info SET c_sn_no = :snNo, c_model = :model, c_imei = :imei WHERE n_asset_id = :assetId");
            param = new MapSqlParameterSource[mobileInfoParams.size()];
            this.addOrUpdate(sql.toString(), (SqlParameterSource[])mobileInfoParams.values().toArray(param));
        }
        catch (Exception e) {
            this.logger.error("\u6279\u91cf\u66f4\u65b0\u8d44\u4ea7\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
        }
        return cardNos;
    }

    private MapSqlParameterSource assembleMobileParam(Map<String, Object> item) {
        MapSqlParameterSource param = new MapSqlParameterSource();
        param.addValue("model", (Object)((String)item.get("model")));
        param.addValue("imei", (Object)((String)item.get("imei")));
        param.addValue("snNo", (Object)((String)item.get("sn")));
        return param;
    }

    public List<String> updateCardAsset(List<Map<String, Object>> cardList) {
        HashMap<String, MapSqlParameterSource> unLockCodeParams = new HashMap<String, MapSqlParameterSource>();
        ArrayList<MapSqlParameterSource> cardParams = new ArrayList<MapSqlParameterSource>();
        ArrayList<String> cardNos = new ArrayList<String>();
        for (Map<String, Object> item : cardList) {
            String cardNo = ((String)item.get("cardNo")).toLowerCase();
            cardNos.add(cardNo);
            cardParams.add(this.assembleUpdateCard(item));
            unLockCodeParams.put(cardNo, this.assembleUnlockCode(item));
            HashMap<String, Object> logMap = new HashMap<String, Object>();
            logMap.put("logType", 3);
            logMap.put("AssetId", cardNo);
            AMSLogRecord.logRecord(logMap);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE t_asset_info SET  c_firmware_version = :firmwareVersion, c_init_script = :initScript,").append(" c_senior_public = :seniorPublic, c_serial_code = :serialCode, c_cos_version = :cosVersion,").append(" n_production_time = :productionTime WHERE c_asset_identify = :cardNo");
        MapSqlParameterSource[] param = new MapSqlParameterSource[cardParams.size()];
        this.addOrUpdate(sql.toString(), (SqlParameterSource[])cardParams.toArray(param));
        return cardNos;
    }

    private MapSqlParameterSource assembleUnlockCode(Map<String, Object> item) {
        MapSqlParameterSource param = new MapSqlParameterSource();
        param.addValue("recordId", (Object)-1);
        param.addValue("cardNo", (Object)((String)item.get("cardNo")).toLowerCase());
        param.addValue("cardUId", (Object)((String)item.get("uId")));
        param.addValue("unLockCode", (Object)((String)item.get("unlockCode")));
        param.addValue("diskCode", StringUtils.isBlank((CharSequence)((String)item.get("diskCode"))) ? null : (String)item.get("diskCode"));
        param.addValue("time", (Object)System.currentTimeMillis());
        return param;
    }

    private MapSqlParameterSource assembleUpdateCard(Map<String, Object> item) {
        MapSqlParameterSource param = new MapSqlParameterSource();
        param.addValue("cardNo", (Object)((String)item.get("cardNo")).toLowerCase());
        param.addValue("firmwareVersion", StringUtils.isBlank((CharSequence)((String)item.get("firmwareVersion"))) ? null : (String)item.get("firmwareVersion"));
        param.addValue("initScript", StringUtils.isBlank((CharSequence)((String)item.get("initScript"))) ? null : (String)item.get("initScript"));
        param.addValue("serialCode", StringUtils.isBlank((CharSequence)((String)item.get("serialCode"))) ? null : (String)item.get("serialCode"));
        param.addValue("cosVersion", (Object)((String)item.get("cosVersion")));
        param.addValue("productionTime", (Object)DateTimeUtil.dateTimeStrToLong((String)((String)item.get("productionTime"))));
        param.addValue("seniorPublic", StringUtils.isBlank((CharSequence)((String)item.get("seniorPublic"))) ? null : (String)item.get("seniorPublic"));
        param.addValue("isActivate", item.get("isActivate"));
        return param;
    }

    public Map<String, String> checkUidCardNoExist(ArrayList<String> uidList) {
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = "SELECT c_card_uid, c_card_no FROM t_terminal_unlock_code WHERE c_card_uid IN (:uidList)";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("uidList", uidList);
        List list = this.queryForList(sql.toString(), (SqlParameterSource)params);
        if (list != null && list.size() > 0) {
            for (Map temp : list) {
                map.put((String)temp.get("c_card_uid"), (String)temp.get("c_card_no"));
            }
        }
        return map;
    }

    public Map<String, String> checkMobileSnCardNoExist(ArrayList<String> snList) {
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = "SELECT mobile.c_sn_no, asset.c_asset_identify FROM t_asset_mobiles_info mobile LEFT JOIN t_asset_info asset ON mobile.n_asset_id = asset.n_id WHERE c_sn_no IN (:snList)";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("snList", snList);
        List list = this.queryForList(sql.toString(), (SqlParameterSource)params);
        if (list != null && list.size() > 0) {
            for (Map temp : list) {
                map.put((String)temp.get("c_sn_no"), (String)temp.get("c_asset_identify"));
            }
        }
        return map;
    }

    public Map<String, String> checkMobileImeiCardNoExist(ArrayList<String> imeiList) {
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = "SELECT mobile.c_imei, asset.c_asset_identify FROM t_asset_mobiles_info mobile LEFT JOIN t_asset_info asset ON mobile.n_asset_id = asset.n_id WHERE c_imei IN (:imeiList)";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("imeiList", imeiList);
        List list = this.queryForList(sql.toString(), (SqlParameterSource)params);
        if (list != null && list.size() > 0) {
            for (Map temp : list) {
                map.put((String)temp.get("c_imei"), (String)temp.get("c_asset_identify"));
            }
        }
        return map;
    }

    public Map<String, String> checkAssetTypeExist(ArrayList<String> cardNoList) {
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = "SELECT c_asset_identify, c_asset_type FROM t_asset_info WHERE c_asset_identify IN (:identifyList)";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("identifyList", cardNoList);
        List list = this.queryForList(sql.toString(), (SqlParameterSource)params);
        if (list != null && list.size() > 0) {
            for (Map temp : list) {
                map.put((String)temp.get("c_asset_identify"), (String)temp.get("c_asset_type"));
            }
        }
        return map;
    }

    private MapSqlParameterSource assembleProducts(Map<String, Object> item, Long customerId) {
        MapSqlParameterSource param = new MapSqlParameterSource();
        param.addValue("customerId", (Object)customerId);
        param.addValue("norms", StringUtils.isBlank((CharSequence)((String)item.get("norms"))) ? null : (String)item.get("norms"));
        param.addValue("activeLimitTime", StringUtils.isBlank((CharSequence)((String)item.get("activeLimitTime"))) ? null : Long.valueOf(DateTimeUtil.dateTimeStrToLong((String)((String)item.get("activeLimitTime")))));
        param.addValue("leaveFactoryTime", (Object)DateTimeUtil.dateStrToDate((String)((String)item.get("leaveFactoryTime"))).getTime());
        param.addValue("cardNo", (Object)((String)item.get("cardNo")).toLowerCase());
        return param;
    }

    public void updateProducts(List<Map<String, Object>> cardList, Map<String, Long> customerInfo, Map<String, Long> orderInfo, Map<String, String> orderTypeMap, List<String> cardNos, Map<String, String> correctOrderCustomerMap, Map<String, String> correctOrderActivateDeadlineMap) {
        ArrayList<MapSqlParameterSource> cardParams = new ArrayList<MapSqlParameterSource>();
        HashMap<String, String> orderMap = new HashMap<String, String>();
        for (Map<String, Object> item : cardList) {
            String orderName;
            HashMap<String, Integer> logMap = new HashMap<String, Integer>();
            logMap.put("logType", 2);
            String cardNo = ((String)item.get("cardNo")).toLowerCase();
            String orderDepartment = ((String)item.get("orderOrigin")).toLowerCase();
            if (orderDepartment.equals("\u6218\u7565\u5e02\u573a\u90e8")) {
                orderName = ((String)item.get("orderCode")).toUpperCase();
            } else {
                String orderType = orderTypeMap.get(cardNo.toLowerCase());
                orderName = item.get("project").toString().trim().substring(orderType.length(), orderType.length() + (Integer)Constants.CUSTOMER_ORDER_TYPE.get(orderType));
            }
            if (correctOrderActivateDeadlineMap.containsKey(orderName)) {
                String activeLimitTime = correctOrderActivateDeadlineMap.get(orderName);
                if (activeLimitTime != null && !activeLimitTime.isEmpty()) {
                    item.put("activeLimitTime", activeLimitTime);
                } else {
                    item.put("activeLimitTime", null);
                }
            } else {
                item.put("activeLimitTime", null);
            }
            Long customerId = customerInfo.get(correctOrderCustomerMap.get(orderName));
            orderMap.put(cardNo.toLowerCase(), orderName);
            cardNos.add(cardNo);
            cardParams.add(this.assembleProducts(item, customerId));
        }
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE t_asset_info SET n_customer_id = :customerId, c_norms = :norms,").append(" n_activate_deadline_time = :activeLimitTime, n_time = :leaveFactoryTime WHERE c_asset_identify = :cardNo");
        MapSqlParameterSource[] param = new MapSqlParameterSource[cardParams.size()];
        this.addOrUpdate(sql.toString(), (SqlParameterSource[])cardParams.toArray(param));
        this.updateOrderAsset(cardNos, orderMap, orderInfo);
    }

    public void updateProducts2(List<Map<String, Object>> cardList, Map<String, Long> customerInfo, Map<String, String> orderActivateDeadlineMap, Map<String, Long> orderInfo, Map<String, String> orderTypeMap, List<String> cardNos, Map<String, String> correctOrderCustomerMap) {
        ArrayList<MapSqlParameterSource> cardParams = new ArrayList<MapSqlParameterSource>();
        HashMap<String, String> orderMap = new HashMap<String, String>();
        for (Map<String, Object> item : cardList) {
            String activeLimitTime;
            String orderName;
            HashMap<String, Integer> logMap = new HashMap<String, Integer>();
            logMap.put("logType", 2);
            String cardNo = ((String)item.get("cardNo")).toLowerCase();
            String orderDepartment = ((String)item.get("orderOrigin")).toLowerCase();
            if (orderDepartment.equals("\u6218\u7565\u5e02\u573a\u90e8")) {
                orderName = ((String)item.get("orderCode")).toUpperCase();
            } else {
                String orderType = orderTypeMap.get(cardNo.toLowerCase());
                orderName = item.get("project").toString().trim().substring(orderType.length(), orderType.length() + (Integer)Constants.CUSTOMER_ORDER_TYPE.get(orderType));
            }
            if (orderActivateDeadlineMap.containsKey(orderName) && (activeLimitTime = orderActivateDeadlineMap.get(orderName)) != null && !activeLimitTime.isEmpty()) {
                item.put("activeLimitTime", activeLimitTime);
            }
            Long customerId = customerInfo.get(correctOrderCustomerMap.get(orderName));
            orderMap.put(cardNo.toLowerCase(), orderName);
            cardNos.add(cardNo);
            cardParams.add(this.assembleProducts(item, customerId));
        }
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE t_asset_info SET n_customer_id = :customerId, c_norms = :norms,").append(" n_activate_deadline_time =:activeLimitTime, n_time = :leaveFactoryTime WHERE c_asset_identify = :cardNo");
        MapSqlParameterSource[] param = new MapSqlParameterSource[cardParams.size()];
        this.addOrUpdate(sql.toString(), (SqlParameterSource[])cardParams.toArray(param));
        this.updateOrderAsset(cardNos, orderMap, orderInfo);
    }

    public void updateBakProducts(List<Map<String, Object>> cardList, Map<String, Long> customerInfo, Map<String, Long> orderInfo, Map<String, String> orderTypeMap, Map<String, String> correctProjectMap) {
        ArrayList<MapSqlParameterSource> cardParams = new ArrayList<MapSqlParameterSource>();
        HashMap<String, String> orderMap = new HashMap<String, String>();
        ArrayList<String> cardNos = new ArrayList<String>();
        for (Map<String, Object> item : cardList) {
            String orderName;
            HashMap<String, Integer> logMap = new HashMap<String, Integer>();
            logMap.put("logType", 2);
            String cardNo = ((String)item.get("cardNo")).toLowerCase();
            String orderDepartment = ((String)item.get("orderOrigin")).toLowerCase();
            if (orderDepartment.equals("\u6218\u7565\u5e02\u573a\u90e8")) {
                orderName = ((String)item.get("orderCode")).toUpperCase();
            } else {
                String orderType = orderTypeMap.get(cardNo.toLowerCase());
                orderName = item.get("project").toString().trim().substring(orderType.length(), orderType.length() + (Integer)Constants.CUSTOMER_ORDER_TYPE.get(orderType));
            }
            Long customerId = customerInfo.get(correctProjectMap.get(orderName));
            orderMap.put(cardNo.toLowerCase(), orderName);
            cardNos.add(cardNo);
            MapSqlParameterSource paramTemp = new MapSqlParameterSource();
            paramTemp.addValue("customerId", (Object)customerId);
            paramTemp.addValue("leaveFactoryTime", (Object)DateTimeUtil.dateStrToDate((String)((String)item.get("leaveFactoryTime"))).getTime());
            paramTemp.addValue("bakcardSn", (Object)((String)item.get("cardNo")).toLowerCase());
            cardParams.add(paramTemp);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE t_bakcard_info SET n_customer_id = :customerId,").append(" n_time = :leaveFactoryTime WHERE c_bakcard_sn = :bakcardSn");
        MapSqlParameterSource[] param = new MapSqlParameterSource[cardParams.size()];
        this.addOrUpdate(sql.toString(), (SqlParameterSource[])cardParams.toArray(param));
        this.updateBakOrderAsset(cardNos, orderMap, orderInfo);
    }

    private void updateBakOrderAsset(List<String> cardNos, final Map<String, String> orderMap, final Map<String, Long> orderInfo) {
        if (!cardNos.isEmpty()) {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT n_id, c_bakcard_sn FROM t_bakcard_info WHERE c_bakcard_sn IN (:identifyList)");
            MapSqlParameterSource child = new MapSqlParameterSource();
            child.addValue("identifyList", cardNos);
            final ArrayList<Long> assetIds = new ArrayList<Long>();
            final ArrayList paramList = new ArrayList();
            this.queryForList(sql.toString(), (SqlParameterSource)child, (RowMapper)new RowMapper<String>(){
                MapSqlParameterSource parameter = null;
                String bakCardSn = null;
                long id = 0L;

                public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                    this.id = rs.getLong("n_id");
                    this.bakCardSn = rs.getString("c_bakcard_sn");
                    this.parameter = new MapSqlParameterSource();
                    this.parameter.addValue("orderId", orderInfo.get(orderMap.get(this.bakCardSn)));
                    this.parameter.addValue("bakupcardId", (Object)this.id);
                    paramList.add(this.parameter);
                    assetIds.add(this.id);
                    return null;
                }
            });
            this.delBakOrderAsset(assetIds);
            StringBuffer sqlOrderAsset = new StringBuffer();
            sqlOrderAsset.append("INSERT INTO t_order_bakcard(n_order_id, n_bakupcard_id)");
            sqlOrderAsset.append(" VALUES(:orderId, :bakupcardId)");
            MapSqlParameterSource[] param1 = new MapSqlParameterSource[paramList.size()];
            this.addOrUpdate(sqlOrderAsset.toString(), (SqlParameterSource[])paramList.toArray(param1));
        }
    }

    private void delBakOrderAsset(List<Long> id) {
        MapSqlParameterSource dParams = new MapSqlParameterSource();
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM t_order_bakcard WHERE n_bakupcard_id IN (:bakupcardId)");
        dParams.addValue("bakupcardId", id);
        this.deleteBySql(sql.toString(), (SqlParameterSource)dParams);
    }

    private void delOrderAsset(List<Long> id) {
        MapSqlParameterSource dParams = new MapSqlParameterSource();
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM t_order_asset WHERE n_asset_id IN (:assetId)");
        dParams.addValue("assetId", id);
        this.deleteBySql(sql.toString(), (SqlParameterSource)dParams);
    }

    private void updateOrderAsset(List<String> cardNos, final Map<String, String> orderMap, final Map<String, Long> orderInfo) {
        if (!cardNos.isEmpty()) {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT n_id, c_asset_identify FROM t_asset_info WHERE c_asset_identify IN (:identifyList)");
            MapSqlParameterSource child = new MapSqlParameterSource();
            child.addValue("identifyList", cardNos);
            final ArrayList<Long> assetIds = new ArrayList<Long>();
            final ArrayList paramList = new ArrayList();
            this.queryForList(sql.toString(), (SqlParameterSource)child, (RowMapper)new RowMapper<String>(){
                MapSqlParameterSource parameter = null;
                String identify = null;
                long id = 0L;

                public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                    this.id = rs.getLong("n_id");
                    this.identify = rs.getString("c_asset_identify");
                    this.parameter = new MapSqlParameterSource();
                    this.parameter.addValue("orderId", orderInfo.get(orderMap.get(this.identify)));
                    this.parameter.addValue("assetId", (Object)this.id);
                    paramList.add(this.parameter);
                    assetIds.add(this.id);
                    return null;
                }
            });
            this.delOrderAsset(assetIds);
            StringBuffer sqlOrderAsset = new StringBuffer();
            sqlOrderAsset.append("INSERT INTO t_order_asset(n_order_id, n_asset_id)");
            sqlOrderAsset.append(" VALUES(:orderId, :assetId)");
            MapSqlParameterSource[] param1 = new MapSqlParameterSource[paramList.size()];
            this.addOrUpdate(sqlOrderAsset.toString(), (SqlParameterSource[])paramList.toArray(param1));
        }
    }

    public Map<String, TAssetHistory> queryHisAsset2(List<String> cardNoList) {
        final HashMap<String, TAssetHistory> assetMap = new HashMap<String, TAssetHistory>();
        MapSqlParameterSource params = new MapSqlParameterSource();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT info.n_customer_id AS customerId, info.c_asset_identify AS assetIdentify,info.c_asset_type AS assetType,");
        sqlBuffer.append(" info.c_serial_code AS serialCode, info.n_time AS time, info.n_production_time AS productionTime,");
        sqlBuffer.append(" info.c_relation_asset_identify AS relationAssetIdentify, info.n_status AS status, info.c_norms AS norms,");
        sqlBuffer.append(" info.c_firmware_version AS firmwareVersion, info.c_init_script AS initScript,");
        sqlBuffer.append(" info.c_senior_public AS seniorPublic, info.c_cos_version AS cosVersion, info.n_chip_type chipType ");
        sqlBuffer.append(" FROM t_asset_info info ");
        sqlBuffer.append(" WHERE c_asset_identify IN (:cardNoList)");
        params.addValue("cardNoList", cardNoList);
        this.queryForList(sqlBuffer.toString(), (SqlParameterSource)params, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                TAssetHistory assetHis = new TAssetHistory();
                String cardNo = rs.getString("assetIdentify");
                assetHis.setAssetIdentify(cardNo);
                assetHis.setCustomerId(Long.valueOf(rs.getLong("customerId")));
                assetHis.setAssetType(rs.getString("assetType"));
                assetHis.setSerialCode(rs.getString("serialCode"));
                assetHis.setTime(Long.valueOf(rs.getLong("time")));
                assetHis.setProductionTime(Long.valueOf(rs.getLong("productionTime")));
                assetHis.setRelationAssetIdentify(rs.getString("relationAssetIdentify"));
                assetHis.setStatus(Integer.valueOf(rs.getInt("status")));
                assetHis.setNorms(rs.getString("norms"));
                assetHis.setFirmwareVersion(rs.getString("firmwareVersion"));
                assetHis.setInitScript(rs.getString("initScript"));
                assetHis.setSeniorPublic(rs.getString("seniorPublic"));
                assetHis.setCosVersion(rs.getString("cosVersion"));
                assetHis.setChipType(Integer.valueOf(rs.getInt("chipType")));
                assetMap.put(cardNo, assetHis);
                return null;
            }
        });
        sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT asset.c_asset_identify AS assetIdentify, mobile.c_model AS model, mobile.c_os_name AS osName,");
        sqlBuffer.append(" mobile.c_os_version AS osVersion, mobile.c_chip_code AS chipCode, mobile.c_imei AS imei, c_sn_no AS snNo");
        sqlBuffer.append(" FROM t_asset_mobiles_info mobile ");
        sqlBuffer.append(" JOIN t_asset_info asset ON asset.n_id = mobile.n_asset_id ");
        sqlBuffer.append(" WHERE asset.c_asset_identify IN (:cardNoList)");
        this.queryForList(sqlBuffer.toString(), (SqlParameterSource)params, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                String cardNo = rs.getString("assetIdentify");
                if (assetMap.get(cardNo) != null) {
                    TAssetHistory assetHis = (TAssetHistory)assetMap.get(cardNo);
                    assetHis.setModel(rs.getString("model"));
                    assetHis.setOsName(rs.getString("osName"));
                    assetHis.setOsVersion(rs.getString("osVersion"));
                    assetHis.setChipCode(rs.getString("chipCode"));
                    assetHis.setImei(rs.getString("imei"));
                    assetHis.setSnNo(rs.getString("snNo"));
                }
                return null;
            }
        });
        sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT cert.c_card_no AS assetIdentify,");
        sqlBuffer.append(" cert.n_ca_alg AS caAlg, cert.n_cert_type AS certType, cert.c_cert AS cert, cert.c_cert_sn AS certSn");
        sqlBuffer.append(" FROM t_cert_info cert ");
        sqlBuffer.append(" WHERE cert.c_card_no IN (:cardNoList)");
        this.queryForList(sqlBuffer.toString(), (SqlParameterSource)params, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                String cardNo = rs.getString("assetIdentify");
                if (assetMap.get(cardNo) != null) {
                    TAssetHistory assetHis = (TAssetHistory)assetMap.get(cardNo);
                    if (rs.getInt("caAlg") == 2 && rs.getInt("certType") == 2) {
                        assetHis.setSm2SignCert(rs.getString("cert"));
                        assetHis.setSm2SignCertSn(rs.getString("certSn"));
                    } else if (rs.getInt("caAlg") == 2 && rs.getInt("certType") == 1) {
                        assetHis.setSm2EncCert(rs.getString("cert"));
                        assetHis.setSm2EncCertSn(rs.getString("certSn"));
                    } else if (rs.getInt("caAlg") == 1 && rs.getInt("certType") == 2) {
                        assetHis.setRsaSignCert(rs.getString("cert"));
                        assetHis.setRsaSignCertSn(rs.getString("certSn"));
                    } else if (rs.getInt("caAlg") == 1 && rs.getInt("certType") == 1) {
                        assetHis.setRsaEncCert(rs.getString("cert"));
                        assetHis.setRsaEncCertSn(rs.getString("certSn"));
                    }
                }
                return null;
            }
        });
        sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT c_card_no AS assetIdentify,c_card_uid AS cardUid, c_unlock_code AS unlockCode,");
        sqlBuffer.append(" c_disk_code AS diskCode FROM t_terminal_unlock_code");
        sqlBuffer.append(" WHERE c_card_no IN (:cardNoList)");
        this.queryForList(sqlBuffer.toString(), (SqlParameterSource)params, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                String cardNo = rs.getString("assetIdentify");
                if (assetMap.get(cardNo) != null) {
                    TAssetHistory assetHis = (TAssetHistory)assetMap.get(cardNo);
                    assetHis.setCardUid(rs.getString("cardUid"));
                    assetHis.setUnlockCode(rs.getString("unlockCode"));
                    assetHis.setDiskCode(rs.getString("diskCode"));
                }
                return null;
            }
        });
        sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT asset.c_asset_identify AS assetIdentify, oder.n_order_id AS orderId");
        sqlBuffer.append(" FROM t_asset_info asset");
        sqlBuffer.append(" LEFT JOIN t_order_asset oder ON oder.n_asset_id = asset.n_id");
        sqlBuffer.append(" WHERE asset.c_asset_identify IN (:cardNoList)");
        this.queryForList(sqlBuffer.toString(), (SqlParameterSource)params, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                String cardNo = rs.getString("assetIdentify");
                if (assetMap.get(cardNo) != null) {
                    TAssetHistory assetHis = (TAssetHistory)assetMap.get(cardNo);
                    assetHis.setOrderId(Long.valueOf(rs.getLong("orderId")));
                }
                return null;
            }
        });
        return assetMap;
    }

    public Map<String, TAssetHistory> queryHisAsset(List<String> cardNoList, Integer algType) {
        final HashMap<String, TAssetHistory> assetMap = new HashMap<String, TAssetHistory>();
        MapSqlParameterSource params = new MapSqlParameterSource();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT info.n_customer_id AS customerId, info.c_asset_identify AS assetIdentify,info.c_asset_type AS assetType,");
        sqlBuffer.append(" info.c_serial_code AS serialCode, info.n_time AS time, info.n_production_time AS productionTime,");
        sqlBuffer.append(" info.c_relation_asset_identify AS relationAssetIdentify, info.n_status AS status, info.c_norms AS norms,");
        sqlBuffer.append(" info.c_firmware_version AS firmwareVersion, info.c_init_script AS initScript,");
        sqlBuffer.append(" info.c_senior_public AS seniorPublic, info.c_cos_version AS cosVersion,info.n_chip_type AS chipType ");
        sqlBuffer.append(" FROM t_asset_info info ");
        sqlBuffer.append(" WHERE c_asset_identify IN (:cardNoList)");
        params.addValue("cardNoList", cardNoList);
        this.queryForList(sqlBuffer.toString(), (SqlParameterSource)params, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                TAssetHistory assetHis = new TAssetHistory();
                String cardNo = rs.getString("assetIdentify");
                assetHis.setAssetIdentify(cardNo);
                assetHis.setCustomerId(Long.valueOf(rs.getLong("customerId")));
                assetHis.setAssetType(rs.getString("assetType"));
                assetHis.setSerialCode(rs.getString("serialCode"));
                assetHis.setTime(Long.valueOf(rs.getLong("time")));
                assetHis.setProductionTime(Long.valueOf(rs.getLong("productionTime")));
                assetHis.setRelationAssetIdentify(rs.getString("relationAssetIdentify"));
                assetHis.setStatus(Integer.valueOf(rs.getInt("status")));
                assetHis.setNorms(rs.getString("norms"));
                assetHis.setFirmwareVersion(rs.getString("firmwareVersion"));
                assetHis.setInitScript(rs.getString("initScript"));
                assetHis.setSeniorPublic(rs.getString("seniorPublic"));
                assetHis.setCosVersion(rs.getString("cosVersion"));
                assetHis.setChipType(Integer.valueOf(rs.getInt("chipType")));
                assetMap.put(cardNo, assetHis);
                return null;
            }
        });
        sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT asset.c_asset_identify AS assetIdentify, mobile.c_model AS model, mobile.c_os_name AS osName,");
        sqlBuffer.append(" mobile.c_os_version AS osVersion, mobile.c_chip_code AS chipCode, mobile.c_imei AS imei, c_sn_no AS snNo");
        sqlBuffer.append(" FROM t_asset_mobiles_info mobile ");
        sqlBuffer.append(" JOIN t_asset_info asset ON asset.n_id = mobile.n_asset_id ");
        sqlBuffer.append(" WHERE asset.c_asset_identify IN (:cardNoList)");
        this.queryForList(sqlBuffer.toString(), (SqlParameterSource)params, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                String cardNo = rs.getString("assetIdentify");
                if (assetMap.get(cardNo) != null) {
                    TAssetHistory assetHis = (TAssetHistory)assetMap.get(cardNo);
                    assetHis.setModel(rs.getString("model"));
                    assetHis.setOsName(rs.getString("osName"));
                    assetHis.setOsVersion(rs.getString("osVersion"));
                    assetHis.setChipCode(rs.getString("chipCode"));
                    assetHis.setImei(rs.getString("imei"));
                    assetHis.setSnNo(rs.getString("snNo"));
                }
                return null;
            }
        });
        sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT cert.c_card_no AS assetIdentify,");
        sqlBuffer.append(" cert.n_ca_alg AS caAlg, cert.n_cert_type AS certType, cert.c_cert AS cert, cert.c_cert_sn AS certSn");
        sqlBuffer.append(" FROM t_cert_info cert ");
        sqlBuffer.append(" WHERE cert.c_card_no IN (:cardNoList) ");
        if (null != algType) {
            sqlBuffer.append("AND n_ca_alg = :algType ");
            params.addValue("algType", (Object)algType);
        }
        this.queryForList(sqlBuffer.toString(), (SqlParameterSource)params, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                String cardNo = rs.getString("assetIdentify");
                if (assetMap.get(cardNo) != null) {
                    TAssetHistory assetHis = (TAssetHistory)assetMap.get(cardNo);
                    if (rs.getInt("caAlg") == 2 && rs.getInt("certType") == 2) {
                        assetHis.setSm2SignCert(rs.getString("cert"));
                        assetHis.setSm2SignCertSn(rs.getString("certSn"));
                    } else if (rs.getInt("caAlg") == 2 && rs.getInt("certType") == 1) {
                        assetHis.setSm2EncCert(rs.getString("cert"));
                        assetHis.setSm2EncCertSn(rs.getString("certSn"));
                    } else if (rs.getInt("caAlg") == 1 && rs.getInt("certType") == 2) {
                        assetHis.setRsaSignCert(rs.getString("cert"));
                        assetHis.setRsaSignCertSn(rs.getString("certSn"));
                    } else if (rs.getInt("caAlg") == 1 && rs.getInt("certType") == 1) {
                        assetHis.setRsaEncCert(rs.getString("cert"));
                        assetHis.setRsaEncCertSn(rs.getString("certSn"));
                    }
                }
                return null;
            }
        });
        sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT c_card_no AS assetIdentify,c_card_uid AS cardUid, c_unlock_code AS unlockCode,");
        sqlBuffer.append(" c_disk_code AS diskCode FROM t_terminal_unlock_code");
        sqlBuffer.append(" WHERE c_card_no IN (:cardNoList)");
        this.queryForList(sqlBuffer.toString(), (SqlParameterSource)params, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                String cardNo = rs.getString("assetIdentify");
                if (assetMap.get(cardNo) != null) {
                    TAssetHistory assetHis = (TAssetHistory)assetMap.get(cardNo);
                    assetHis.setCardUid(rs.getString("cardUid"));
                    assetHis.setUnlockCode(rs.getString("unlockCode"));
                    assetHis.setDiskCode(rs.getString("diskCode"));
                }
                return null;
            }
        });
        sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT asset.c_asset_identify AS assetIdentify, oder.n_order_id AS orderId");
        sqlBuffer.append(" FROM t_asset_info asset");
        sqlBuffer.append(" LEFT JOIN t_order_asset oder ON oder.n_asset_id = asset.n_id");
        sqlBuffer.append(" WHERE asset.c_asset_identify IN (:cardNoList)");
        this.queryForList(sqlBuffer.toString(), (SqlParameterSource)params, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                String cardNo = rs.getString("assetIdentify");
                if (assetMap.get(cardNo) != null) {
                    TAssetHistory assetHis = (TAssetHistory)assetMap.get(cardNo);
                    assetHis.setOrderId(Long.valueOf(rs.getLong("orderId")));
                }
                return null;
            }
        });
        return assetMap;
    }

    public Map<String, String> queryCertSn(List<String> snList) {
        String sql = "SELECT c_cert_sn, c_card_no FROM t_cert_info WHERE c_cert_sn IN (:snList)";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("snList", snList);
        final HashMap<String, String> assetMap = new HashMap<String, String>();
        this.queryForList(sql, (SqlParameterSource)params, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                assetMap.put(rs.getString("c_cert_sn"), rs.getString("c_card_no"));
                return null;
            }
        });
        return assetMap;
    }

    public void queryOrderCustomer(ArrayList<String> orderList, final Map<String, String> orderCustomerMap) {
        StringBuffer sql = new StringBuffer("SELECT");
        sql.append(" der.c_name AS orderName,");
        sql.append(" cus.c_name AS customerName");
        sql.append(" FROM");
        sql.append(" t_order der");
        sql.append(" JOIN t_customer cus ON der.n_customer_id = cus.n_id");
        sql.append(" WHERE der.c_name IN (:orderList)");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("orderList", orderList);
        this.queryForList(sql.toString(), (SqlParameterSource)params, (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                orderCustomerMap.put(rs.getString("orderName"), rs.getString("customerName"));
                return null;
            }
        });
    }

    public void queryProjectsByName(final Map<String, Long> projectNameMap, Map<String, Integer> projectMap) {
        StringBuffer sql = new StringBuffer("");
        sql.append("SELECT p.n_id, p.c_name AS projectName, c.c_name AS customerName FROM t_project p").append(" JOIN t_customer c ON c.n_id = p.n_customer_id ").append(" WHERE p.c_name IN (:projectNames)");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("projectNames", new ArrayList<String>(projectMap.keySet()));
        this.queryForList(sql.toString(), (SqlParameterSource)params, (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                projectNameMap.put(rs.getString("projectName") + "|" + rs.getString("customerName"), rs.getLong("n_id"));
                return null;
            }
        });
    }

    public Map<String, Long> saveProjectInfo(Map<String, String> correctOrderProjectMap, Map<String, String> correctOrderCustomerMap, Map<String, Long> customerInfo) {
        HashMap<String, Long> proAndCusNameMap = new HashMap<String, Long>();
        HashMap<String, Integer> temp = new HashMap<String, Integer>();
        MapSqlParameterSource params = null;
        StringBuffer sql = null;
        HashMap<String, Integer> projectMap = new HashMap<String, Integer>();
        for (String string : correctOrderProjectMap.keySet()) {
            projectMap.put(correctOrderProjectMap.get(string), 1);
        }
        this.queryProjectsByName(proAndCusNameMap, projectMap);
        ArrayList<ProjectCustomerBean> beanList = new ArrayList<ProjectCustomerBean>();
        for (String orderName : correctOrderProjectMap.keySet()) {
            String proAndCusName = correctOrderProjectMap.get(orderName) + "|" + correctOrderCustomerMap.get(orderName);
            if (null != proAndCusNameMap.get(proAndCusName) || null != temp.get(proAndCusName)) continue;
            ProjectCustomerBean bean = new ProjectCustomerBean(correctOrderProjectMap.get(orderName), correctOrderCustomerMap.get(orderName));
            beanList.add(bean);
            temp.put(proAndCusName, 1);
        }
        if (!beanList.isEmpty()) {
            MapSqlParameterSource[] mapSqlParameterSourceArray = new MapSqlParameterSource[beanList.size()];
            sql = new StringBuffer("INSERT INTO t_project(n_customer_id, c_name, n_reg_time) VALUES(:customerId, :name, :regTime)");
            int index = 0;
            for (ProjectCustomerBean proCus : beanList) {
                params = new MapSqlParameterSource();
                params.addValue("customerId", (Object)customerInfo.get(proCus.getCustomerName()));
                params.addValue("name", (Object)proCus.getProjectName());
                params.addValue("regTime", (Object)System.currentTimeMillis());
                mapSqlParameterSourceArray[index++] = params;
            }
            this.addOrUpdate(sql.toString(), (SqlParameterSource[])mapSqlParameterSourceArray);
            this.queryProjectsByName(proAndCusNameMap, projectMap);
        }
        return proAndCusNameMap;
    }

    public void saveBakcardInfo(List<String[]> datas, Map<String, String[]> temp, final Map<String, Long> orderInfo, Map<String, Long> customerInfo, int type, boolean status1, long recordId, Map<String, String> orderTypeMap, Map<String, String> correctOrderStateMap) {
        final HashMap<String, String> orderMap = new HashMap<String, String>();
        if (!datas.isEmpty()) {
            StringBuffer sql = new StringBuffer();
            sql.append("INSERT INTO t_bakcard_info(c_bakcard_sn, n_customer_id, n_asset_type, n_production_time, n_time, n_status,  ").append(" n_bkey_pari_alg, n_enc_bkey_alg, c_verify_code, c_recover_code, c_public_key, c_private_key ) ").append(" VALUES(:bakcardSN, :customerId, :assetType, :productTime, :time, :status, :bkeyPariAlg, ").append(" :encBkeyAlg, :verifyCode, :recoverCode, :publicKey, :privateKey ) ");
            MapSqlParameterSource[] params = new MapSqlParameterSource[datas.size()];
            MapSqlParameterSource parameter = null;
            String[] item = null;
            for (int i = 0; i < params.length; ++i) {
                item = datas.get(i);
                String orderType = orderTypeMap.get(item[0].toLowerCase());
                orderMap.put(item[0].toLowerCase(), item[1].trim().substring(orderType.length(), orderType.length() + (Integer)Constants.CUSTOMER_ORDER_TYPE.get(orderType)));
                parameter = new MapSqlParameterSource();
                parameter.addValue("bakcardSN", (Object)item[0].toLowerCase());
                parameter.addValue("customerId", (Object)customerInfo.get(item[2].trim()));
                parameter.addValue("assetType", (Object)type);
                parameter.addValue("productTime", (Object)DateTimeUtil.dateTimeStrToLong((String)item[3]));
                parameter.addValue("time", (Object)DateTimeUtil.getStartTime((String)item[4]));
                parameter.addValue("status", (Object)1);
                parameter.addValue("bkeyPariAlg", (Object)item[8]);
                parameter.addValue("encBkeyAlg", (Object)item[9]);
                parameter.addValue("verifyCode", (Object)item[6]);
                parameter.addValue("recoverCode", (Object)item[7]);
                parameter.addValue("publicKey", (Object)item[5]);
                parameter.addValue("privateKey", (Object)item[10]);
                params[i] = parameter;
                HashMap<String, Object> logMap = new HashMap<String, Object>();
                logMap.put("logType", 4);
                logMap.put("bakcardSN", item[0].toLowerCase());
                logMap.put("AssetType", type);
                AMSLogRecord.logRecord(logMap);
            }
            this.addOrUpdate(sql.toString(), (SqlParameterSource[])params);
            sql = new StringBuffer();
            sql.append("SELECT n_id, c_bakcard_sn FROM t_bakcard_info WHERE c_bakcard_sn IN (:bakcardList)");
            parameter = new MapSqlParameterSource();
            parameter.addValue("bakcardList", new ArrayList<String>(temp.keySet()));
            final ArrayList paramList = new ArrayList();
            this.queryForList(sql.toString(), (SqlParameterSource)parameter, (RowMapper)new RowMapper<String>(){
                MapSqlParameterSource parameter = null;
                String bakcardSN = null;
                long id = 0L;

                public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                    this.id = rs.getLong("n_id");
                    this.bakcardSN = rs.getString("c_bakcard_sn");
                    this.parameter = new MapSqlParameterSource();
                    this.parameter.addValue("orderId", orderInfo.get(orderMap.get(this.bakcardSN)));
                    this.parameter.addValue("bakcardId", (Object)this.id);
                    paramList.add(this.parameter);
                    return null;
                }
            });
            StringBuffer sqlOrderAsset = new StringBuffer();
            sqlOrderAsset.append("INSERT INTO t_order_bakcard(n_order_id, n_bakupcard_id)");
            sqlOrderAsset.append(" VALUES(:orderId, :bakcardId)");
            MapSqlParameterSource[] param = new MapSqlParameterSource[paramList.size()];
            this.addOrUpdate(sqlOrderAsset.toString(), (SqlParameterSource[])paramList.toArray(param));
        }
    }

    public List<String> checkBakcardExist(ArrayList<String> arrayList) {
        String sql = "SELECT c_bakcard_sn FROM t_bakcard_info WHERE c_bakcard_sn IN (:bakcardList)";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("bakcardList", arrayList);
        return this.queryForList(sql, (SqlParameterSource)params, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString("c_bakcard_sn");
            }
        });
    }

    public Map<String, Integer> queryBakcardForMap(ArrayList<String> bakcardList) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT c_bakcard_sn AS bakcardSN ").append("FROM t_bakcard_info ").append("WHERE c_bakcard_sn IN (:bakcardList) ");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("bakcardList", bakcardList);
        List bakcardInfos = this.queryForList(sqlBuffer.toString(), (SqlParameterSource)params, (RowMapper)new BeanPropertyRowMapper(TBakcardInfo.class));
        if (bakcardInfos != null && bakcardInfos.size() > 0) {
            for (TBakcardInfo info : bakcardInfos) {
                map.put(info.getBakcardSN(), 1);
            }
        }
        return map;
    }

    public void deleteBakcardFormat(ArrayList<String> cardNos) {
        StringBuffer sql = null;
        MapSqlParameterSource parameter = new MapSqlParameterSource();
        parameter.addValue("cardNos", cardNos);
        sql = new StringBuffer("DELETE FROM t_order_bakcard WHERE n_bakupcard_id IN ").append(" (SELECT bakcard.n_id FROM t_bakcard_info bakcard WHERE bakcard.c_bakcard_sn IN (:cardNos))");
        this.deleteBySql(sql.toString(), (SqlParameterSource)parameter);
        sql = new StringBuffer("DELETE FROM t_bakcard_info WHERE c_bakcard_sn IN (:cardNos)");
        this.deleteBySql(sql.toString(), (SqlParameterSource)parameter);
    }

    public Map<String, Integer> queryBakcardUseByCardNo(ArrayList<String> bakcardList) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT c_bakcard_sn AS bakcardSN, n_status AS status ").append("FROM t_bakcard_info ").append("WHERE c_bakcard_sn IN (:bakcardList) AND n_status <> :status");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("bakcardList", bakcardList);
        params.addValue("status", (Object)BakcardCondition.ENUM_BAKCARD_STATUS.unBackUp.key);
        List bakcardInfos = this.queryForList(sqlBuffer.toString(), (SqlParameterSource)params, (RowMapper)new BeanPropertyRowMapper(TBakcardInfo.class));
        if (bakcardInfos != null && bakcardInfos.size() > 0) {
            for (TBakcardInfo info : bakcardInfos) {
                map.put(info.getBakcardSN(), 1);
            }
        }
        return map;
    }

    private MapSqlParameterSource conBackupCardData(Map<String, Object> data) {
        MapSqlParameterSource parameter = new MapSqlParameterSource();
        parameter.addValue("bakcardSN", (Object)((String)data.get("cardSn")).toLowerCase());
        parameter.addValue("assetType", (Object)((Integer)data.get("type")));
        parameter.addValue("productTime", (Object)DateTimeUtil.dateTimeStrToLong((String)((String)data.get("productionTime"))));
        parameter.addValue("bkeyPariAlg", (Object)((Integer)data.get("bKeyPairAlg")));
        parameter.addValue("encBkeyAlg", (Object)((Integer)data.get("encBkeyPairAlg")));
        parameter.addValue("verifyCode", (Object)((String)data.get("verifyCode")));
        parameter.addValue("recoverCode", (Object)((String)data.get("recoveryCode")));
        parameter.addValue("publicKey", (Object)((String)data.get("publicKey")));
        parameter.addValue("privateKey", (Object)((String)data.get("privateKey")));
        return parameter;
    }

    public void saveBackupCard(List<Map<String, Object>> backupCardList) {
        ArrayList<MapSqlParameterSource> params = new ArrayList<MapSqlParameterSource>();
        for (Map<String, Object> item : backupCardList) {
            String cardSn = (String)item.get("cardSn");
            params.add(this.conBackupCardData(item));
            HashMap<String, Object> logMap = new HashMap<String, Object>();
            logMap.put("logType", 1);
            logMap.put("AssetId", cardSn);
            logMap.put("AssetType", item.get("type"));
            AMSLogRecord.logRecord(logMap);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO t_bakcard_info(c_bakcard_sn, n_asset_type, n_production_time,").append(" n_bkey_pari_alg, n_enc_bkey_alg, c_verify_code, c_recover_code, c_public_key, c_private_key) ").append(" VALUES(:bakcardSN, :assetType, :productTime, :bkeyPariAlg, ").append(" :encBkeyAlg, :verifyCode, :recoverCode, :publicKey, :privateKey) ");
        this.addOrUpdate(sql.toString(), (SqlParameterSource[])params.toArray(new MapSqlParameterSource[params.size()]));
    }

    public void updateBackupCardStatus(List<BackupCardScBean> backupCardList) {
        String sql = "UPDATE t_bakcard_info SET n_status = :status WHERE c_bakcard_sn = :bakcardSn";
        MapSqlParameterSource[] params = new MapSqlParameterSource[backupCardList.size()];
        MapSqlParameterSource parameter = null;
        for (int i = 0; i < params.length; ++i) {
            BackupCardScBean bean = backupCardList.get(i);
            parameter = new MapSqlParameterSource();
            parameter.addValue("status", (Object)bean.getStatusSn());
            parameter.addValue("bakcardSn", (Object)bean.getSn());
            params[i] = parameter;
        }
        this.addOrUpdate(sql, (SqlParameterSource[])params);
    }

    public Map<String, TBakcardInfoHistory> queryHisBakcard(List<String> cardNoList) {
        HashMap<String, TBakcardInfoHistory> assetMap = new HashMap<String, TBakcardInfoHistory>();
        MapSqlParameterSource params = new MapSqlParameterSource();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT bakcard.c_bakcard_sn AS bakcardSN, bakcard.n_customer_id customerId, ").append("o.n_id AS orderId, bakcard.n_asset_type assetType, bakcard.n_production_time AS productTime, ").append("bakcard.n_time AS time, bakcard.n_bkey_pari_alg AS bkeyPariAlg, ").append("bakcard.n_enc_bkey_alg AS encBkeyAlg, bakcard.c_verify_code AS verifyCode, ").append("bakcard.c_recover_code AS recoverCode, bakcard.c_public_key AS publicKey, ").append("bakcard.c_private_key AS privateKey, bakcard.n_status AS status ").append("FROM t_bakcard_info bakcard ").append("LEFT JOIN t_order_bakcard ob ON ob.n_bakupcard_id = bakcard.n_id ").append("LEFT JOIN t_order o ON o.n_id = ob.n_order_id ").append("LEFT JOIN t_customer c ON c.n_id = o.n_customer_id ").append("WHERE bakcard.c_bakcard_sn IN (:cardNoList) ");
        params.addValue("cardNoList", cardNoList);
        List historyList = this.queryForList(sqlBuffer.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(TBakcardInfoHistory.class));
        for (int i = 0; i < historyList.size(); ++i) {
            assetMap.put(((TBakcardInfoHistory)historyList.get(i)).getBakcardSN(), (TBakcardInfoHistory)historyList.get(i));
        }
        return assetMap;
    }

    public List<String> updateCardAssetStatus(List<Map<String, Object>> chipList) {
        HashMap<String, MapSqlParameterSource> unLockCodeParams = new HashMap<String, MapSqlParameterSource>();
        ArrayList<MapSqlParameterSource> cardParams = new ArrayList<MapSqlParameterSource>();
        ArrayList<String> cardNos = new ArrayList<String>();
        for (Map<String, Object> item : chipList) {
            String cardNo = ((String)item.get("cardNo")).toLowerCase();
            cardNos.add(cardNo);
            cardParams.add(this.assembleUpdateCard(item));
            unLockCodeParams.put(cardNo, this.assembleUnlockCode(item));
            HashMap<String, Object> logMap = new HashMap<String, Object>();
            logMap.put("logType", 3);
            logMap.put("AssetId", cardNo);
            AMSLogRecord.logRecord(logMap);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE t_asset_info SET  c_firmware_version = :firmwareVersion, c_init_script = :initScript, ").append(" c_senior_public = :seniorPublic, c_serial_code = :serialCode, c_cos_version = :cosVersion, ").append(" n_production_time = :productionTime, n_status = :isActivate WHERE c_asset_identify = :cardNo ");
        MapSqlParameterSource[] param = new MapSqlParameterSource[cardParams.size()];
        this.addOrUpdate(sql.toString(), (SqlParameterSource[])cardParams.toArray(param));
        StringBuffer sqlDel = new StringBuffer();
        sqlDel.append("DELETE FROM t_activate_log WHERE c_card_no IN (:cardIds) ");
        String cardIds = StringUtils.join(cardNos, (String)",");
        MapSqlParameterSource sqlParams = new MapSqlParameterSource();
        sqlParams.addValue("cardIds", (Object)cardIds);
        this.deleteBySql(sqlDel.toString(), (SqlParameterSource)sqlParams);
        return cardNos;
    }

    public Map<String, Long> saveOrUpdateCustomerInfo(Map<String, Integer> customerMap) {
        HashMap<String, Long> customerNameMap = new HashMap<String, Long>();
        MapSqlParameterSource params = null;
        StringBuffer sql = null;
        this.queryCustomersByName(customerNameMap, new ArrayList<String>(customerMap.keySet()));
        ArrayList<String> customerList = new ArrayList<String>();
        for (String customerName : customerMap.keySet()) {
            if (null != customerNameMap.get(customerName)) continue;
            customerList.add(customerName);
        }
        if (!customerList.isEmpty()) {
            MapSqlParameterSource[] paramsArr = new MapSqlParameterSource[customerList.size()];
            sql = new StringBuffer("INSERT INTO t_customer(c_name, n_reg_time) VALUES(:name, :regTime)");
            int index = 0;
            for (String customerName : customerList) {
                params = new MapSqlParameterSource();
                params.addValue("name", (Object)customerName);
                params.addValue("regTime", (Object)System.currentTimeMillis());
                paramsArr[index++] = params;
            }
            this.addOrUpdate(sql.toString(), (SqlParameterSource[])paramsArr);
            this.queryCustomersByName(customerNameMap, new ArrayList<String>(customerMap.keySet()));
        }
        return customerNameMap;
    }

    public Map<String, Long> updateOrderInfo(Map<String, String> correctOrderMap, Map<String, String> correctOrderCustomerMap, Map<String, Long> customerInfo, Map<String, Long> projectInfo) {
        HashMap<String, Long> orderNameMap = new HashMap<String, Long>();
        MapSqlParameterSource params = null;
        StringBuffer sql = null;
        MapSqlParameterSource[] paramsArr = new MapSqlParameterSource[correctOrderMap.size()];
        int index = 0;
        for (String orderName : correctOrderMap.keySet()) {
            params = new MapSqlParameterSource();
            String projectName = correctOrderMap.get(orderName);
            String customerName = correctOrderCustomerMap.get(orderName);
            params.addValue("projectId", (Object)projectInfo.get(projectName + "|" + customerName));
            params.addValue("customerId", (Object)customerInfo.get(customerName));
            params.addValue("orderName", (Object)orderName);
            paramsArr[index++] = params;
        }
        sql = new StringBuffer("UPDATE t_order SET n_project_id = :projectId, n_customer_id = :customerId ").append(" WHERE c_name = :orderName");
        this.addOrUpdate(sql.toString(), (SqlParameterSource[])paramsArr);
        this.queryOrdersByName(orderNameMap, correctOrderMap);
        return orderNameMap;
    }

    public void updateProductsInfo(List<Map<String, Object>> cardList, Map<String, Long> customerInfo, Map<String, Long> orderInfo, Map<String, String> orderTypeMap, List<String> cardNos, Map<String, String> correctProjectMap) {
        ArrayList<MapSqlParameterSource> cardParams = new ArrayList<MapSqlParameterSource>();
        HashMap<String, String> orderMap = new HashMap<String, String>();
        MapSqlParameterSource params = null;
        for (Map<String, Object> item : cardList) {
            HashMap<String, Object> logMap = new HashMap<String, Object>();
            logMap.put("logType", 2);
            String cardNo = ((String)item.get("cardNo")).toLowerCase();
            String orderType = orderTypeMap.get(cardNo.toLowerCase());
            String customerName = item.get("customer").toString().trim();
            String orderName = item.get("project").toString().trim().substring(orderType.length(), orderType.length() + (Integer)Constants.CUSTOMER_ORDER_TYPE.get(orderType));
            Long customerId = customerInfo.get(correctProjectMap.get(orderName));
            orderMap.put(cardNo.toLowerCase(), orderName);
            logMap.put("AssetId", cardNo);
            logMap.put("Customer", customerName);
            logMap.put("Order", orderName);
            AMSLogRecord.logRecord(logMap);
            cardNos.add(cardNo);
            params = new MapSqlParameterSource();
            params.addValue("customerId", (Object)customerId);
            params.addValue("cardNo", (Object)((String)item.get("cardNo")).toLowerCase());
            cardParams.add(params);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE t_asset_info SET n_customer_id = :customerId WHERE c_asset_identify = :cardNo");
        MapSqlParameterSource[] param = new MapSqlParameterSource[cardParams.size()];
        this.addOrUpdate(sql.toString(), (SqlParameterSource[])cardParams.toArray(param));
    }

    public List<String> checkOrderExist(ArrayList<String> orderNameList) {
        String sql = "SELECT c_name FROM t_order WHERE c_name IN (:orderNameList)";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("orderNameList", orderNameList);
        return this.queryForList(sql, (SqlParameterSource)params, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString("c_name");
            }
        });
    }

    public List<String> checkProductsExist(ArrayList<String> identifyList) {
        String sql = "SELECT c_asset_identify FROM t_asset_info WHERE c_asset_identify IN (:identifyList) AND n_customer_id IS NOT NULL ";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("identifyList", identifyList);
        return this.queryForList(sql, (SqlParameterSource)params, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString("c_asset_identify");
            }
        });
    }

    public void queryOrderAsset(List<String> cardListTemp, final Map<String, String> orderAssetMap) {
        StringBuffer sql = new StringBuffer("SELECT o.c_name AS orderName, ai.c_asset_identify AS cardNo ").append("FROM t_asset_info ai LEFT JOIN ").append("t_order_asset oa ON ai.n_id = oa.n_asset_id ").append("LEFT JOIN t_order o ON oa.n_order_id = o.n_id ").append("WHERE c_asset_identify IN (:cardListTemp) ");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("cardListTemp", cardListTemp);
        this.queryForList(sql.toString(), (SqlParameterSource)params, (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                orderAssetMap.put(rs.getString("cardNo"), rs.getString("orderName"));
                return null;
            }
        });
    }

    public void queryufDbByOrderCodes(Map<String, String> customerU8Map, Map<String, Integer> orderNameUfMap, Map<String, String> correctOrderProjectMap, Map<String, String> correctOrderCustomerMap, Map<String, Integer> correctOrderLicenseMap, Map<String, String> correctOrderStateMap) {
        Map customerMap = new HashMap();
        StringBuffer sqlBuffer = new StringBuffer("SELECT s.cCusCode AS customerCode,").append(" c.cCusName AS customerName, s.cDefine1 AS projectName,").append(" s.cDefine5 AS orderLicense,s.cDefine8 AS orderActive, s.cSOCode AS orderName").append(" FROM SO_SOMain s LEFT JOIN Customer c ON c.cCusCode = s.cCusCode WHERE s.cSOCode IN (");
        for (String orderName : orderNameUfMap.keySet()) {
            sqlBuffer.append("'" + orderName + "'").append(",");
        }
        String sql = sqlBuffer.substring(0, sqlBuffer.lastIndexOf(",")) + ")";
        List list = this.dao.queryForList(sql);
        if (!list.isEmpty() && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                customerMap = (Map)list.get(i);
                customerU8Map.put((String)customerMap.get("customerName"), (String)customerMap.get("customerCode"));
                correctOrderProjectMap.put((String)customerMap.get("orderName"), (String)customerMap.get("projectName"));
                correctOrderCustomerMap.put((String)customerMap.get("orderName"), (String)customerMap.get("customerName"));
                correctOrderLicenseMap.put((String)customerMap.get("orderName"), Integer.parseInt((String)customerMap.get("orderLicense")));
                correctOrderStateMap.put((String)customerMap.get("orderName"), (String)customerMap.get("orderActive"));
            }
        }
    }

    public void saveCustomerInfoU8(Map<String, Long> customerInfo, Map<String, String> customerMap) {
        MapSqlParameterSource params = null;
        StringBuffer sql = null;
        this.queryCustomersByName(customerInfo, new ArrayList<String>(customerMap.keySet()));
        ArrayList<String> customerList = new ArrayList<String>();
        for (String customerName : customerMap.keySet()) {
            if (null != customerInfo.get(customerName)) continue;
            customerList.add(customerName);
        }
        if (!customerList.isEmpty()) {
            MapSqlParameterSource[] paramsArr = new MapSqlParameterSource[customerList.size()];
            sql = new StringBuffer("INSERT INTO t_customer(c_name, c_code, n_reg_time) VALUES(:name, :code, :regTime)");
            int index = 0;
            for (String customerName : customerList) {
                params = new MapSqlParameterSource();
                params.addValue("name", (Object)customerName);
                params.addValue("code", (Object)customerMap.get(customerName));
                params.addValue("regTime", (Object)System.currentTimeMillis());
                paramsArr[index++] = params;
            }
            this.addOrUpdate(sql.toString(), (SqlParameterSource[])paramsArr);
            this.queryCustomersByName(customerInfo, new ArrayList<String>(customerMap.keySet()));
        }
    }

    public void saveOrderInfoU8(Map<String, String> correctOrderMap, Map<String, String> correctOrderStateMap, Map<String, String> correctOrderCustomerMap, Map<String, Long> customerInfo, Map<String, Long> projectInfo, Map<String, Long> orderInfo, Map<String, Integer> correctOrderLicenseMap) {
        MapSqlParameterSource params = null;
        StringBuffer sql = null;
        this.queryOrdersByName(orderInfo, correctOrderMap);
        ArrayList<String> orderList = new ArrayList<String>();
        for (String orderName : correctOrderMap.keySet()) {
            if (null != orderInfo.get(orderName)) continue;
            orderList.add(orderName);
        }
        if (!orderList.isEmpty()) {
            MapSqlParameterSource[] paramsArr = new MapSqlParameterSource[orderList.size()];
            sql = new StringBuffer("INSERT INTO t_order(n_project_id, n_order_type, n_customer_id, c_name, n_time, n_license, n_origin)");
            sql.append(" VALUES(:projectId, :orderType, :customerId, :name, :regTime, :license, 1)");
            int index = 0;
            for (String orderName : orderList) {
                params = new MapSqlParameterSource();
                String projectName = correctOrderMap.get(orderName);
                String customerName = correctOrderCustomerMap.get(orderName);
                params.addValue("projectId", (Object)projectInfo.get(projectName + "|" + customerName));
                params.addValue("orderType", Constants.U8_ORDER_ACTIVETYPE.get(correctOrderStateMap.get(orderName).toString()));
                params.addValue("customerId", (Object)customerInfo.get(customerName));
                params.addValue("name", (Object)orderName);
                params.addValue("regTime", (Object)System.currentTimeMillis());
                System.out.println(correctOrderLicenseMap.get(orderName));
                if (null == correctOrderLicenseMap.get(orderName)) {
                    params.addValue("license", (Object)0);
                } else {
                    params.addValue("license", (Object)correctOrderLicenseMap.get(orderName));
                }
                paramsArr[index++] = params;
            }
            this.addOrUpdate(sql.toString(), (SqlParameterSource[])paramsArr);
            this.queryOrdersByName(orderInfo, correctOrderMap);
        }
    }

    public Map<String, String> queryufOrdersDb() {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuffer sqlBuffer = new StringBuffer("SELECT s.cCusCode AS customerCode,").append(" c.cCusName AS customerName, s.cDefine1 AS projectName,").append(" s.cDefine5 AS orderLicense,s.cDefine8 AS orderActive, s.cSOCode AS orderName").append(" FROM SO_SOMain s LEFT JOIN Customer c ON c.cCusCode = s.cCusCode");
        List list = this.dao.queryForList(sqlBuffer.toString());
        if (!list.isEmpty() && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                map.put((String)((Map)list.get(i)).get("orderName"), (String)((Map)list.get(i)).get("orderName"));
            }
        }
        return map;
    }

    public List<Map<String, Object>> checkCardProducts(List<Map<String, Object>> cardList) {
        if (null != cardList && cardList.size() != 0) {
            String cardNosStr = "";
            for (Map<String, Object> map : cardList) {
                cardNosStr = cardNosStr + "\"" + (String)map.get("cardNo") + "\",";
            }
            String sql = "SELECT c_asset_identify cardNo, c_asset_type type, n_customer_id customerId FROM t_asset_info WHERE c_asset_identify IN (" + cardNosStr.substring(0, cardNosStr.length() - 1) + ")";
            MapSqlParameterSource params = new MapSqlParameterSource();
            return this.queryForList(sql, (SqlParameterSource)params);
        }
        return new ArrayList<Map<String, Object>>();
    }

    public List<Map<String, Object>> checkbackupProducts(List<Map<String, Object>> backupCardList) {
        if (null != backupCardList && backupCardList.size() != 0) {
            String backupNosStr = "";
            for (Map<String, Object> map : backupCardList) {
                backupNosStr = backupNosStr + "\"" + (String)map.get("cardNo") + "\",";
            }
            String sql = "SELECT c_bakcard_sn cardNo, n_customer_id customerId FROM t_bakcard_info WHERE c_bakcard_sn IN (" + backupNosStr.substring(0, backupNosStr.length() - 1) + ")";
            MapSqlParameterSource params = new MapSqlParameterSource();
            return this.queryForList(sql, (SqlParameterSource)params);
        }
        return new ArrayList<Map<String, Object>>();
    }

    public List<Map<String, Object>> checkMobileProducts(List<Map<String, Object>> mobileList) {
        if (null != mobileList && mobileList.size() != 0) {
            String mobilesStr = "";
            for (Map<String, Object> map : mobileList) {
                mobilesStr = mobilesStr + "\"" + (String)map.get("imei") + "\",";
            }
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("SELECT mobile.c_imei cardNo, info.n_customer_id customerId FROM t_asset_mobiles_info mobile LEFT JOIN ").append("t_asset_info info ON mobile.n_asset_id = info.n_id WHERE mobile.c_imei IN (" + mobilesStr.substring(0, mobilesStr.length() - 1) + ")");
            MapSqlParameterSource params = new MapSqlParameterSource();
            return this.queryForList(sqlBuffer.toString(), (SqlParameterSource)params);
        }
        return new ArrayList<Map<String, Object>>();
    }

    public Long queryCertTypeByCardNo(String cardNo, Integer dbCertALg) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT COUNT(n_id) FROM t_cert_info WHERE c_card_no = :cardNo ");
        MapSqlParameterSource params = new MapSqlParameterSource();
        if (null != dbCertALg) {
            sqlBuffer.append("AND n_ca_alg =:caAlg");
            params.addValue("caAlg", (Object)dbCertALg);
        }
        params.addValue("cardNo", (Object)cardNo);
        return this.queryForLong(sqlBuffer.toString(), (SqlParameterSource)params);
    }

    public Map<String, Integer> queryAssetStatisticsInfoMap() {
        HashMap<String, Integer> assetMap = new HashMap<String, Integer>();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select c_asset_type As assetType, count(c_asset_type) as assetCount from t_asset_info group by c_asset_type");
        List assetInfos = this.queryForList(sqlBuffer.toString(), null, (RowMapper)new BeanPropertyRowMapper(AssetStatisticsInfo.class));
        if (assetInfos != null && assetInfos.size() > 0) {
            for (AssetStatisticsInfo info : assetInfos) {
                assetMap.put(info.getAssetType(), info.getAssetCount());
            }
        }
        return assetMap;
    }
}

