/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.assetmanager.business.impl;

import com.xdja.cssp.ams.assetmanager.business.AssetInfoBusiness;
import com.xdja.cssp.ams.assetmanager.dao.AmsAssetDao;
import com.xdja.cssp.ams.assetmanager.dao.AssetDataJdbcDao;
import com.xdja.cssp.ams.assetmanager.dao.AssetInfoJdbcDao;
import com.xdja.cssp.ams.assetmanager.entity.Asset;
import com.xdja.cssp.ams.assetmanager.entity.AssetCondition;
import com.xdja.cssp.ams.assetmanager.entity.AssetDetails;
import com.xdja.cssp.ams.assetmanager.entity.Cert;
import com.xdja.cssp.ams.assetmanager.entity.TAssetInfo;
import com.xdja.platform.datacenter.jpa.page.Pagination;
import com.xdja.platform.rpc.proxy.PagingConverter;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AssetInfoBusinessImpl
implements AssetInfoBusiness {
    @Autowired
    private AssetInfoJdbcDao assetInfoJdbcDao;
    @Autowired
    private AssetDataJdbcDao assetDataJdbcDao;
    @Autowired
    private AmsAssetDao amsAssetDao;

    @Override
    public LitePaging<TAssetInfo> queryAllAssets(AssetCondition condition, int page, int length, String orderColName, String orderDir) {
        return PagingConverter.convert(this.assetInfoJdbcDao.queryAllAssets(condition, page, length, orderColName, orderDir));
    }

    @Override
    public AssetDetails getAssetInfo(Long id) {
        return this.assetInfoJdbcDao.getAssetInfo(id);
    }

    @Override
    public AssetDetails getAssetInfo(AssetDetails assetInfo) {
        return this.assetInfoJdbcDao.getAssetInfo(assetInfo);
    }

    @Override
    public LitePaging<TAssetInfo> queryDataAssets(AssetCondition condition, int page, int length, String orderColName, String orderDir) {
        Pagination<TAssetInfo> queryDataAssets = this.assetDataJdbcDao.queryDataAssets(condition, page, length, orderColName, orderDir);
        return PagingConverter.convert(queryDataAssets);
    }

    @Override
    public AssetDetails getAssetData(Long id) {
        return this.assetDataJdbcDao.getAssetInfo(id);
    }

    @Override
    public boolean exists(String assetIdentity) {
        return this.amsAssetDao.exists(assetIdentity);
    }

    @Override
    public Map<String, List<Cert>> queryCertByCardNos(String cardNo) {
        return this.amsAssetDao.queryCertByCardNos(cardNo);
    }

    @Override
    public List<Asset> queryForAssetList(String[] assetIdentity) {
        return this.amsAssetDao.queryForAssetList(assetIdentity);
    }

    @Override
    public Map<String, Object> queryForPrivateMap(Long id) {
        return this.amsAssetDao.queryForPrivateMap(id);
    }

    @Override
    public TAssetInfo queryCustomerByCardno(String cardNo) {
        return this.assetInfoJdbcDao.queryCustomerByCardno(cardNo);
    }

    @Override
    public int modifyActivateInfo(AssetDetails details) {
        return this.assetDataJdbcDao.modifyActivateInfo(details);
    }
}

