/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.assetmanager.business.impl;

import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import com.xdja.cssp.ams.assetmanager.bean.AmsAsset;
import com.xdja.cssp.ams.assetmanager.bean.AmsAssetMobilesInfo;
import com.xdja.cssp.ams.assetmanager.bean.AmsCertInfo;
import com.xdja.cssp.ams.assetmanager.bean.AmsTerminalUnlockCode;
import com.xdja.cssp.ams.assetmanager.business.ILoadRecordManagerBusiness;
import com.xdja.cssp.ams.assetmanager.dao.AmsAssetDao;
import com.xdja.cssp.ams.assetmanager.dao.LoadRecordManagerDao;
import com.xdja.cssp.ams.assetmanager.dao.LoadRecordManagerJPADao;
import com.xdja.cssp.ams.assetmanager.entity.TLoadRecord;
import com.xdja.cssp.ams.core.util.DateQueryBean;
import com.xdja.platform.rpc.proxy.PagingConverter;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ILoadRecordManagerBusinessImpl
implements ILoadRecordManagerBusiness {
    @Autowired
    private LoadRecordManagerDao loadRecordManagerDao;
    @Autowired
    private LoadRecordManagerJPADao loadRecordManagerJPADao;
    @Autowired
    AmsAssetDao amsAssetDao;

    @Override
    public LitePaging<TLoadRecord> queryLoadRecords(TLoadRecord condition, Integer pageNo, Integer pageSize, String sortName, String sortType, DateQueryBean queryBean) {
        return PagingConverter.convert(this.loadRecordManagerDao.queryLoadRecords(condition, pageNo, pageSize, sortName, sortType, queryBean));
    }

    @Override
    public LitePaging<TLoadRecord> queryLoadRecordDetails(TLoadRecord condition, Integer pageNo, Integer pageSize, String sortName, String sortType) {
        return PagingConverter.convert(this.loadRecordManagerDao.queryLoadRecordDetails(condition, pageNo, pageSize, sortName, sortType));
    }

    @Override
    public TLoadRecord getByRecordId(Long recordId) {
        return (TLoadRecord)this.loadRecordManagerJPADao.find(recordId);
    }

    @Override
    public List<TLoadRecord> queryCleanFailDataByTime(Long beginTime) {
        Search search = new Search();
        search.addFilterLessThan("regTime", (Object)beginTime);
        return this.loadRecordManagerJPADao.search((ISearch)search);
    }

    @Override
    public void doSaveRemoteAssetInfo(List<AmsAsset> assetInfoList, List<String> assetMobileIdenList, List<AmsAssetMobilesInfo> assetMobileInfoList) {
        this.amsAssetDao.doSaveRemoteAssetInfo(assetInfoList, assetMobileIdenList, assetMobileInfoList);
    }

    @Override
    public void doSaveRemoteCert(List<AmsCertInfo> certInfoList) {
        this.amsAssetDao.doSaveRemoteCert(certInfoList);
    }

    @Override
    public void doSaveRemoteUnlock(List<AmsTerminalUnlockCode> terminalUnlockCodeList) {
        this.amsAssetDao.doSaveRemoteUnlock(terminalUnlockCodeList);
    }

    @Override
    public List<AmsAsset> queryAmsAssetList(Long recordId) {
        return this.loadRecordManagerDao.queryAmsAssetList(recordId);
    }
}

