/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.assetmanager.dao;

import com.xdja.cssp.ams.assetmanager.entity.AssetCondition;
import com.xdja.cssp.ams.assetmanager.entity.AssetDetails;
import com.xdja.cssp.ams.assetmanager.entity.TAssetInfo;
import com.xdja.platform.datacenter.jpa.dao.BaseJdbcDao;
import com.xdja.platform.datacenter.jpa.page.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class AssetInfoJdbcDao
extends BaseJdbcDao {
    public Pagination<TAssetInfo> queryAllAssets(AssetCondition condition, int page, int length, String orderColName, String orderDir) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT asset.c_asset_identify AS assetIdentify,asset.c_card_no AS cardNo,asset.c_asset_type AS assetType,");
        sqlBuffer.append(" asset.c_relation_asset_identify AS relationAssetIdentify,cus.c_name AS customerName,asset.n_time AS time,");
        sqlBuffer.append(" n_production_time AS productionTime,asset.n_id AS id, oder.c_name AS orderName");
        sqlBuffer.append(" FROM t_asset_info asset ");
        sqlBuffer.append(" JOIN t_customer cus ON cus.n_id = asset.n_customer_id ");
        sqlBuffer.append(" LEFT JOIN t_order_asset oass ON oass.n_asset_id = asset.n_id");
        sqlBuffer.append(" LEFT JOIN t_order oder ON oder.n_id = oass.n_order_id");
        if (condition != null && (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{condition.getImei()}) || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{condition.getSnNo()}))) {
            sqlBuffer.append(" LEFT JOIN t_asset_mobiles_info mobile ON mobile.n_asset_id = asset.n_id");
        }
        sqlBuffer.append(" WHERE 1=1 ");
        MapSqlParameterSource param = new MapSqlParameterSource();
        if (condition != null) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{condition.getAssetIdentify()})) {
                sqlBuffer.append(" AND asset.c_asset_identify LIKE :assetIdentify ");
                param.addValue("assetIdentify", (Object)('%' + condition.getAssetIdentify() + '%'));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{condition.getCustomerName()})) {
                sqlBuffer.append(" AND cus.c_name LIKE :customerName ");
                param.addValue("customerName", (Object)('%' + condition.getCustomerName() + '%'));
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{condition.getAssetType()})) {
                sqlBuffer.append(" AND asset.c_asset_type = :assetType ");
                param.addValue("assetType", (Object)condition.getAssetType());
            }
            if (StringUtils.isNotBlank((CharSequence)condition.getRelationAssetIdentify())) {
                sqlBuffer.append(" AND asset.c_relation_asset_identify LIKE :relationAssetIdentify ");
                param.addValue("relationAssetIdentify", (Object)('%' + condition.getRelationAssetIdentify() + '%'));
            }
            if (condition.getStartTime() != null) {
                sqlBuffer.append(" AND asset.n_time >= :startTime ");
                param.addValue("startTime", (Object)condition.getStartTime());
            }
            if (condition.getEndTime() != null) {
                sqlBuffer.append(" AND asset.n_time < :endTime ");
                param.addValue("endTime", (Object)condition.getEndTime());
            }
            if (condition.getStartCreateTime() != null) {
                sqlBuffer.append(" AND asset.n_production_time >= :startCreateTime ");
                param.addValue("startCreateTime", (Object)condition.getStartCreateTime());
            }
            if (condition.getEndCreateTime() != null) {
                sqlBuffer.append(" AND asset.n_production_time < :endCreateTime ");
                param.addValue("endCreateTime", (Object)condition.getEndCreateTime());
            }
            if (StringUtils.isNotBlank((CharSequence)condition.getOrderName())) {
                sqlBuffer.append(" AND oder.c_name LIKE :orderName");
                param.addValue("orderName", (Object)("%" + condition.getOrderName() + "%"));
            }
            if (StringUtils.isNotBlank((CharSequence)condition.getImei())) {
                sqlBuffer.append(" AND mobile.c_imei LIKE :imei");
                param.addValue("imei", (Object)("%" + condition.getImei() + "%"));
            }
            if (StringUtils.isNotBlank((CharSequence)condition.getSnNo())) {
                sqlBuffer.append(" AND mobile.c_sn_no LIKE :snNo");
                param.addValue("snNo", (Object)("%" + condition.getSnNo() + "%"));
            }
            if (StringUtils.isNotBlank((CharSequence)condition.getSerialCode())) {
                sqlBuffer.append(" AND asset.c_serial_code LIKE :serialCode");
                param.addValue("serialCode", (Object)("%" + condition.getSerialCode() + "%"));
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)orderColName) && StringUtils.isNotEmpty((CharSequence)orderDir)) {
            sqlBuffer.append(" ORDER BY " + orderColName + " " + orderDir);
        } else {
            sqlBuffer.append(" ORDER BY n_time DESC ");
        }
        return this.queryForPage(sqlBuffer.toString(), length, page, param, (RowMapper)new BeanPropertyRowMapper(TAssetInfo.class));
    }

    public AssetDetails getAssetInfo(Long id) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT customer.c_name AS customerName, asset.c_asset_identify AS assetIdentify, asset.c_asset_type AS assetType, asset.c_card_no AS cardNo, asset.n_time AS time, ");
        sqlBuffer.append(" asset.c_relation_asset_identify AS relationAssetIdentify, mobile.c_imei AS imei, mobile.c_os_name AS osName,mobile.c_os_version AS osVersion,mobile.c_model AS model, ");
        sqlBuffer.append(" c_sn_no AS snNo, asset.c_serial_code AS serialCode, asset.n_production_time AS createTime, asset.n_activate_deadline_time AS activeLimitTime, asset.n_allow_activate_status AS isAllowedActivate");
        sqlBuffer.append(" FROM t_asset_info asset ");
        sqlBuffer.append(" LEFT JOIN t_asset_mobiles_info mobile ON  mobile.n_asset_id = asset.n_id ");
        sqlBuffer.append(" JOIN t_customer customer ON customer.n_id = asset.n_customer_id ");
        MapSqlParameterSource param = new MapSqlParameterSource();
        sqlBuffer.append(" WHERE asset.n_id = :id ");
        param.addValue("id", (Object)id);
        return (AssetDetails)this.queryForObject(sqlBuffer.toString(), (SqlParameterSource)param, (RowMapper)new BeanPropertyRowMapper(AssetDetails.class));
    }

    public AssetDetails getAssetInfo(AssetDetails assetInfo) {
        final AssetDetails detail = new AssetDetails();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT customer.c_name AS customerName, asset.c_asset_identify AS assetIdentify, asset.c_asset_type AS assetType, asset.c_card_no AS cardNo, asset.n_time AS time, ");
        sqlBuffer.append(" asset.c_relation_asset_identify AS relationAssetIdentify, mobile.c_imei AS imei, mobile.c_os_name AS osName,mobile.c_os_version AS osVersion,mobile.c_model AS model, ");
        sqlBuffer.append(" c_sn_no AS snNo, asset.c_serial_code AS serialCode, n_production_time AS createTime ");
        sqlBuffer.append(" FROM t_asset_info asset ");
        sqlBuffer.append(" LEFT JOIN t_asset_mobiles_info mobile ON  mobile.n_asset_id = asset.n_id ");
        sqlBuffer.append(" JOIN t_customer customer ON customer.n_id = asset.n_customer_id ");
        MapSqlParameterSource param = new MapSqlParameterSource();
        sqlBuffer.append(" WHERE asset.c_asset_identify = :cardNo ");
        param.addValue("cardNo", (Object)assetInfo.getCardNo());
        this.queryForList(sqlBuffer.toString(), (SqlParameterSource)param, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                detail.setCustomerName(rs.getString("customerName"));
                detail.setAssetIdentify(rs.getString("assetIdentify"));
                detail.setAssetType(rs.getString("assetType"));
                detail.setCardNo(rs.getString("cardNo"));
                detail.setTime(Long.valueOf(rs.getLong("time")));
                detail.setRelationAssetIdentify(rs.getString("relationAssetIdentify"));
                detail.setImei(rs.getString("imei"));
                detail.setOsName(rs.getString("osName"));
                detail.setOsVersion(rs.getString("osVersion"));
                detail.setModel(rs.getString("model"));
                detail.setSnNo(rs.getString("snNo"));
                detail.setSerialCode(rs.getString("serialCode"));
                detail.setCreateTime(Long.valueOf(rs.getLong("createTime")));
                return null;
            }
        });
        return StringUtils.isNotBlank((CharSequence)detail.getAssetIdentify()) ? detail : null;
    }

    public TAssetInfo queryCustomerByCardno(String cardNo) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT c.c_name customerName FROM t_asset_info n");
        sqlBuffer.append(" LEFT JOIN t_customer c ON c.n_id = n.n_customer_id");
        sqlBuffer.append(" WHERE c_asset_identify = :cardNo");
        MapSqlParameterSource param = new MapSqlParameterSource();
        param.addValue("cardNo", (Object)cardNo);
        return (TAssetInfo)this.queryForObject(sqlBuffer.toString(), (SqlParameterSource)param, (RowMapper)new BeanPropertyRowMapper(TAssetInfo.class));
    }
}

