/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.assetmanager.dao;

import com.xdja.cssp.ams.assetmanager.entity.BakcardCondition;
import com.xdja.platform.datacenter.jpa.dao.BaseJdbcDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class BakcardInfoJdbcDao
extends BaseJdbcDao {
    public Object queryAllBakcards(BakcardCondition condition, int page, int length, String orderColName, String orderDir) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT bakcard.c_bakcard_sn AS bakcardSN, bakcard.n_asset_type AS assetType, n_production_time AS productTime, ").append("bakcard.n_time AS time, n_status AS status, c.c_name AS customerName, p.c_name AS projectName, ").append("o.c_name AS orderName, bakcard.n_id AS id ").append("FROM t_bakcard_info bakcard ").append("JOIN t_customer cus ON cus.n_id = bakcard.n_customer_id ").append("LEFT JOIN t_order_bakcard ob ON bakcard.n_id = ob.n_bakupcard_id ").append("LEFT JOIN t_order o ON o.n_id = ob.n_order_id ").append("LEFT JOIN t_project p ON p.n_id = o.n_project_id ").append("LEFT JOIN t_customer c ON c.n_id = p.n_customer_id ").append("WHERE 1=1 ");
        MapSqlParameterSource param = new MapSqlParameterSource();
        if (condition != null) {
            if (StringUtils.isNotBlank((CharSequence)condition.getCustomerName())) {
                sqlBuffer.append(" AND c.c_name LIKE :customerName ");
                param.addValue("customerName", (Object)('%' + condition.getCustomerName() + '%'));
            }
            if (StringUtils.isNotBlank((CharSequence)condition.getProjectName())) {
                sqlBuffer.append(" AND p.c_name LIKE :projectName ");
                param.addValue("projectName", (Object)('%' + condition.getProjectName() + '%'));
            }
            if (StringUtils.isNotBlank((CharSequence)condition.getOrderName())) {
                sqlBuffer.append(" AND o.c_name LIKE :orderName ");
                param.addValue("orderName", (Object)('%' + condition.getOrderName() + '%'));
            }
            if (StringUtils.isNotBlank((CharSequence)condition.getBakcardSN())) {
                sqlBuffer.append(" AND bakcard.c_bakcard_sn LIKE :bakcardSN ");
                param.addValue("bakcardSN", (Object)('%' + condition.getBakcardSN() + '%'));
            }
            if (condition.getProductStartTime() != null) {
                sqlBuffer.append(" AND bakcard.n_production_time >= :productStartTime ");
                param.addValue("productStartTime", (Object)condition.getProductStartTime());
            }
            if (condition.getProductEndTime() != null) {
                sqlBuffer.append(" AND bakcard.n_production_time < :productEndTime ");
                param.addValue("productEndTime", (Object)condition.getProductEndTime());
            }
            if (condition.getStartTime() != null) {
                sqlBuffer.append(" AND bakcard.n_time >= :startTime ");
                param.addValue("startTime", (Object)condition.getStartTime());
            }
            if (condition.getEndTime() != null) {
                sqlBuffer.append(" AND bakcard.n_time < :endTime ");
                param.addValue("endTime", (Object)condition.getEndTime());
            }
        }
        return this.queryForPage(sqlBuffer.toString(), length, page, param, (RowMapper)new BeanPropertyRowMapper(BakcardCondition.class));
    }

    public BakcardCondition getBakcardInfo(Long id) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT c.c_name AS customerName, p.c_name AS projectName, o.c_name AS orderName, ").append("bakcard.n_asset_type AS assetType, bakcard.n_id AS id, bakcard.c_bakcard_sn bakcardSN, bakcard.n_status AS status, ").append("bakcard.c_public_key AS publicKey, bakcard.c_private_key AS privateKey, ").append("bakcard.c_verify_code AS verifyCode, bakcard.c_recover_code AS recoverCode, ").append("bakcard.n_bkey_pari_alg AS bkeyPariAlg, bakcard.n_enc_bkey_alg AS encBkeyAlg, ").append("bakcard.n_production_time AS productTime, bakcard.n_time AS time ").append("FROM t_bakcard_info bakcard ").append("LEFT JOIN t_order_bakcard ob ON bakcard.n_id = ob.n_bakupcard_id ").append("LEFT JOIN t_order o ON o.n_id = ob.n_order_id ").append("LEFT JOIN t_project p ON p.n_id = o.n_project_id ").append("LEFT JOIN t_customer c ON c.n_id = p.n_customer_id ").append("WHERE bakcard.n_id = :bakcardId ");
        MapSqlParameterSource param = new MapSqlParameterSource();
        param.addValue("bakcardId", (Object)id);
        return (BakcardCondition)this.queryForObject(sqlBuffer.toString(), (SqlParameterSource)param, (RowMapper)new BeanPropertyRowMapper(BakcardCondition.class));
    }

    public Object queryDataBakcards(BakcardCondition condition, int page, int length, String orderColName, String orderDir) {
        StringBuffer sqlBuilder = new StringBuffer();
        sqlBuilder.append("SELECT n_id AS id, c_bakcard_sn AS bakcardSN, n_status AS status, n_production_time AS productTime ").append("FROM t_bakcard_info ").append("WHERE n_customer_id is NULL ");
        MapSqlParameterSource param = new MapSqlParameterSource();
        if (condition != null) {
            if (StringUtils.isNotBlank((CharSequence)condition.getBakcardSN())) {
                sqlBuilder.append(" AND c_bakcard_sn LIKE :bakcardSN ");
                param.addValue("bakcardSN", (Object)('%' + condition.getBakcardSN() + '%'));
            }
            if (condition.getProductStartTime() != null) {
                sqlBuilder.append(" AND n_production_time >= :productStartTime ");
                param.addValue("productStartTime", (Object)condition.getProductStartTime());
            }
            if (condition.getProductEndTime() != null) {
                sqlBuilder.append(" AND n_production_time <= :productEndTime ");
                param.addValue("productEndTime", (Object)condition.getProductEndTime());
            }
        }
        return this.queryForPage(sqlBuilder.toString(), length, page, param, (RowMapper)new BeanPropertyRowMapper(BakcardCondition.class));
    }

    public BakcardCondition getBakcardData(Long id) {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT bakcard.n_asset_type AS assetType, bakcard.n_id AS id, bakcard.c_bakcard_sn bakcardSN, bakcard.n_status AS status, ").append("bakcard.c_public_key AS publicKey, bakcard.c_private_key AS privateKey, ").append("bakcard.c_verify_code AS verifyCode, bakcard.c_recover_code AS recoverCode, ").append("bakcard.n_bkey_pari_alg AS bkeyPariAlg, bakcard.n_enc_bkey_alg AS encBkeyAlg, ").append("bakcard.n_production_time AS productTime ").append("FROM t_bakcard_info bakcard ").append("WHERE bakcard.n_id = :bakcardId ");
        MapSqlParameterSource param = new MapSqlParameterSource();
        param.addValue("bakcardId", (Object)id);
        return (BakcardCondition)this.queryForObject(sqlBuffer.toString(), (SqlParameterSource)param, (RowMapper)new BeanPropertyRowMapper(BakcardCondition.class));
    }

    public BakcardCondition getBakcardDataBySn(String sn) {
        final BakcardCondition backard = new BakcardCondition();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT c_bakcard_sn AS bakcardSN, n_status AS status,").append(" c_verify_code AS verifyCode, c_recover_code AS recoverCode").append(" FROM t_bakcard_info WHERE c_bakcard_sn = :bakcardSN");
        MapSqlParameterSource param = new MapSqlParameterSource();
        param.addValue("bakcardSN", (Object)sn);
        this.queryForList(sqlBuffer.toString(), (SqlParameterSource)param, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                backard.setBakcardSN(rs.getString("bakcardSN"));
                backard.setStatus(Integer.valueOf(rs.getInt("status")));
                backard.setVerifyCode(rs.getString("verifyCode"));
                backard.setRecoverCode(rs.getString("recoverCode"));
                return null;
            }
        });
        return backard;
    }
}

