/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.assetmanager.dao;

import com.xdja.cssp.ams.assetmanager.bean.AmsAsset;
import com.xdja.cssp.ams.assetmanager.bean.AmsAssetMobilesInfo;
import com.xdja.cssp.ams.assetmanager.entity.TAssetInfo;
import com.xdja.cssp.ams.assetmanager.entity.TLoadRecord;
import com.xdja.cssp.ams.core.util.DateQueryBean;
import com.xdja.platform.datacenter.jpa.dao.BaseJdbcDao;
import com.xdja.platform.datacenter.jpa.page.Pagination;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class LoadRecordManagerDao
extends BaseJdbcDao {
    public Pagination<TLoadRecord> queryLoadRecords(TLoadRecord condition, Integer pageNo, Integer pageSize, String sortName, String sortType, DateQueryBean queryBean) {
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        StringBuilder sqlBuilder = new StringBuilder("SELECT").append(" record.n_id AS id,").append(" record.c_asset_type AS assetType,").append(" record.n_success AS success,").append(" record.n_failure AS failure,").append(" record.n_reg_time AS regTime,").append(" record.c_failure_path AS failurePath,").append(" record.n_nativate_status AS nativateStatus").append(" FROM t_load_record record").append(" WHERE 1 = 1");
        if (null != queryBean) {
            if (null != queryBean.getStart()) {
                sqlBuilder.append(" AND record.n_reg_time >= :startTime");
                sqlParameterSource.addValue("startTime", (Object)queryBean.getStart());
            }
            if (null != queryBean.getEnd()) {
                sqlBuilder.append(" AND record.n_reg_time <= :endTime");
                sqlParameterSource.addValue("endTime", (Object)queryBean.getEnd());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)sortName) && StringUtils.isNotEmpty((CharSequence)sortType)) {
            sqlBuilder.append(" ORDER BY " + sortName + " " + sortType);
        } else {
            sqlBuilder.append(" ORDER BY record.n_reg_time DESC");
        }
        return this.queryForPage(sqlBuilder.toString(), pageSize, pageNo, sqlParameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(TLoadRecord.class));
    }

    public Pagination<TAssetInfo> queryLoadRecordDetails(TLoadRecord condition, Integer pageNo, Integer pageSize, String sortName, String sortType) {
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT").append(" customer.c_name AS customerName,").append(" oder.c_name AS orderName,").append(" asset.c_asset_identify AS assetIdentify,").append(" asset.c_card_no AS cardNo,").append(" asset.c_asset_type AS assetType,").append(" asset.c_relation_asset_identify AS relationAssetIdentify,").append(" asset.n_time AS time,").append(" asset.n_production_time AS productionTime,").append(" asset.n_id AS id").append(" FROM").append(" t_asset_info asset").append(" JOIN t_customer customer ON customer.n_id = asset.n_customer_id").append(" LEFT JOIN t_order_asset oass ON oass.n_asset_id = asset.n_id").append(" LEFT JOIN t_order oder ON oder.n_id = oass.n_order_id").append(" WHERE n_record_id = :recordId");
        sqlParameterSource.addValue("recordId", (Object)condition.getId());
        if (StringUtils.isNotEmpty((CharSequence)sortName) && StringUtils.isNotEmpty((CharSequence)sortType)) {
            sqlBuffer.append(" ORDER BY " + sortName + " " + sortType);
        } else {
            sqlBuffer.append(" ORDER BY asset.n_production_time DESC");
        }
        return this.queryForPage(sqlBuffer.toString(), pageSize, pageNo, sqlParameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(TAssetInfo.class));
    }

    public void removeLogByRecordId(Long recordId) {
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        StringBuffer sqlBuffer = new StringBuffer("DELETE FROM t_activate_log WHERE EXISTS(SELECT * FROM t_asset_info info");
        sqlBuffer.append(" WHERE info.n_record_id = :recordId AND info.c_card_no = t_activate_log.c_card_no)");
        sqlParameterSource.addValue("recordId", (Object)recordId);
        this.executeSql(sqlBuffer.toString(), (SqlParameterSource)sqlParameterSource);
    }

    public List<AmsAsset> queryAmsAssetList(Long recordId) {
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT info.c_asset_identify AS assetIdentify,info.c_asset_type AS assetType, info.c_card_no AS cardNo,");
        sqlBuffer.append(" info.c_serial_code AS serialCode,info.n_time AS time,info.c_relation_asset_identify AS relationAssetIdentify,");
        sqlBuffer.append(" info.n_status AS status, info.c_norms AS norms, info.c_firmware_version AS firmwareVersion,");
        sqlBuffer.append(" info.c_init_script AS initScript, info.c_senior_public AS seniorPublic, info.c_cos_version AS cosVersion");
        sqlBuffer.append(" FROM t_asset_info info ");
        sqlBuffer.append(" WHERE n_record_id = :recordId");
        sqlParameterSource.addValue("recordId", (Object)recordId);
        return this.queryForList(sqlBuffer.toString(), (SqlParameterSource)sqlParameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(AmsAsset.class));
    }

    public List<AmsAsset> queryAmsAssetList(List<String> cardList) {
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append(" SELECT info.c_asset_identify AS assetIdentify,info.c_asset_type AS assetType, info.c_card_no AS cardNo,");
        sqlBuffer.append(" info.c_serial_code AS serialCode,info.n_time AS time,info.c_relation_asset_identify AS relationAssetIdentify,");
        sqlBuffer.append(" info.n_status AS status, info.c_norms AS norms, info.c_firmware_version AS firmwareVersion,");
        sqlBuffer.append(" info.c_init_script AS initScript, info.c_senior_public AS seniorPublic, info.c_cos_version AS cosVersion");
        sqlBuffer.append(" FROM t_asset_info info ");
        sqlBuffer.append(" WHERE c_asset_identify IN (:cardList)");
        sqlParameterSource.addValue("cardList", cardList);
        return this.queryForList(sqlBuffer.toString(), (SqlParameterSource)sqlParameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(AmsAsset.class));
    }

    public List<AmsAssetMobilesInfo> queryAmsAssetMobilesInfoList(List<String> assetIdentifyList) {
        if (!assetIdentifyList.isEmpty()) {
            MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append(" SELECT mobile.c_model AS model,mobile.c_os_name AS osName, ");
            sqlBuffer.append(" mobile.c_os_version AS osVersion,mobile.c_chip_code AS chipCode,mobile.c_imei AS imei,asset.c_card_no AS cardno, c_sn_no AS snNo ");
            sqlBuffer.append(" FROM t_asset_mobiles_info mobile ");
            sqlBuffer.append(" JOIN t_asset_info asset ON asset.n_id = mobile.n_asset_id ");
            sqlBuffer.append(" WHERE asset.c_asset_identify IN (:assetIdentify)");
            sqlParameterSource.addValue("assetIdentify", assetIdentifyList);
            return this.queryForList(sqlBuffer.toString(), (SqlParameterSource)sqlParameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(AmsAssetMobilesInfo.class));
        }
        return new ArrayList<AmsAssetMobilesInfo>();
    }
}

