/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.assetmanager.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanUtil {
    private static final Logger logger = LoggerFactory.getLogger(BeanUtil.class);

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                logger.error("Unable to close " + closeable, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static <M extends Serializable> M deserialize(byte[] in) {
        ObjectInputStream is;
        ByteArrayInputStream bis;
        Serializable m;
        block6: {
            m = null;
            bis = null;
            is = null;
            try {
                if (null == in || in.length <= 0) break block6;
                bis = new ByteArrayInputStream(in);
                is = new ObjectInputStream(bis);
                m = (Serializable)is.readObject();
            }
            catch (IOException e) {
                logger.error(String.format("Caught IOException decoding %d bytes of data", in.length) + e);
                BeanUtil.close(is);
                BeanUtil.close(bis);
            }
            catch (ClassNotFoundException e2) {
                logger.error(String.format("Caught CNFE decoding %d bytes of data", in.length) + e2);
                {
                    catch (Throwable throwable) {
                        BeanUtil.close(is);
                        BeanUtil.close(bis);
                        throw throwable;
                    }
                }
                BeanUtil.close(is);
                BeanUtil.close(bis);
            }
        }
        BeanUtil.close(is);
        BeanUtil.close(bis);
        return (M)m;
    }

    public static <T extends Serializable> byte[] serialize(T t) {
        if (null == t) {
            throw new NullPointerException("Can't serialize null");
        }
        byte[] results = null;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream os = null;
        try {
            bos = new ByteArrayOutputStream();
            os = new ObjectOutputStream(bos);
            os.writeObject(t);
            results = bos.toByteArray();
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Non-serializable object", e);
            }
            catch (Throwable throwable) {
                BeanUtil.close(os);
                BeanUtil.close(bos);
                throw throwable;
            }
        }
        BeanUtil.close(os);
        BeanUtil.close(bos);
        return results;
    }
}

