/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.cardactivate.dao;

import com.xdja.cssp.ams.cardactivate.entity.TActivateLog;
import com.xdja.cssp.ams.core.util.DateQueryBean;
import com.xdja.platform.datacenter.jpa.dao.BaseJpaDao;
import com.xdja.platform.datacenter.jpa.page.Pagination;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ActivateLogDao
extends BaseJpaDao<TActivateLog, Long> {
    public Pagination<TActivateLog> queryActivateLogs(TActivateLog condition, Integer pageNo, Integer pageSize, String sortName, String sortType, DateQueryBean queryBean) {
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        StringBuilder sqlBuilder = new StringBuilder("SELECT log.n_id AS id,").append(" customer.c_name AS customerName,").append(" log.c_card_no AS cardNo,").append(" log.n_mode AS MODE,").append(" log.c_ip AS ip,").append(" log.n_status AS synchStatus,").append(" log.n_time AS activateTime").append(" FROM").append(" t_activate_log log").append(" JOIN t_asset_info asset ON log.c_card_no = asset.c_asset_identify").append(" LEFT JOIN t_customer customer ON customer.n_id = asset.n_customer_id").append(" WHERE 1 = 1");
        if (null != condition) {
            if (null != condition.getSynchStatus()) {
                sqlBuilder.append(" AND log.n_status = :synchStatus");
                sqlParameterSource.addValue("synchStatus", (Object)condition.getSynchStatus());
            }
            if (null != condition.getCustomerName()) {
                sqlBuilder.append(" AND customer.c_name LIKE :customerName");
                sqlParameterSource.addValue("customerName", (Object)("%" + condition.getCustomerName() + "%"));
            }
        }
        if (null != queryBean) {
            if (null != queryBean.getStart()) {
                sqlBuilder.append(" AND log.n_time >= :startTime");
                sqlParameterSource.addValue("startTime", (Object)queryBean.getStart());
            }
            if (null != queryBean.getEnd()) {
                sqlBuilder.append(" AND log.n_time <= :endTime");
                sqlParameterSource.addValue("endTime", (Object)queryBean.getEnd());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)sortName) && StringUtils.isNotEmpty((CharSequence)sortType)) {
            sqlBuilder.append(" ORDER BY " + sortName + " " + sortType);
        } else {
            sqlBuilder.append(" ORDER BY log.n_time DESC");
        }
        return this.queryForPage(sqlBuilder.toString(), pageSize, pageNo, sqlParameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(TActivateLog.class));
    }
}

