/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.customer.dao;

import com.xdja.cssp.ams.customer.entity.Order;
import com.xdja.cssp.ams.customer.entity.Project;
import com.xdja.platform.datacenter.jpa.dao.BaseJpaDao;
import com.xdja.platform.datacenter.jpa.page.Pagination;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class OrderDao
extends BaseJpaDao<Order, Long> {
    public Pagination<Order> queryOrders(Order order, Integer pageNo, Integer pageSize, String sortName, String sortType) {
        StringBuilder sqlBuilder = new StringBuilder("SELECT").append(" oder.n_id AS id,").append(" oder.n_customer_id AS customerId,").append(" oder.c_name AS name,").append(" oder.n_origin AS origin,").append(" oder.n_time AS orderTime,").append(" customer.c_name AS customerName,").append(" project.c_name AS projectName,").append(" oder.n_order_type AS activeType,").append(" oder.n_license AS activeLicense").append(" FROM").append(" t_order oder").append(" LEFT JOIN t_customer customer ON customer.n_id = oder.n_customer_id").append(" LEFT JOIN t_project project ON project.n_id = oder.n_project_id WHERE 1=1 ");
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        if (StringUtils.isNotEmpty((CharSequence)order.getCustomerName())) {
            sqlBuilder.append("AND customer.c_name LIKE :customerName ESCAPE '/' ");
            sqlParameterSource.addValue("customerName", (Object)("%" + order.getCustomerName().replaceAll("%", "/%").replaceAll("_", "/_") + "%"));
        }
        if (StringUtils.isNotEmpty((CharSequence)order.getProjectName())) {
            sqlBuilder.append("AND project.c_name LIKE :projectName ESCAPE '/' ");
            sqlParameterSource.addValue("projectName", (Object)("%" + order.getProjectName().replaceAll("%", "/%").replaceAll("_", "/_") + "%"));
        }
        if (StringUtils.isNotEmpty((CharSequence)order.getName())) {
            sqlBuilder.append("AND oder.c_name LIKE :orderName ESCAPE '/' ");
            sqlParameterSource.addValue("orderName", (Object)("%" + order.getName().replaceAll("%", "/%").replaceAll("_", "/_") + "%"));
        }
        if (StringUtils.isNotEmpty((CharSequence)sortName) && StringUtils.isNotEmpty((CharSequence)sortType)) {
            sqlBuilder.append("ORDER BY " + sortName + " " + sortType);
        } else {
            sqlBuilder.append("ORDER BY orderTime DESC ");
        }
        return this.queryForPage(sqlBuilder.toString(), pageSize, pageNo, sqlParameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(Order.class));
    }

    public Pagination<Order> queryOrderDetails(Project condition, Integer pageNo, Integer pageSize, String sortName, String sortType) {
        StringBuilder sqlBuilder = new StringBuilder("SELECT").append(" oder.n_id AS id,").append(" oder.n_customer_id AS customerId,").append(" oder.c_name AS name,").append(" oder.n_time AS orderTime,").append(" customer.c_name AS customerName,").append(" project.c_name AS projectName,").append(" oder.n_order_type AS activeType,").append(" oder.n_license AS activeLicense").append(" FROM").append(" t_order oder").append(" LEFT JOIN t_customer customer ON customer.n_id = oder.n_customer_id").append(" LEFT JOIN t_project project ON project.n_id = oder.n_project_id").append(" WHERE oder.n_project_id = :projectId");
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        sqlParameterSource.addValue("projectId", (Object)condition.getId());
        if (StringUtils.isNotEmpty((CharSequence)sortName) && StringUtils.isNotEmpty((CharSequence)sortType)) {
            sqlBuilder.append(" ORDER BY " + sortName + " " + sortType);
        } else {
            sqlBuilder.append(" ORDER BY orderTime DESC ");
        }
        return this.queryForPage(sqlBuilder.toString(), pageSize, pageNo, sqlParameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(Order.class));
    }

    public List<Map<String, Object>> queryOrdersByProjectId(Long projectId) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT n_id AS id, c_name AS name FROM ").append("t_order WHERE ").append("n_project_id = :projectId ");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("projectId", (Object)projectId);
        return this.queryForList(sqlBuilder.toString(), (SqlParameterSource)params);
    }
}

