/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.customer.dao;

import com.xdja.cssp.ams.customer.entity.Project;
import com.xdja.platform.datacenter.jpa.dao.BaseJpaDao;
import com.xdja.platform.datacenter.jpa.page.Pagination;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ProjectDao
extends BaseJpaDao<Project, Long> {
    public Pagination<Project> queryProjects(Project project, Integer pageNo, Integer pageSize, String sortName, String sortType) {
        StringBuilder sqlBuilder = new StringBuilder("SELECT").append(" pro.n_id AS id,").append(" pro.c_name AS projectName,").append(" customer.c_name AS customerName,").append(" pro.n_reg_time AS regTime").append(" FROM").append(" t_project pro").append(" LEFT JOIN t_customer customer ON customer.n_id = pro.n_customer_id WHERE 1=1 ");
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        if (StringUtils.isNotEmpty((CharSequence)project.getProjectName())) {
            sqlBuilder.append("AND pro.c_name LIKE :projectName ESCAPE '/' ");
            sqlParameterSource.addValue("projectName", (Object)("%" + project.getProjectName().replaceAll("%", "/%").replaceAll("_", "/_") + "%"));
        }
        if (StringUtils.isNotEmpty((CharSequence)project.getCustomerName())) {
            sqlBuilder.append("AND customer.c_name LIKE :customerName ESCAPE '/' ");
            sqlParameterSource.addValue("customerName", (Object)("%" + project.getCustomerName().replaceAll("%", "/%").replaceAll("_", "/_") + "%"));
        }
        if (null != project.getCustomerId()) {
            sqlBuilder.append("AND customer.n_id = :customerId ");
            sqlParameterSource.addValue("customerId", (Object)project.getCustomerId());
        }
        if (StringUtils.isNotEmpty((CharSequence)sortName) && StringUtils.isNotEmpty((CharSequence)sortType)) {
            sqlBuilder.append("ORDER BY " + sortName + " " + sortType);
        } else {
            sqlBuilder.append("ORDER BY regTime DESC ");
        }
        return this.queryForPage(sqlBuilder.toString(), pageSize, pageNo, sqlParameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(Project.class));
    }

    public List<Project> queryCustomerProjects(Long customerId) {
        StringBuilder sqlBuilder = new StringBuilder("SELECT ").append("n_id AS id, c_name AS projectName FROM t_project ").append("WHERE 1=1 ");
        MapSqlParameterSource params = new MapSqlParameterSource();
        if (null != customerId) {
            sqlBuilder.append("AND n_customer_id = :customerId ");
            params.addValue("customerId", (Object)customerId);
        }
        return this.queryForList(sqlBuilder.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(Project.class));
    }
}

