/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.customer.business.impl;

import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import com.xdja.cssp.ams.customer.business.ICustomerBusiness;
import com.xdja.cssp.ams.customer.dao.CustomerDao;
import com.xdja.cssp.ams.customer.dao.CustomerJdbcDao;
import com.xdja.cssp.ams.customer.dao.CustomerUserCertDao;
import com.xdja.cssp.ams.customer.dao.CustomerUserDao;
import com.xdja.cssp.ams.customer.dao.OrderDao;
import com.xdja.cssp.ams.customer.dao.ProjectDao;
import com.xdja.cssp.ams.customer.entity.Customer;
import com.xdja.cssp.ams.customer.entity.CustomerUser;
import com.xdja.cssp.ams.customer.entity.CustomerUserCert;
import com.xdja.cssp.ams.customer.entity.Project;
import com.xdja.platform.datacenter.jpa.page.Pagination;
import com.xdja.platform.rpc.proxy.PagingConverter;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CustomerBusinessImpl
implements ICustomerBusiness {
    @Resource
    private CustomerDao customerDao;
    @Resource
    private CustomerUserDao customerUserDao;
    @Resource
    private CustomerUserCertDao customerUserCertDao;
    @Resource
    private CustomerJdbcDao customerJdbcDao;
    @Resource
    private ProjectDao projectDao;
    @Resource
    private OrderDao orderDao;

    @Override
    public Pagination<Customer> queryCustomers(Customer condition, Integer pageNo, Integer pageSize, String orderColName, String orderDir) {
        return this.customerDao.queryCustomers(condition, pageNo, pageSize, orderColName, orderDir);
    }

    @Override
    public void saveCustomer(Customer customer) {
        this.customerDao.save(customer);
    }

    @Override
    public Customer getCustomerById(Long customerId) {
        return (Customer)this.customerDao.find(customerId);
    }

    @Override
    public Pagination<CustomerUser> queryCustomerUsers(CustomerUser customerUser, Integer pageNo, Integer pageSize, String orderColName, String orderDir) {
        return this.customerUserDao.queryCustomerUsers(customerUser, pageNo, pageSize, orderColName, orderDir);
    }

    @Override
    public List<Customer> getAllCustomer() {
        return this.customerDao.findAll();
    }

    @Override
    public void saveCustomerUser(CustomerUser customerUser) {
        if (null != customerUser.getId()) {
            CustomerUser returnCustomerUser = (CustomerUser)this.customerUserDao.find(customerUser.getId());
            customerUser.setPassword(returnCustomerUser.getPassword());
        }
        this.customerUserDao.save(customerUser);
    }

    @Override
    public CustomerUser getCustomerUserById(Long customerUserId) {
        return (CustomerUser)this.customerUserDao.find(customerUserId);
    }

    @Override
    public void changeAccountStatus(Long customerUserId, Integer targetStatus) {
        this.customerUserDao.changeAccountStatus(customerUserId, targetStatus);
    }

    @Override
    public boolean isAccountExist(Long customerUserId, String account) {
        Search search = new Search();
        if (null != customerUserId) {
            search.addFilterNotEqual("id", (Object)customerUserId);
        }
        search.addFilterEqual("account", (Object)account);
        return this.customerUserDao.count((ISearch)search) > 0;
    }

    @Override
    public Pagination<CustomerUserCert> queryAllCustomerUserCert(Long customerUserId, Integer pageNo, Integer pageSize, String orderColName, String orderDir) {
        return this.customerUserCertDao.queryAllCustomerUserCert(customerUserId, pageNo, pageSize, orderColName, orderDir);
    }

    @Override
    public Integer queryCustomerUserCertByCardId(String cardId) {
        return this.customerUserCertDao.queryCustomerUserCertByCardId(cardId);
    }

    @Override
    public void saveCustomerUserCert(CustomerUserCert customerUserCert) {
        this.customerUserCertDao.save(customerUserCert);
    }

    @Override
    public void deleteUserCertById(Long userCertId) {
        this.customerUserCertDao.removeById(userCertId);
    }

    @Override
    public boolean isNameExsit(Long customerId, String name) {
        Search search = new Search();
        if (null != customerId) {
            search.addFilterNotEqual("id", (Object)customerId);
        }
        search.addFilterEqual("name", (Object)name);
        return this.customerDao.count((ISearch)search) > 0;
    }

    @Override
    public CustomerUserCert queryUserCertById(Long id) {
        return (CustomerUserCert)this.customerUserCertDao.find(id);
    }

    @Override
    public LitePaging<Customer> queryAssetDetails(Customer condition, Integer pageNo, Integer pageSize, String sortName, String sortType) {
        return PagingConverter.convert(this.customerJdbcDao.queryAssetDetails(condition, pageNo, pageSize, sortName, sortType));
    }

    @Override
    public List<Customer> queryAllCustomer() {
        return this.customerDao.queryAllCustomer();
    }

    @Override
    public List<Project> queryCustomerProjects(Long customerId) {
        return this.projectDao.queryCustomerProjects(customerId);
    }

    @Override
    public List<Map<String, Object>> queryOrdersByProjectId(Long projectId) {
        return this.orderDao.queryOrdersByProjectId(projectId);
    }
}

