/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.customer.dao;

import com.xdja.cssp.ams.assetmanager.entity.BakcardCondition;
import com.xdja.cssp.ams.assetmanager.entity.TAssetInfo;
import com.xdja.cssp.ams.customer.entity.Order;
import com.xdja.platform.datacenter.jpa.dao.BaseJdbcDao;
import com.xdja.platform.datacenter.jpa.page.Pagination;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class OrderJdbcDao
extends BaseJdbcDao {
    public Pagination<TAssetInfo> queryAssetDetails(Order condition, Integer pageNo, Integer pageSize, String sortName, String sortType) {
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT").append(" asset.c_asset_identify AS assetIdentify,").append(" asset.c_card_no AS cardNo,").append(" asset.c_asset_type AS assetType,").append(" asset.c_relation_asset_identify AS relationAssetIdentify,").append(" asset.n_time AS time,").append(" asset.n_production_time AS productionTime,").append(" asset.n_id AS id,").append(" oder.c_name AS orderName,").append(" al.n_activate_status activateStatus,").append(" asset.n_status AS status").append(" FROM").append(" t_asset_info asset").append(" JOIN t_customer customer ON customer.n_id = asset.n_customer_id").append(" JOIN t_order_asset oass ON oass.n_asset_id = asset.n_id").append(" JOIN t_order oder ON oder.n_id = oass.n_order_id").append(" LEFT JOIN t_activate_log al ON asset.c_card_no = al.c_card_no").append(" WHERE oass.n_order_id = :orderId");
        sqlParameterSource.addValue("orderId", (Object)condition.getId());
        if (StringUtils.isNotEmpty((CharSequence)sortName) && StringUtils.isNotEmpty((CharSequence)sortType)) {
            sqlBuffer.append(" ORDER BY " + sortName + " " + sortType);
        } else {
            sqlBuffer.append(" ORDER BY asset.n_production_time DESC");
        }
        return this.queryForPage(sqlBuffer.toString(), pageSize, pageNo, sqlParameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(TAssetInfo.class));
    }

    public List<Map<String, Object>> queryCardActiveCount(List<Long> orderIds) {
        StringBuilder sqlBuilder = new StringBuilder("SELECT COUNT(1) AS count, ordass.n_order_id AS orderId").append(" FROM t_order_asset ordass JOIN t_asset_info asset ON ordass.n_asset_id = asset.n_id").append(" WHERE asset.n_status = :status AND ordass.n_order_id IN (:orderIds)").append(" GROUP BY ordass.n_order_id");
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        sqlParam.addValue("status", (Object)TAssetInfo.ENUM_ACTIVATE_STATUS.active.value);
        sqlParam.addValue("orderIds", orderIds);
        return this.queryForList(sqlBuilder.toString(), (SqlParameterSource)sqlParam);
    }

    public List<Map<String, Object>> queryCardCount(List<Long> orderIds) {
        StringBuilder sqlBuilder = new StringBuilder("").append(" SELECT COUNT(1) AS count, ordass.n_order_id AS orderId FROM t_order_asset ordass").append(" WHERE ordass.n_order_id IN (:orderIds)").append(" GROUP BY ordass.n_order_id");
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        sqlParam.addValue("orderIds", orderIds);
        return this.queryForList(sqlBuilder.toString(), (SqlParameterSource)sqlParam);
    }

    public Map<Long, Long> queryOrderProject(List<Long> projectIds) {
        final HashMap<Long, Long> orderMap = new HashMap<Long, Long>();
        StringBuffer sql = new StringBuffer("SELECT n_id, n_project_id FROM t_order WHERE n_project_id IN (:projectIds)");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("projectIds", projectIds);
        this.queryForList(sql.toString(), (SqlParameterSource)params, (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                orderMap.put(rs.getLong("n_id"), rs.getLong("n_project_id"));
                return null;
            }
        });
        return orderMap;
    }

    public List<Map<String, Object>> queryCardActiveParamCount(List<Long> orderIdList) {
        StringBuilder sqlBuilder = new StringBuilder("SELECT COUNT(1) AS count, ordass.n_order_id AS orderId").append(" FROM t_order_asset ordass JOIN t_asset_info asset ON ordass.n_asset_id = asset.n_id").append(" WHERE EXISTS (SELECT log.n_id FROM t_activate_log log").append(" WHERE log.c_card_no = asset.c_asset_identify AND log.n_activate_status = :status)").append(" AND ordass.n_order_id IN (:orderIds)").append(" GROUP BY ordass.n_order_id");
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        sqlParam.addValue("status", (Object)TAssetInfo.ENUM_CHIP_STATUS.activateParam.value);
        sqlParam.addValue("orderIds", orderIdList);
        return this.queryForList(sqlBuilder.toString(), (SqlParameterSource)sqlParam);
    }

    public Object queryBakcardDetails(Order condition, Integer pageNo, Integer pageSize, String sortName, String sortType) {
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT").append(" bakcard.c_bakcard_sn AS bakcardSN, bakcard.n_asset_type AS assetType, ").append(" bakcard.n_production_time AS productTime, bakcard.n_time AS time, ").append(" bakcard.c_verify_code verifyCode, bakcard.c_recover_code AS recoverCode, ").append(" bakcard.n_status AS status").append(" FROM t_bakcard_info bakcard ").append(" JOIN t_order_bakcard ob ON ob.n_bakupcard_id = bakcard.n_id ").append(" JOIN t_order o ON o.n_id = ob.n_order_id ").append(" WHERE o.n_id = :orderId");
        sqlParameterSource.addValue("orderId", (Object)condition.getId());
        if (StringUtils.isNotEmpty((CharSequence)sortName) && StringUtils.isNotEmpty((CharSequence)sortType)) {
            sqlBuffer.append(" ORDER BY " + sortName + " " + sortType);
        } else {
            sqlBuffer.append(" ORDER BY bakcard.n_production_time DESC");
        }
        return this.queryForPage(sqlBuffer.toString(), pageSize, pageNo, sqlParameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(BakcardCondition.class));
    }
}

