/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.customer.dao;

import com.xdja.cssp.ams.customer.entity.CustomerUser;
import com.xdja.platform.datacenter.jpa.dao.BaseJpaDao;
import com.xdja.platform.datacenter.jpa.page.Pagination;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CustomerUserDao
extends BaseJpaDao<CustomerUser, Long> {
    public Pagination<CustomerUser> queryCustomerUsers(CustomerUser customerUser, Integer pageNo, Integer pageSize, String orderColName, String orderDir) {
        StringBuilder sqlBuilder = new StringBuilder("SELECT usr.n_id AS id, usr.c_account AS account, ").append("usr.n_status AS accountStatus, usr.n_time AS time, cust.c_name AS customerName ").append(" FROM t_customer_user usr, t_customer cust WHERE usr.n_customer_id = cust.n_id ");
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        String account = customerUser.getAccount();
        String customerName = customerUser.getCustomerName();
        Integer accountStatus = customerUser.getAccountStatus();
        if (StringUtils.isNotEmpty((CharSequence)account)) {
            sqlBuilder.append("AND usr.c_account LIKE :account ESCAPE '/' ");
            account = account.replaceAll("%", "/%");
            account = account.replaceAll("_", "/_");
            sqlParameterSource.addValue("account", (Object)("%" + account + "%"));
        }
        if (StringUtils.isNotEmpty((CharSequence)customerName)) {
            sqlBuilder.append("AND cust.c_name LIKE :customerName ESCAPE '/' ");
            customerName = customerName.replaceAll("%", "/%");
            customerName = customerName.replaceAll("_", "/_");
            sqlParameterSource.addValue("customerName", (Object)("%" + customerName + "%"));
        }
        if (null != accountStatus) {
            sqlBuilder.append("AND usr.n_status = :accountStatus ");
            sqlParameterSource.addValue("accountStatus", (Object)accountStatus);
        }
        if (StringUtils.isNotEmpty((CharSequence)orderColName) && StringUtils.isNotEmpty((CharSequence)orderDir)) {
            sqlBuilder.append("ORDER BY " + orderColName + " " + orderDir);
        } else {
            sqlBuilder.append("ORDER BY usr.n_time DESC ");
        }
        return this.queryForPage(sqlBuilder.toString(), pageSize, pageNo, sqlParameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(CustomerUser.class));
    }

    public void changeAccountStatus(Long customerUserId, Integer targetStatus) {
        String sql = "UPDATE t_customer_user SET n_status = :targetStatus WHERE n_id = :customerUserId ";
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        sqlParameterSource.addValue("targetStatus", (Object)targetStatus);
        sqlParameterSource.addValue("customerUserId", (Object)customerUserId);
        this.executeSql(sql, (SqlParameterSource)sqlParameterSource);
    }
}

