/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.customer.service.impl;

import com.xdja.cssp.ams.customer.business.ICustomerBusiness;
import com.xdja.cssp.ams.customer.entity.Customer;
import com.xdja.cssp.ams.customer.entity.CustomerUser;
import com.xdja.cssp.ams.customer.entity.CustomerUserCert;
import com.xdja.cssp.ams.customer.entity.Project;
import com.xdja.cssp.ams.customer.service.ICustomerService;
import com.xdja.cssp.ams.customer.util.CertUtil;
import com.xdja.platform.rpc.proxy.PagingConverter;
import com.xdja.platform.rpc.proxy.page.LitePaging;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class CustomerServiceImpl
implements ICustomerService {
    @Resource
    private ICustomerBusiness customerBusiness;

    public LitePaging<Customer> queryCustomers(Customer condition, Integer pageNo, Integer pageSize, String orderColName, String orderDir) {
        return PagingConverter.convert(this.customerBusiness.queryCustomers(condition, pageNo, pageSize, orderColName, orderDir));
    }

    public void saveCustomer(Customer customer) {
        this.customerBusiness.saveCustomer(customer);
    }

    public Customer getCustomerById(Long customerId) {
        return this.customerBusiness.getCustomerById(customerId);
    }

    public LitePaging<CustomerUser> queryCustomerUsers(CustomerUser customerUser, Integer pageNo, Integer pageSize, String orderColName, String orderDir) {
        return PagingConverter.convert(this.customerBusiness.queryCustomerUsers(customerUser, pageNo, pageSize, orderColName, orderDir));
    }

    public List<Customer> getAllCustomer() {
        return this.customerBusiness.getAllCustomer();
    }

    public void saveCustomerUser(CustomerUser customerUser) {
        this.customerBusiness.saveCustomerUser(customerUser);
    }

    public CustomerUser getCustomerUserById(Long customerUserId) {
        return this.customerBusiness.getCustomerUserById(customerUserId);
    }

    public void changeAccountStatus(Long customerUserId, Integer targetStatus) {
        this.customerBusiness.changeAccountStatus(customerUserId, targetStatus);
    }

    public boolean isAccountExist(Long customerUserId, String account) {
        return this.customerBusiness.isAccountExist(customerUserId, account);
    }

    public LitePaging<CustomerUserCert> queryAllCustomerUserCert(Long customerUserId, Integer pageNo, Integer pageSize, String orderColName, String orderDir) {
        return PagingConverter.convert(this.customerBusiness.queryAllCustomerUserCert(customerUserId, pageNo, pageSize, orderColName, orderDir));
    }

    public Object[] queryCustomerUserCertByCardId(String cert) {
        if (StringUtils.isNotBlank((CharSequence)cert)) {
            Object[] returnArray = new Object[3];
            String[] certArray = cert.split("#");
            String cardId = certArray[0];
            returnArray[0] = cardId;
            X509Certificate clientCert = CertUtil.getCertFromStr16((String)certArray[1]);
            String snToBind = clientCert.getSerialNumber().toString(16).toLowerCase();
            returnArray[1] = snToBind;
            returnArray[2] = 0 < this.customerBusiness.queryCustomerUserCertByCardId(cardId) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            return returnArray;
        }
        throw new IllegalArgumentException("\u7528\u6237Id\u4e3a\u7a7a");
    }

    public void saveCustomerUserCert(CustomerUserCert customerUserCert) {
        if (null != customerUserCert) {
            Integer bindCount = this.customerBusiness.queryCustomerUserCertByCardId(customerUserCert.getCardId());
            if (0 != bindCount) {
                throw new IllegalArgumentException("\u5b89\u5168\u5361\u5df2\u88ab\u4f7f\u7528");
            }
        } else {
            throw new IllegalArgumentException("\u4fdd\u5b58\u4fe1\u606f\u4e3a\u7a7a");
        }
        this.customerBusiness.saveCustomerUserCert(customerUserCert);
    }

    public void deleteUserCertById(String userCertId) {
        if (null == userCertId) {
            throw new IllegalArgumentException("\u5361\u7ed1\u5b9aId\u4e3a\u7a7a");
        }
        this.customerBusiness.deleteUserCertById(Long.valueOf(userCertId));
    }

    public boolean isNameExsit(Long customerId, String name) {
        return this.customerBusiness.isNameExsit(customerId, name);
    }

    public CustomerUserCert queryUserCertById(Long id) {
        return this.customerBusiness.queryUserCertById(id);
    }

    public LitePaging<Customer> queryAssetDetails(Customer condition, Integer pageNo, Integer pageSize, String sortName, String sortType) {
        return this.customerBusiness.queryAssetDetails(condition, pageNo, pageSize, sortName, sortType);
    }

    public List<Customer> queryAllCustomer() {
        return this.customerBusiness.queryAllCustomer();
    }

    public List<Project> queryCustomerProjects(Long customerIdLong) {
        return this.customerBusiness.queryCustomerProjects(customerIdLong);
    }

    public List<Map<String, Object>> queryProjectOrders(Long projectId) {
        return this.customerBusiness.queryOrdersByProjectId(projectId);
    }
}

