/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.log.entity;

import com.xdja.platform.util.DateTimeUtil;
import java.io.Serializable;
import java.util.HashMap;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="t_log")
public class SystemLog
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private Long userId;
    private String userName;
    private String userIp;
    private String className;
    private String logContent;
    private Integer logLevel;
    private String methodInfo;
    private Long logTime;
    private Integer logType;
    private Integer modelType;

    @Id
    @GeneratedValue
    @Column(name="n_id", unique=true, nullable=false)
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="n_user_id", length=20)
    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Column(name="c_user", length=32)
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Column(name="c_ip", length=16)
    public String getUserIp() {
        return this.userIp;
    }

    public void setUserIp(String userIp) {
        this.userIp = userIp;
    }

    @Column(name="c_class_name", length=64)
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @Column(name="c_content", length=512)
    public String getLogContent() {
        return this.logContent;
    }

    public void setLogContent(String logContent) {
        this.logContent = logContent;
    }

    @Column(name="n_level", nullable=false, length=4)
    public Integer getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(Integer logLevel) {
        this.logLevel = logLevel;
    }

    @Column(name="c_method_info", length=64)
    public String getMethodInfo() {
        return this.methodInfo;
    }

    public void setMethodInfo(String methodInfo) {
        this.methodInfo = methodInfo;
    }

    @Column(name="n_time", nullable=false)
    public Long getLogTime() {
        return this.logTime;
    }

    @Transient
    public String getLogTimeLable() {
        return DateTimeUtil.longToDateStr((long)this.logTime);
    }

    public void setLogTime(Long logTime) {
        this.logTime = logTime;
    }

    @Column(name="n_type", nullable=false, length=11)
    public Integer getLogType() {
        return this.logType;
    }

    public void setLogType(Integer logType) {
        this.logType = logType;
    }

    @Column(name="n_model_type", length=4)
    public Integer getModelType() {
        return this.modelType;
    }

    public void setModelType(Integer modelType) {
        this.modelType = modelType;
    }

    @Transient
    public String getLogTypeLable() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(1, "\u767b\u5f55\u9000\u51fa");
        map.put(2, "\u64cd\u4f5c\u65e5\u5fd7");
        map.put(3, "\u8fd0\u884c\u65e5\u5fd7");
        map.put(4, "\u5b89\u5168\u65e5\u5fd7");
        return (String)map.get(this.logType);
    }

    public static enum ENUM_LOG_LEVEL {
        debug(1),
        info(2),
        warn(3),
        error(4),
        trace(5);

        public int value;

        private ENUM_LOG_LEVEL(int value) {
            this.value = value;
        }
    }

    public static enum ENUM_LOG_MODEL_TYPE {
        customerManagerLog(1),
        assetManagerLog(2),
        cardActivateMonitiorLog(3),
        systemManagerLog(4);

        public int value;

        private ENUM_LOG_MODEL_TYPE(int value) {
            this.value = value;
        }
    }

    public static enum ENUM_LOG_TYPE {
        loginLog(1),
        operateLog(2),
        runtimeLog(3),
        securityLog(4);

        public Integer value;

        private ENUM_LOG_TYPE(Integer value) {
            this.value = value;
        }
    }
}

