/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.system.util;

import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import org.apache.shiro.codec.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertUtil {
    protected static final Logger LOG = LoggerFactory.getLogger(CertUtil.class);
    public static final String CERT_HEAD = "-----BEGIN CERTIFICATE-----";
    public static final String CERT_TAIL = "-----END CERTIFICATE-----";

    private CertUtil() {
    }

    public static X509Certificate getCertFromStr16(String str) {
        byte[] bs = CertUtil.hex2byte(str);
        CertificateFactory cf = null;
        X509Certificate x509Cert = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream inStream = new ByteArrayInputStream(bs);
            x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception e) {
            LOG.error("getCertFromFullStr error: " + e.toString());
            return null;
        }
    }

    public static byte[] hex2byte(String str) {
        if (null == str || str.equals("")) {
            return null;
        }
        StringBuffer sb = new StringBuffer(str = str.trim());
        int len = sb.length();
        if (len == 0 || len % 2 == 1) {
            return null;
        }
        byte[] b = new byte[len / 2];
        try {
            for (int i = 0; i < len; i += 2) {
                b[i / 2] = (byte)Integer.decode("0x" + sb.substring(i, i + 2)).intValue();
            }
            return b;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getPubKey(String str) {
        LOG.debug("\u8fdb\u5165CertUtil->getPubKey: str:\n" + str);
        X509Certificate x509Cert = CertUtil.getCertFromStr(str);
        RSAPublicKey rsa = (RSAPublicKey)x509Cert.getPublicKey();
        String pubKey = rsa.getModulus().toString(16).toUpperCase();
        return pubKey;
    }

    public static X509Certificate getCertFromStr(String str) {
        X509Certificate x509Cert = null;
        x509Cert = CertUtil.getCertFromStr16(str);
        if (x509Cert == null) {
            x509Cert = CertUtil.getCertFromB64(str);
        }
        if (x509Cert == null) {
            x509Cert = CertUtil.getCertFromFullStr(str);
        }
        return x509Cert;
    }

    public static X509Certificate getCertFromFullStr(String str) {
        CertificateFactory cf = null;
        X509Certificate x509Cert = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream inStream = new ByteArrayInputStream(str.getBytes());
            x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception e) {
            LOG.error("getCertFromFullStr error: " + e.toString());
            return null;
        }
    }

    public static X509Certificate getCertFromB64(String b64) {
        CertificateFactory cf = null;
        X509Certificate x509Cert = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
            byte[] bsCert = Base64.decode((String)b64);
            ByteArrayInputStream inStream = new ByteArrayInputStream(bsCert);
            x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception e) {
            LOG.error("getCertFromB64 error: " + e.toString());
            return null;
        }
    }

    public static String certToFullB64(Certificate cert) {
        String certb64 = "";
        try {
            certb64 = CertUtil.bytesToFullB64(cert.getEncoded());
        }
        catch (Exception e) {
            LOG.error("certToFullB64 error:" + e.toString());
        }
        return certb64;
    }

    public static String bytesToFullB64(byte[] certder) {
        String certb64 = "";
        try {
            certb64 = new String(Base64.encode((byte[])certder));
            certb64 = "-----BEGIN CERTIFICATE-----\n" + certb64 + "\n" + CERT_TAIL + "\n";
            return certb64;
        }
        catch (Exception e) {
            LOG.error("certDerToFullB64 error:" + e.toString(), (Throwable)e);
            return certb64;
        }
    }
}

