/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.system.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlOperation {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private Document doc;
    private String xmlFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlOperation(String xmlFile) {
        this.xmlFile = xmlFile;
        SAXReader reader = new SAXReader();
        FileInputStream xmlFileIS = null;
        try {
            xmlFileIS = new FileInputStream(xmlFile);
            this.doc = reader.read((InputStream)xmlFileIS);
            this.logger.info("\u52a0\u8f7dXML\u6587\u4ef6 " + xmlFile + " \u6210\u529f");
            this.logger.info(this.doc.asXML());
        }
        catch (DocumentException e) {
            this.logger.info("\u52a0\u8f7dXML\u6587\u4ef6 " + xmlFile + " \u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.logger.info("\u52a0\u8f7dXML\u6587\u4ef6 " + xmlFile + " \u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        finally {
            if (xmlFileIS != null) {
                try {
                    ((InputStream)xmlFileIS).close();
                }
                catch (IOException e) {
                    this.logger.error("\u5173\u95ed\u6253\u5f00\u7684\u6587\u4ef6\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    public String getXmlString() {
        return this.doc.asXML();
    }

    public boolean saveXmlString(String fileName, String xmlStr) {
        try {
            this.doc = DocumentHelper.parseText((String)xmlStr);
        }
        catch (DocumentException e) {
            this.logger.error("\u4fdd\u5b58XML\u5b57\u7b26\u4e32\u5931\u8d25\uff0c\u5b57\u7b26\u4e32\u65e0\u6cd5\u8f6c\u6362\u6210\u6807\u51c6XML\uff1a\n" + e.getMessage() + "\n" + xmlStr);
        }
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        XMLWriter writer = null;
        try {
            writer = new XMLWriter((OutputStream)new FileOutputStream(fileName), format);
            writer.write(this.doc);
            writer.close();
            this.logger.info("\u4fdd\u5b58XML\u5b57\u7b26\u4e32\u5230 " + fileName + " \u6210\u529f\u3002");
            return true;
        }
        catch (IOException e) {
            this.logger.error("\u4fdd\u5b58XML\u5b57\u7b26\u4e32\u5931\u8d25\uff0c\u65e0\u6cd5\u5199\u5165\u6587\u4ef6" + fileName);
            return false;
        }
    }

    public boolean saveXmlString(String xmlStr) {
        return this.saveXmlString(this.xmlFile, xmlStr);
    }

    public Document getDoc() {
        if (this.doc == null) {
            this.logger.error("doc\u4e3a\u7a7a\u3002");
        }
        return this.doc;
    }

    public String getValueByXpath(String xpath) {
        Element element = (Element)this.doc.selectSingleNode(xpath);
        return element != null ? element.attributeValue("value") : "";
    }
}

