/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.system.business.impl;

import com.xdja.cssp.ams.system.business.IInitBusiness;
import com.xdja.cssp.ams.system.dao.TUserCertDao;
import com.xdja.cssp.ams.system.dao.TUserDao;
import com.xdja.cssp.ams.system.entity.TUser;
import com.xdja.cssp.ams.system.entity.TUserCert;
import com.xdja.cssp.ams.system.util.CertUtil;
import com.xdja.platform.datacenter.jpa.business.BaseBusiness;
import com.xdja.platform.security.utils.PasswordUtils;
import java.security.cert.X509Certificate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InitBusinessImpl
extends BaseBusiness
implements IInitBusiness {
    @Autowired
    private TUserDao userDao;
    @Autowired
    private TUserCertDao userCertDao;

    @Override
    public boolean isSysInit() {
        return this.userDao.isSysInit() > 0;
    }

    @Override
    public void saveInitUser(TUser user, TUserCert userCert) {
        user.setType(TUser.ENUM_USER_TYPE.systemUser.value);
        user.setStatus(TUser.ENUM_USER_STATUS.normalStatus.value);
        user.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        user.setPassword(PasswordUtils.encodePasswordSHA1((String)user.getPassword()));
        user.setDeleteFlag(TUser.ENUM_DELETE_FLAG.normalFlag.value);
        this.userDao.save(user);
        X509Certificate clientCert = CertUtil.getCertFromStr16((String)userCert.getSn());
        String sn = clientCert.getSerialNumber().toString(16).toLowerCase();
        userCert.setSn(sn);
        userCert.setUserId(user.getId());
        this.userCertDao.save(userCert);
    }
}

