/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.system.business.impl;

import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import com.xdja.cssp.ams.system.business.IRoleBusiness;
import com.xdja.cssp.ams.system.dao.FunctionDao;
import com.xdja.cssp.ams.system.dao.TRoleDao;
import com.xdja.cssp.ams.system.dao.TRoleFunctionDao;
import com.xdja.cssp.ams.system.dao.TUserRoleDao;
import com.xdja.cssp.ams.system.entity.Function;
import com.xdja.cssp.ams.system.entity.TRole;
import com.xdja.cssp.ams.system.entity.TRoleFunction;
import com.xdja.cssp.ams.system.entity.TUserRole;
import com.xdja.platform.datacenter.jpa.business.BaseBusiness;
import com.xdja.platform.datacenter.jpa.page.Pagination;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RoleBusinessImpl
extends BaseBusiness
implements IRoleBusiness {
    @Autowired
    private TRoleDao roleDao;
    @Autowired
    private TUserRoleDao userRoleDao;
    @Autowired
    private TRoleFunctionDao roleFunctionDao;
    @Autowired
    private FunctionDao functionDao;

    @Override
    public void saveRole(TRole role, String funcIds) {
        String[] funcIdsArr = funcIds.split(",");
        Object[] roleFunctionArray = new TRoleFunction[funcIdsArr.length];
        TRoleFunction roleFunction = null;
        if (null == role.getId()) {
            role.setType(TRole.ENUM_ROLE_TYPE.consumerRole.value);
        }
        this.roleDao.save(role);
        for (int index = 0; index < funcIdsArr.length; ++index) {
            roleFunction = new TRoleFunction();
            roleFunction.setRoleId(role.getId());
            roleFunction.setFunctionId(Long.valueOf(Long.parseLong(funcIdsArr[index])));
            roleFunctionArray[index] = roleFunction;
        }
        this.roleFunctionDao.removeRoleFuncById(role.getId());
        this.roleFunctionDao.save(roleFunctionArray);
    }

    @Override
    public Boolean deleteRoleById(Long roleId) {
        Integer userRoleCount = this.userRoleDao.getUserCountByRoleId(roleId);
        if (userRoleCount == 0) {
            this.roleDao.removeById(roleId);
            this.roleFunctionDao.removeRoleFuncById(roleId);
            return true;
        }
        return false;
    }

    @Override
    public Pagination<TRole> queryAllRoles(TRole roleCondition, Integer pageNo, Integer pageSize, String sortName, String sortType) {
        return this.roleDao.queryAllRoles(roleCondition, pageNo, pageSize, sortName, sortType);
    }

    @Override
    public List<Function> queryAllFunctions() {
        return this.functionDao.queryAllFunctions();
    }

    @Override
    public TRole getRoleById(Long roleId) {
        return (TRole)this.roleDao.find(roleId);
    }

    @Override
    public List<TRoleFunction> queryRoleFunctionByRoleId(Long roleId) {
        return this.roleFunctionDao.queryRoleFunctionByRoleId(roleId);
    }

    @Override
    public List<TRole> queryListRoles() {
        return this.roleDao.findAll();
    }

    @Override
    public List<TUserRole> queryUserRoleListByUserId(Long userId) {
        return this.userRoleDao.queryUserRoleListByUserId(userId);
    }

    @Override
    public Boolean isRoleNameExist(String roleId, String roleName) {
        Search search = new Search(TRole.class);
        search.addFilterEqual("name", (Object)roleName);
        if (StringUtils.isNotBlank((CharSequence)roleId)) {
            search.addFilterNotEqual("id", (Object)roleId);
        }
        return this.roleDao.count((ISearch)search) > 0;
    }
}

