/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.system.dao;

import com.xdja.cssp.ams.system.condition.DicCondition;
import com.xdja.cssp.ams.system.entity.TDic;
import com.xdja.platform.datacenter.jpa.dao.BaseJdbcDao;
import com.xdja.platform.datacenter.jpa.page.Pagination;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class TDicJdbcDao
extends BaseJdbcDao {
    public Pagination<TDic> queryAllTopDics(DicCondition condition, int page, int length, String orderColName, String orderDir) {
        StringBuffer sqlBuffer = new StringBuffer(" SELECT t.n_id AS id,t.c_code AS code,t.c_name AS name,t.c_parent_code AS parentCode, ").append(" t.c_root_code AS rootCode,t.n_multi_level AS multiLevel,t.c_extend AS extend,t.c_note AS note ").append(" FROM t_dic t WHERE 1=1");
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        if (condition != null && StringUtils.isNotBlank((CharSequence)condition.getName())) {
            sqlBuffer.append(" AND t.c_name LIKE :name ESCAPE '/' ");
            String name = condition.getName();
            name = name.replaceAll("%", "/%");
            name = name.replaceAll("_", "/_");
            sqlParameterSource.addValue("name", (Object)("%" + name + "%"));
        }
        if (condition != null && StringUtils.isNotBlank((CharSequence)condition.getParentCode())) {
            sqlBuffer.append(" AND t.c_parent_code = :parentCode ");
            sqlParameterSource.addValue("parentCode", (Object)condition.getParentCode());
        }
        return this.queryForPage(sqlBuffer.toString(), length, page, sqlParameterSource, (RowMapper)new BeanPropertyRowMapper(TDic.class));
    }

    public int deleteSubListByCode(String code) {
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        sqlParameterSource.addValue("parentCode", (Object)code);
        return this.deleteBySql("DELETE FROM t_dic WHERE c_parent_code =:parentCode", (SqlParameterSource)sqlParameterSource);
    }
}

