/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ams.system.dao;

import com.xdja.cssp.ams.system.entity.TUser;
import com.xdja.platform.datacenter.jpa.dao.BaseJpaDao;
import com.xdja.platform.datacenter.jpa.page.Pagination;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class TUserDao
extends BaseJpaDao<TUser, Long> {
    public Integer isSysInit() {
        MapSqlParameterSource sqlParam = new MapSqlParameterSource();
        String sql = "SELECT COUNT(n_id) FROM t_user WHERE n_type = :type";
        sqlParam.addValue("type", (Object)TUser.ENUM_USER_TYPE.systemUser.value);
        return this.queryForInt(sql, (SqlParameterSource)sqlParam);
    }

    public int queryCardIsBind(String uName, String cardId) {
        StringBuilder sql = new StringBuilder("SELECT count(0) ");
        sql.append(" FROM t_user_cert cert");
        sql.append(" LEFT JOIN t_user user ON cert.n_user_id = user.n_id");
        sql.append(" WHERE user.c_user_name = :userName AND cert.c_card_id = :cardId");
        MapSqlParameterSource paramSource = new MapSqlParameterSource();
        paramSource.addValue("userName", (Object)uName);
        paramSource.addValue("cardId", (Object)cardId);
        return this.queryForInt(sql.toString(), (SqlParameterSource)paramSource);
    }

    public Pagination<TUser> queryAllUsers(TUser user, Integer pageNo, Integer pageSize, String sortName, String sortType) {
        MapSqlParameterSource sqlParameterSource = new MapSqlParameterSource();
        StringBuilder sqlBuilder = new StringBuilder("SELECT n_id AS id, c_user_name AS userName, ").append("c_name AS name, c_mobile AS mobile, n_status AS status, n_time AS createTime FROM t_user WHERE 1=1 ");
        if (null != user) {
            if (StringUtils.isNotBlank((CharSequence)user.getName())) {
                String name = user.getName();
                sqlBuilder.append("AND c_name like :name ESCAPE '/' ");
                name = name.replaceAll("%", "/%");
                name = name.replaceAll("_", "/_");
                sqlParameterSource.addValue("name", (Object)("%" + name + "%"));
            }
            if (StringUtils.isNotBlank((CharSequence)user.getUserName())) {
                String userName = user.getUserName();
                sqlBuilder.append("AND c_user_name like :userName ESCAPE '/' ");
                userName = userName.replaceAll("%", "/%");
                userName = userName.replaceAll("_", "/_");
                sqlParameterSource.addValue("userName", (Object)("%" + userName + "%"));
            }
        }
        sqlBuilder.append("AND n_delete_flag = :deleteFlag ");
        sqlParameterSource.addValue("deleteFlag", (Object)TUser.ENUM_DELETE_FLAG.normalFlag.value);
        sqlBuilder.append("AND n_type = :type ");
        sqlParameterSource.addValue("type", (Object)TUser.ENUM_USER_TYPE.consumerUser.value);
        if (StringUtils.isNotEmpty((CharSequence)sortName) && StringUtils.isNotEmpty((CharSequence)sortType)) {
            sqlBuilder.append("ORDER BY " + sortName + " " + sortType);
        } else {
            sqlBuilder.append("ORDER BY n_time DESC ");
        }
        return this.queryForPage(sqlBuilder.toString(), pageSize, pageNo, sqlParameterSource, (RowMapper)BeanPropertyRowMapper.newInstance(TUser.class));
    }
}

