/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.service.core.microservice;

import com.xdja.cssp.ams.assetmanager.utils.Constants;
import com.xdja.platform.common.lite.kit.StrKit;
import com.xdja.platform.common.lite.kit.prop.Prop;
import com.xdja.platform.common.lite.kit.prop.PropKit;
import com.xdja.platform.microservice.ServiceException;
import com.xdja.platform.microservice.config.MicroServiceConfig;
import com.xdja.platform.microservice.db.DataSourceProvider;
import com.xdja.platform.microservice.db.druid.DruidPlugin;
import com.xdja.platform.microservice.db.nutz.NutzDaoPlugin;
import com.xdja.platform.microservice.plugin.IPlugin;
import com.xdja.platform.microservice.plugin.Plugins;
import com.xdja.platform.microservice.spring.SpringPlugin;
import com.xdja.platform.rpc.consumer.IService;
import com.xdja.platform.rpc.consumer.Service;
import com.xdja.platform.rpc.consumer.ServicePool;
import com.xdja.platform.rpc.provider.ProviderStarter;
import com.xdja.platform.rpc.proxy.PagingConverter;
import com.xdja.sc.client.consumer.ReceivedAction;
import com.xdja.sc.client.core.MQSetting;
import java.net.BindException;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Config
extends MicroServiceConfig {
    private static Logger logger = LoggerFactory.getLogger(Config.class);
    public static final String IP = "127.0.0.1";
    public static final int PORT = 6666;
    public static final int MAXWORKTHREAD = 5000;
    public static final int CERTCAALG = 2;
    public static final int CERTTYPE = 1;
    public static final int KUEPLIMIT = 500;

    public void configPlugin(Plugins plugins) {
        Prop prop = PropKit.use((String)"system.properties");
        String amsUrl = prop.get("jdbc.url");
        if (StrKit.isBlank((String)amsUrl)) {
            throw ServiceException.create((String)"\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6system.properties\u4e2d\u6dfb\u52a0jdbc.url\u7684\u914d\u7f6e", null);
        }
        String amsUserName = prop.get("jdbc.username");
        if (StrKit.isBlank((String)amsUserName)) {
            throw ServiceException.create((String)"\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6system.properties\u4e2d\u6dfb\u52a0jdbc.username\u7684\u914d\u7f6e", null);
        }
        String amsPassword = prop.get("jdbc.password");
        DruidPlugin amsdbPlugin = new DruidPlugin(amsUrl, amsUserName, amsPassword);
        plugins.add((IPlugin)amsdbPlugin);
        NutzDaoPlugin daoPlugin = new NutzDaoPlugin("db::ams", (DataSourceProvider)amsdbPlugin);
        if (!prop.getBoolean("jdbc.debug", Boolean.valueOf(true)).booleanValue()) {
            daoPlugin.disableDebug();
        }
        plugins.add((IPlugin)daoPlugin);
        String tpomsUrl = prop.get("tpoms.jdbc.url");
        if (StrKit.isBlank((String)tpomsUrl)) {
            throw ServiceException.create((String)"\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6system.properties\u4e2d\u6dfb\u52a0tpoms.jdbc.url\u7684\u914d\u7f6e", null);
        }
        String tpomsUserName = prop.get("tpoms.jdbc.username");
        if (StrKit.isBlank((String)tpomsUserName)) {
            throw ServiceException.create((String)"\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6system.properties\u4e2d\u6dfb\u52a0tpoms.jdbc.username\u7684\u914d\u7f6e", null);
        }
        String tpomsPassword = prop.get("tpoms.jdbc.password");
        DruidPlugin tpomsdbPlugin = new DruidPlugin(tpomsUrl, tpomsUserName, tpomsPassword);
        plugins.add((IPlugin)tpomsdbPlugin);
        NutzDaoPlugin tpomsPlugin = new NutzDaoPlugin("db::tpoms", (DataSourceProvider)tpomsdbPlugin);
        if (!prop.getBoolean("tpoms.jdbc.debug", Boolean.valueOf(true)).booleanValue()) {
            daoPlugin.disableDebug();
        }
        plugins.add((IPlugin)tpomsPlugin);
        String[] configLocations = new String[]{"classpath*:/META-INF/spring/applicationContext-*.xml", "classpath*:/applicationContext.xml"};
        plugins.add((IPlugin)new SpringPlugin(configLocations));
    }

    public void afterStart() {
        String[] services;
        Prop prop = PropKit.use((String)"system.properties");
        Service rpcService = null;
        for (String service : services = StringUtils.split((String)prop.get("rpc.services"), (String)"|")) {
            rpcService = new Service();
            rpcService.setAddr(prop.get("rpc." + service + ".ip"));
            rpcService.setPort(prop.getInt("rpc." + service + ".port").intValue());
            rpcService.setTimeoutMillis((long)prop.getInt("rpc." + service + ".timeoutMillis").intValue());
            ServicePool.addService((String)service, (IService)rpcService);
            logger.info("\u6ce8\u518crpc service\uff08{}==>{}:{}\uff09\u6210\u529f", new Object[]{service, rpcService.getAddr(), rpcService.getPort()});
        }
        try {
            Config.initScConfig();
            logger.info("\u8ba2\u9605\u4e2d\u5fc3\u670d\u52a1\uff1aRMq\u542f\u52a8\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316sc\u51fa\u9519,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u548c\u7f51\u7edc\uff01", (Throwable)e);
            throw ServiceException.create((String)"\u521d\u59cb\u5316sc\u51fa\u9519,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u548c\u7f51\u7edc\uff01", null);
        }
        this.initConfigProperties();
        PagingConverter.pageNoMethodName = "getPageNo";
        PagingConverter.pageSizeMethodName = "getPageSize";
        PagingConverter.totalCountMethodName = "getTotalCount";
        PagingConverter.totalPageMethodName = "getTotalPage";
        PagingConverter.dataListMethodName = "getList";
        String ip = prop.get("rpc.ip", "127.0.0.1");
        int port = prop.getInt("rpc.port", Integer.valueOf(6666));
        int maxWorkThread = prop.getInt("rpc.maxWorkThread", Integer.valueOf(5000));
        try {
            ProviderStarter.NETTY.setMaxWorkThread(maxWorkThread).start(ip, port);
            logger.info("=================>AMS\u670d\u52a1\u542f\u52a8\u6210\u529f\uff01\u670d\u52a1\u5730\u5740:{}:{},\u6700\u5927\u5de5\u4f5c\u7ebf\u7a0b\u6570{}", new Object[]{ip, port, maxWorkThread});
        }
        catch (BindException e) {
            logger.error("\u670d\u52a1\u7ed1\u5b9a\u5f02\u5e38", (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error("\u7ebf\u7a0b\u5f02\u5e38", (Throwable)e);
        }
    }

    private static void initScConfig() throws Exception {
        Prop prop = PropKit.use((String)"system.properties");
        String username = prop.get("mq.uname");
        String password = prop.get("mq.pwd");
        String url = prop.get("mq.urls");
        String appFlag = prop.get("mq.app");
        logger.info("\u8ba2\u9605\u4e2d\u5fc3\u670d\u52a1\uff1aRMq\u5f00\u59cb\u542f\u52a8,\u8fde\u63a5\u5730\u5740\uff1a{},app:{}", (Object)url, (Object)appFlag);
        MQSetting.setThreadSize((int)5);
        MQSetting.init((String)username, (String)password, (String)url, (String)appFlag);
        MQSetting.initChanel(Arrays.asList("updateBackupCardStatus"));
        MQSetting.registAction((ReceivedAction)new /* Unavailable Anonymous Inner Class!! */, (boolean)true);
    }

    private void initConfigProperties() {
        Prop prop = PropKit.use((String)"config.properties");
        if (StringUtils.isBlank((CharSequence)prop.get("chipOrderType")) || StringUtils.isBlank((CharSequence)prop.get("chipOrderLength")) || prop.get("chipOrderType").split(",").length != prop.get("chipOrderLength").split(",").length) {
            throw ServiceException.create((String)"\u521d\u59cb\u5316\u82af\u7247\u7c7b\u578b\u5931\u8d25,\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\uff01", null);
        }
        String[] chipOrderTypeArr = prop.get("chipOrderType").split(",");
        String[] chipOrderLengthArr = prop.get("chipOrderLength").split(",");
        for (int i = 0; i < chipOrderTypeArr.length; ++i) {
            Constants.CUSTOMER_ORDER_TYPE.put(chipOrderTypeArr[i].toUpperCase(), Integer.valueOf(chipOrderLengthArr[i]));
        }
        String[] U8OrderType = prop.get("u8.order.activeType").split(",");
        for (int j = 0; j < U8OrderType.length; ++j) {
            Constants.U8_ORDER_ACTIVETYPE.put(U8OrderType[j], j + 1);
        }
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

