/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.as.api;

import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;

/*
 * Exception performing whole class analysis ignored.
 */
public class Constants {
    public static final String IP = "127.0.0.1";
    public static final int PORT = 6666;
    public static final long TIMEOUTMILLIS = 5000L;
    public static final long HTTP_INTERVAL_TIMEOUT = 300000L;
    public static final String DEFAULT_HOST_ID = "SERVER";
    public static String HOST_ID;
    public static long TIMEOUT;
    public static final Map<Integer, String> CLIENT_TYPES;
    public static final Map<Integer, String> LOGIN_TYPES;
    public static final String HTTP_HEADER_SIGN_METHOD_RSA = "SHA1WithRSA";
    public static final String HTTP_HEADER_SIGN_METHOD_SM2 = "SM3WithSM2";
    public static final String HEADER_NAME_START = "x-at-";
    public static final String VERSION_HEADER_NAME = "x-at-version";
    public static final String SIGNATURE_SN_HEADER_NAME = "x-at-signature-sn";
    public static final String SIGNATURE_DN_HEADER_NAME = "x-at-signature-dn";
    public static final String SIGNATURE_METHOD_HEADER_NAME = "x-at-signature-method";
    public static final String TIMESTAMP_HEADER_NAME = "x-at-timestamp";
    public static final String SIGNATURE_VERSION_HEADER_NAME = "x-at-signature-version";
    public static final String SIGNATURE_NONCE_HEADER_NAME = "x-at-signature-nonce";
    public static String AUTHORIZATION_HEADER_NAME;

    public static Date parseTimestamp(String timestamp) throws ParseException {
        String formatTimestamp = timestamp.substring(0, 10) + " " + timestamp.substring(11, 19);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.parse(formatTimestamp);
    }

    public static String generateCanonicalizeRequest(String method, String uri, List<Header> headers, String requestBody) throws UnsupportedEncodingException {
        String canonicalizeUri = Constants.canonicalizeUri((String)uri);
        String canonicalizeHeaders = Constants.canonicalizeHeaders(headers);
        String canonicalizeRequest = Constants.canonicalizeRequest((String)method, (String)canonicalizeUri, (String)canonicalizeHeaders, (String)requestBody);
        return canonicalizeRequest;
    }

    private static String canonicalizeUri(String uri) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        byte[] bytes = uri.getBytes("utf-8");
        for (int i = 0; i < bytes.length; ++i) {
            byte[] tmp;
            if (bytes[i] >= 65 && bytes[i] <= 90 || bytes[i] >= 97 && bytes[i] <= 122 || bytes[i] >= 48 && bytes[i] <= 57 || bytes[i] == 95 || bytes[i] == 45 || bytes[i] == 126 || bytes[i] == 46) {
                tmp = new byte[]{bytes[i]};
                result.append(new String(tmp, "utf-8"));
                continue;
            }
            tmp = new byte[]{bytes[i]};
            result.append('%' + Constants.byte2hex((byte[])tmp).toUpperCase());
        }
        return result.toString();
    }

    private static String byte2hex(byte[] bytes) {
        String hs = "";
        String stmp = "";
        for (int n = 0; n < bytes.length; ++n) {
            stmp = Integer.toHexString(bytes[n] & 0xFF);
            hs = stmp.length() == 1 ? hs + "0" + stmp : hs + stmp;
        }
        return hs;
    }

    private static String canonicalizeHeaders(List<Header> headers) {
        String canonicalHeaders = "";
        if (headers != null) {
            for (Header header : headers) {
                canonicalHeaders = canonicalHeaders + header.getName().toLowerCase().trim() + ":" + header.getValue().trim() + "\n";
            }
        }
        if ("" == canonicalHeaders) {
            canonicalHeaders = canonicalHeaders + "\n";
        }
        return canonicalHeaders;
    }

    private static String canonicalizeRequest(String method, String canonicalizeUri, String canonicalizeHeaders, String requestBody) {
        String canonicalizeRequest = method.toUpperCase() + "\n" + canonicalizeUri + "\n" + canonicalizeHeaders + requestBody;
        return canonicalizeRequest;
    }

    static {
        CLIENT_TYPES = new HashMap();
        LOGIN_TYPES = new HashMap();
        CLIENT_TYPES.put(1, "Android");
        CLIENT_TYPES.put(2, "IOS");
        CLIENT_TYPES.put(3, "PC");
        CLIENT_TYPES.put(4, "\u5176\u4ed6");
        LOGIN_TYPES.put(1, "\u82af\u7247");
        LOGIN_TYPES.put(2, "TF\u5361");
        LOGIN_TYPES.put(3, "USBKey");
        AUTHORIZATION_HEADER_NAME = "Authorization";
    }
}

