/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.as.api.init;

import com.xdja.cssp.as.api.Constants;
import com.xdja.platform.common.lite.kit.prop.Prop;
import com.xdja.platform.common.lite.kit.prop.PropKit;
import com.xdja.platform.rpc.consumer.Service;
import com.xdja.platform.rpc.consumer.ServicePool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class SystemInit
implements InitializingBean {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void afterPropertiesSet() throws Exception {
        this.logger.info("\u5f00\u59cb\u6ce8\u518c\u7edf\u4e00\u8ba4\u8bc1RPC\u670d\u52a1");
        Prop consumerProp = PropKit.use((String)"consumer.properties");
        String ip = consumerProp.get("asServiceIp", "127.0.0.1");
        int port = consumerProp.getInt("asServicePort", Integer.valueOf(6666));
        long timeoutMillis = consumerProp.getLong("asTimeoutMillis", Long.valueOf(5000L));
        Service contactService = new Service();
        contactService.setAddr(ip);
        contactService.setPort(port);
        contactService.setTimeoutMillis(timeoutMillis);
        ServicePool.addService((String)"as", (Service)contactService);
        this.logger.info("\u6ce8\u518c\u6ce8\u518c\u7edf\u4e00\u8ba4\u8bc1RPC\u670d\u52a1\uff08{}==>{}:{}\uff09\u6210\u529f", new Object[]{"as", ip, port});
        Prop serviceConfig = PropKit.use((String)"serviceConfig.properties");
        Constants.TIMEOUT = serviceConfig.getLong("request_timeout", Long.valueOf(300000L));
        Constants.HOST_ID = serviceConfig.get("hostId", "SERVER");
        this.logger.info("\u52a0\u8f7d\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6\u5b8c\u6210");
    }
}

