/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.as.api.interceptor;

import com.xdja.cssp.as.api.Constants;
import com.xdja.cssp.as.api.interceptor.cache.SignatureNonce;
import com.xdja.cssp.as.api.interceptor.model.Request;
import com.xdja.cssp.as.api.interceptor.sort.ComparatorHeader;
import com.xdja.cssp.as.api.util.Base64Util;
import com.xdja.cssp.as.api.util.ByteUtils;
import com.xdja.cssp.as.api.util.CertUtil;
import com.xdja.cssp.as.api.util.SignUtils;
import com.xdja.cssp.as.service.ILoginService;
import com.xdja.cssp.as.service.model.Cert;
import com.xdja.cssp.restful.auth.exception.DuplicateRequestException;
import com.xdja.cssp.restful.auth.exception.InvalidDateException;
import com.xdja.cssp.restful.auth.exception.InvalidSnException;
import com.xdja.cssp.restful.auth.exception.NotMatchSignatureException;
import com.xdja.cssp.restful.auth.exception.NotSupportSignAlgoException;
import com.xdja.cssp.restful.auth.exception.RequestTimeoutException;
import com.xdja.cssp.restful.auth.exception.VerifySignatureException;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import java.io.InputStream;
import java.security.PublicKey;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.UUID;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.message.BasicHeader;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class AuthClientInterceptor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ILoginService service = (ILoginService)DefaultServiceRefer.getServiceRefer(ILoginService.class);
    private String hostId = Constants.HOST_ID;

    @Before(value="execution(public * com.xdja.cssp.as.api.AsApi.*Login(..))")
    public void authClient() {
        Cert cert;
        this.logger.debug("\u5f00\u59cb\u9a8c\u8bc1\u5ba2\u6237\u7aef\u8eab\u4efd");
        HttpServletRequest httpRequest = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        Request request = new Request();
        String requestId = this.genRequestId();
        request.setId(requestId);
        String timestamp = httpRequest.getHeader("x-at-timestamp");
        try {
            Date date = Constants.parseTimestamp((String)timestamp);
            long minusTime = System.currentTimeMillis() - date.getTime();
            if (minusTime > Constants.TIMEOUT) {
                throw new RequestTimeoutException(this.hostId, requestId, "request_timeout", "\u8bf7\u6c42\u65f6\u95f4\u6233\u8d85\u65f6(\u53ef\u80fd\u7531\u4e8e\u5ba2\u6237\u7aef\u65f6\u95f4\u4e0d\u6b63\u786e\u5bfc\u81f4\uff0c\u8bf7\u5148\u6821\u51c6\u5ba2\u6237\u7aef\u65f6\u95f4)");
            }
        }
        catch (ParseException e) {
            this.logger.error("\u65e0\u6548\u7684\u8bf7\u6c42\u65f6\u95f4\u6233", (Throwable)e);
            throw new InvalidDateException(this.hostId, requestId, "invalid_date", "\u65e0\u6548\u7684\u65f6\u95f4", (Throwable)e);
        }
        String signatureNonce = httpRequest.getHeader("x-at-signature-nonce");
        if (SignatureNonce.signatureNonce.equals(signatureNonce)) {
            throw new DuplicateRequestException(this.hostId, requestId, "duplicate_request", "\u91cd\u590d\u7684\u8bf7\u6c42");
        }
        SignatureNonce.signatureNonce = signatureNonce;
        String signatureMethod = httpRequest.getHeader("x-at-signature-method");
        if (!signatureMethod.equals("SHA1WithRSA") && !signatureMethod.equals("SM3WithSM2")) {
            throw new NotSupportSignAlgoException(this.hostId, requestId, "not_support_sign_algo", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
        }
        request.setSignatureAlgo(signatureMethod);
        String signatureSn = httpRequest.getHeader("x-at-signature-sn");
        int caAlg = signatureMethod.equals("SM3WithSM2") ? 2 : 1;
        try {
            cert = this.service.queryCert(signatureSn, caAlg);
        }
        catch (IllegalArgumentException e) {
            this.logger.error("\u5ba2\u6237\u7aef\u7b7e\u540d\u8bc1\u4e66SN\u4e3a\u7a7a");
            throw new InvalidSnException(this.hostId, requestId, "invalid_sn", "\u65e0\u6548\u7684\u8bc1\u4e66sn");
        }
        if (null == cert) {
            throw new InvalidSnException(this.hostId, requestId, "invalid_sn", "\u65e0\u6548\u7684\u8bc1\u4e66sn");
        }
        request.setCardNo(cert.getCardNo());
        String method = httpRequest.getMethod();
        String uri = httpRequest.getServletPath();
        request.setMethod(method);
        request.setUri(uri);
        httpRequest.setAttribute("request", (Object)request);
        ArrayList<BasicHeader> list = new ArrayList<BasicHeader>();
        Enumeration headers = httpRequest.getHeaderNames();
        while (headers.hasMoreElements()) {
            String headerName = (String)headers.nextElement();
            if (!headerName.startsWith("x-at-")) continue;
            list.add(new BasicHeader(headerName, httpRequest.getHeader(headerName)));
        }
        ComparatorHeader comparatorHeader = new ComparatorHeader();
        Collections.sort(list, comparatorHeader);
        boolean flag = false;
        try {
            ServletInputStream in = httpRequest.getInputStream();
            byte[] contentIn = ByteUtils.inputStreamToBytes((InputStream)in);
            String requestBody = new String(contentIn, "UTF-8");
            String canonicalizeRequest = Constants.generateCanonicalizeRequest((String)method, (String)uri, list, (String)requestBody);
            String certBase64 = cert.getCert();
            PublicKey publicKey = CertUtil.getCertFromStr((String)certBase64).getPublicKey();
            flag = SignUtils.verifySignature((String)signatureMethod, (PublicKey)publicKey, (byte[])canonicalizeRequest.getBytes("UTF-8"), (byte[])Base64Util.getByteByBase64((String)httpRequest.getHeader(Constants.AUTHORIZATION_HEADER_NAME)));
        }
        catch (Exception e) {
            this.logger.error("\u9a8c\u8bc1\u8bf7\u6c42\u7b7e\u540d\u5f02\u5e38", (Throwable)e);
            throw new VerifySignatureException(this.hostId, requestId, "verify_signature_error", "\u9a8c\u8bc1\u8bf7\u6c42\u7b7e\u540d\u5f02\u5e38", (Throwable)e);
        }
        if (!flag) {
            throw new NotMatchSignatureException(this.hostId, requestId, "not_match_signature", "\u9a8c\u8bc1\u8bf7\u6c42\u7b7e\u540d\u4e0d\u5339\u914d");
        }
        this.logger.debug("\u9a8c\u8bc1\u5ba2\u6237\u7aef\u8eab\u4efd\u901a\u8fc7");
    }

    private String genRequestId() {
        return UUID.randomUUID().toString();
    }
}

