/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.as.api.util;

import com.xdja.sm2.cipher.Base64Util;
import com.xdja.sm2.cipher.SM2CipherImpl;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import org.bouncycastle.asn1.sm2.SM2ObjectIdentifiers;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

/*
 * Exception performing whole class analysis ignored.
 */
public class SM2Utils {
    public static byte[] encrypt(ECPublicKey publicKey, byte[] plainText) {
        if (publicKey == null || plainText == null || plainText.length <= 0) {
            throw new IllegalArgumentException("param error: publicKey,plainText can not be null");
        }
        byte[] cipherText = null;
        byte[] pubkeydata = new byte[65];
        pubkeydata[0] = 4;
        byte[] xbyte = publicKey.getW().getAffineX().toByteArray();
        byte[] ybyte = publicKey.getW().getAffineY().toByteArray();
        System.arraycopy(xbyte, xbyte.length > 32 ? 1 : 0, pubkeydata, 1, 32);
        System.arraycopy(ybyte, ybyte.length > 32 ? 1 : 0, pubkeydata, 33, 32);
        SM2CipherImpl cipher = new SM2CipherImpl();
        String base64key = new String(Base64Util.encode((byte[])pubkeydata));
        cipherText = cipher.encrypt_gb(base64key, plainText);
        return cipherText;
    }

    public static byte[] encrypt(X509Certificate certificate, byte[] plainText) {
        if (certificate == null || plainText == null || plainText.length <= 0) {
            throw new IllegalArgumentException("param error: certificate,plainText can not be null");
        }
        byte[] cipherText = null;
        byte[] pubkeydata = new byte[65];
        ECPublicKey publicKey = (ECPublicKey)certificate.getPublicKey();
        pubkeydata[0] = 4;
        byte[] xbyte = publicKey.getW().getAffineX().toByteArray();
        byte[] ybyte = publicKey.getW().getAffineY().toByteArray();
        System.arraycopy(xbyte, xbyte.length > 32 ? 1 : 0, pubkeydata, 1, 32);
        System.arraycopy(ybyte, ybyte.length > 32 ? 1 : 0, pubkeydata, 33, 32);
        SM2CipherImpl cipher = new SM2CipherImpl();
        String base64key = new String(Base64Util.encode((byte[])pubkeydata));
        cipherText = cipher.encrypt_gb(base64key, plainText);
        return cipherText;
    }

    public static byte[] decrypt(ECPrivateKey privateKey, byte[] cipherText) {
        byte[] temp;
        if (privateKey == null || cipherText == null || cipherText.length <= 0) {
            throw new IllegalArgumentException("param error: privateKey,cipherText can not be null");
        }
        byte[] plainText = null;
        byte[] prikeydata = new byte[32];
        System.arraycopy(temp, (temp = privateKey.getS().toByteArray()).length > 32 ? 1 : 0, prikeydata, 0, 32);
        SM2CipherImpl cipher = new SM2CipherImpl();
        String base64key = new String(Base64Util.encode((byte[])prikeydata));
        plainText = cipher.decrypt_gb(base64key, cipherText);
        return plainText;
    }

    public static byte[] sign(ECPrivateKey privateKey, byte[] original) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        if (privateKey == null || original == null || original.length <= 0) {
            throw new IllegalArgumentException("param error: privateKey,original can not be null");
        }
        byte[] signData = null;
        Signature signature = Signature.getInstance(SM2ObjectIdentifiers.sm2SignWithSm3.getId(), "BC");
        signature.initSign(privateKey);
        signature.update(original);
        signData = signature.sign();
        return signData;
    }

    public static boolean verify(ECPublicKey publicKey, byte[] sign, byte[] original) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        if (publicKey == null || original == null || sign == null || original.length <= 0 || sign.length <= 0) {
            throw new IllegalArgumentException("param error: publicKey,sign,original can not be null");
        }
        boolean flag = false;
        Signature signature = Signature.getInstance(SM2ObjectIdentifiers.sm2SignWithSm3.getId(), "BC");
        signature.initVerify(publicKey);
        signature.update(original);
        flag = signature.verify(sign);
        return flag;
    }

    public static boolean verify(X509Certificate certificate, byte[] sign, byte[] original) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        if (certificate == null || original == null || sign == null || original.length <= 0 || sign.length <= 0) {
            throw new IllegalArgumentException("param error: certificate,sign,original can not be null");
        }
        boolean flag = false;
        Signature signature = Signature.getInstance(SM2ObjectIdentifiers.sm2SignWithSm3.getId(), "BC");
        signature.initVerify(certificate);
        signature.update(original);
        flag = signature.verify(sign);
        return flag;
    }

    public static void main(String[] args) {
        try {
            KeyPairGenerator pair = KeyPairGenerator.getInstance("ECSM2", "BC");
            pair.initialize(new ECGenParameterSpec(SM2ObjectIdentifiers.sm2256.getId()), new SecureRandom());
            KeyPair keyPair = pair.generateKeyPair();
            ECPrivateKey privateKey = (ECPrivateKey)keyPair.getPrivate();
            System.out.println(privateKey);
            System.out.println(privateKey.getEncoded().length);
            ECPublicKey publicKey = (ECPublicKey)keyPair.getPublic();
            System.out.println(publicKey);
            System.out.println(publicKey.getEncoded().length);
            System.out.println(new String(Base64Util.encode((byte[])publicKey.getEncoded())).length());
            System.out.println(new String(Base64Util.encode((byte[])publicKey.getEncoded())));
            String plainText = "hello1ss11";
            byte[] cipherText = SM2Utils.encrypt((ECPublicKey)publicKey, (byte[])plainText.getBytes());
            System.out.println("size: " + cipherText.length + "  " + new String(SM2Utils.decrypt((ECPrivateKey)privateKey, (byte[])cipherText)));
            byte[] sign = SM2Utils.sign((ECPrivateKey)privateKey, (byte[])plainText.getBytes());
            System.out.println("size: " + sign.length + " " + SM2Utils.verify((ECPublicKey)publicKey, (byte[])sign, (byte[])plainText.getBytes()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

