package com.xdja.cssp.as.service;

import java.util.List;

import com.xdja.cssp.as.service.model.ResultBean;
import com.xdja.platform.rpc.RemoteService;

/**
 * ticket认证服务相关接口
 * @author wyf
 *
 */
@RemoteService(serviceCode = AS.SERVICE_CODE)
public interface ITicketService {
	
	/**
	 * Ticket认证
	 * @param ticket 用户凭证
	 * @return 执行结果，1-有效；2-无效
	 */
	ResultBean verifyTicket(String ticket);
	
	/**
	 * 批量查询账户PN标识
	 * @param accounts 账号列表
	 * @return 在线PN标识列表
	 */
	List<String> queryPnTokens(List<String> accounts);
	
}
