package com.xdja.cssp.as.service.model;

/**
 * 设备类型
 * @author wyf
 *
 */
public enum Category {
	
	/**
	 * 手机
	 */
	MOBILE(1),
	/**
	 * 平板
	 */
	PAD(2),
	/**
	 * PC
	 */
	PC(3),
	/**
	 * 其他
	 */
	OTHER(4);
	
	public int value;
	
	private Category(int value) {
		this.value = value;
	}
	
	/**
	 * 转换设备类型
	 * @param value
	 * @return
	 */
	public static Category valueOf(int value) {
		for (Category item : Category.values()) {
			if (item.value == value) {
				return item;
			}
		}
		
		throw new IllegalArgumentException(String.format("值\"%d\"对应的枚举值不存在", value));
	}

}
