package com.xdja.cssp.as.service.model;

import java.io.Serializable;

/**
 * 用户登录记录
 * @author wyf
 *
 */
public class LoginRecord implements Serializable {

	private static final long serialVersionUID = -1493427078782723567L;
	
	/**
	 * 身份凭证
	 */
	private String ticket;
	/**
	 * ticket有效期
	 */
	private long ticketPeriod;
	/**
	 * 账户
	 */
	private String account;
	/**
	 * 安全卡号
	 */
	private String cardNo;
	/**
	 * 安全卡序列号
	 */
	private String cardSn;
	/**
	 * 终端标识号
	 */
	private String terminalCode;
	/**
	 * 推送标识
	 */
	private String pnCode;
	/**
	 * 客户端类型，1-android；2-ios；3-PC，4-其他<br />
	 * <b>说明：单客户端登录接口 该属性适用以上含义描述；<br />
	 * 		多客户端登录、多类型客户端综合登录接口该属性适用以下描述;<br />
	 * 		客户端类型；1-手机，2-平板；3-PC，4-其他</b>
	 */
	private int clientType;
	/**
	 * 登录类型，1-芯片登录；2-TF卡登录；3-USBKey
	 */
	private int loginType;
	/**
	 * 客户端型号
	 */
	private String clientModel;
	/**
	 * 客户端操作系统名称<br />
	 * <b>说明：单客户端登录接口 为系统名称字符串<br />
	 * 		多客户端登录、多类型客户端综合登录接口该属性适用以下描述;<br />
	 * 		客户端类型；1-Android，2-IOS，3-Windows，4-MAC，5-其他</b>
	 */
	private String osName;
	/**
	 * 客户端操作系统版本号
	 */
	private String osVersion;
	/**
	 * 安通+客户端版本号
	 */
	private String clientVersion;
	/**
	 * ticket类型，1-单客户端；2-多客户端
	 */
	private int type;
	/**
	 * 登录设备序列号或SN
	 */
	private String terminalIdentify;

	public String getTicket() {
		return ticket;
	}

	public void setTicket(String ticket) {
		this.ticket = ticket;
	}

	public long getTicketPeriod() {
		return ticketPeriod;
	}

	public void setTicketPeriod(long ticketPeriod) {
		this.ticketPeriod = ticketPeriod;
	}

	public String getAccount() {
		return account;
	}

	public void setAccount(String account) {
		this.account = account;
	}

	public String getCardNo() {
		return cardNo;
	}

	public void setCardNo(String cardNo) {
		this.cardNo = cardNo;
	}

	public String getCardSn() {
		return cardSn;
	}

	public void setCardSn(String cardSn) {
		this.cardSn = cardSn;
	}

	public String getTerminalCode() {
		return terminalCode;
	}

	public void setTerminalCode(String terminalCode) {
		this.terminalCode = terminalCode;
	}

	public String getPnCode() {
		return pnCode;
	}

	public void setPnCode(String pnCode) {
		this.pnCode = pnCode;
	}

	public int getClientType() {
		return clientType;
	}

	public void setClientType(int clientType) {
		this.clientType = clientType;
	}

	public int getLoginType() {
		return loginType;
	}

	public void setLoginType(int loginType) {
		this.loginType = loginType;
	}

	public String getClientModel() {
		return clientModel;
	}

	public void setClientModel(String clientModel) {
		this.clientModel = clientModel;
	}

	public String getOsName() {
		return osName;
	}

	public void setOsName(String osName) {
		this.osName = osName;
	}

	public String getOsVersion() {
		return osVersion;
	}

	public void setOsVersion(String osVersion) {
		this.osVersion = osVersion;
	}

	public String getClientVersion() {
		return clientVersion;
	}

	public void setClientVersion(String clientVersion) {
		this.clientVersion = clientVersion;
	}

	public int getType() {
		return type;
	}

	public void setType(int type) {
		this.type = type;
	}

	public String getTerminalIdentify() {
		return terminalIdentify;
	}

	public void setTerminalIdentify(String terminalIdentify) {
		this.terminalIdentify = terminalIdentify;
	}

}
