/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.as.ticket;

import com.xdja.cssp.as.service.ITicketService;
import com.xdja.cssp.as.service.model.ResultBean;
import com.xdja.cssp.as.ticket.AsBean;
import com.xdja.cssp.as.ticket.annotation.CheckTicket;
import com.xdja.cssp.restful.exception.BadRequestException;
import com.xdja.cssp.restful.exception.TicketNotAuthException;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class VerifyTicketAspect {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ITicketService service = (ITicketService)DefaultServiceRefer.getServiceRefer(ITicketService.class);
    public static final String TICKET_KEY = "ticket";

    @Around(value="@annotation(checkTicket)")
    public Object verifyTicket(ProceedingJoinPoint jp, CheckTicket checkTicket) throws Throwable {
        String hostId;
        AsBean asBean;
        HttpServletRequest httpRequest;
        block12: {
            this.logger.debug("\u5f00\u59cbticket\u6709\u6548\u6027\u9a8c\u8bc1");
            httpRequest = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            asBean = new AsBean();
            hostId = "\u672a\u8bbe\u7f6e\u670d\u52a1\u6807\u8bc6";
            Method method = ClassUtils.getMethodIfAvailable(jp.getTarget().getClass(), (String)"getHostId", (Class[])new Class[0]);
            if (null != method) {
                try {
                    Object result = method.invoke(jp.getTarget(), new Object[0]);
                    if (null != result) {
                        hostId = result.toString();
                        this.logger.debug("\u670d\u52a1\u5668\u6807\u8bc6\uff1a{}", (Object)hostId);
                        break block12;
                    }
                    this.logger.warn("{}\u4e2d\u7684\u65b9\u6cd5\uff1apublic String getHostId(){}\u672a\u8fd4\u56de\u670d\u52a1\u6807\u8bc6", jp.getTarget().getClass());
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    this.logger.error("\u4ece{}\u4e2d\u83b7\u53d6\u670d\u52a1\u6807\u8bc6\u5931\u8d25", jp.getTarget().getClass(), (Object)e);
                }
            } else {
                this.logger.warn("\u8bf7\u5728{}\u4e2d\u6dfb\u52a0\u65b9\u6cd5\uff1apublic String getHostId(){}\u8fd4\u56de\u670d\u52a1\u6807\u8bc6", jp.getTarget().getClass());
            }
        }
        asBean.setHostId(hostId);
        String requestId = this.genRequestId();
        asBean.setRequestId(requestId);
        String ticket = httpRequest.getHeader(TICKET_KEY);
        if (StringUtils.isBlank((CharSequence)ticket)) {
            throw new TicketNotAuthException(hostId, requestId, "request_params_not_valid", "ticket\u4e3a\u7a7a");
        }
        try {
            ResultBean resultBean = this.service.verifyTicket(ticket);
            if (resultBean.getResultStatus() != 1) {
                throw new TicketNotAuthException(hostId, requestId, "not_authorized", "ticket\u9a8c\u8bc1\u672a\u901a\u8fc7");
            }
            Map accountInfo = (Map)resultBean.getInfo();
            asBean.setAccount((String)accountInfo.get("account"));
            asBean.setCardNo((String)accountInfo.get("cardNo"));
            asBean.setTicketPeriod((Long)accountInfo.get("ticketPeriod"));
            this.logger.debug("ticket\u6709\u6548\u6027\u9a8c\u8bc1\u5b8c\u6210");
        }
        catch (IllegalArgumentException e) {
            this.logger.error("\u9a8c\u8bc1ticket\u65f6\u53c2\u6570\u975e\u6cd5", (Throwable)e);
            throw new BadRequestException(hostId, requestId, "request_params_not_valid", "ticket\u4e3a\u7a7a");
        }
        catch (Exception e) {
            if (e instanceof TicketNotAuthException) {
                throw (TicketNotAuthException)e;
            }
            this.logger.error("\u9a8c\u8bc1ticket\u5931\u8d25", (Throwable)e);
            throw new BadRequestException(hostId, requestId, "internal_server_error", "\u670d\u52a1\u5668\u5185\u90e8\u5f02\u5e38");
        }
        Object[] args = jp.getArgs();
        Object arg = null;
        for (int i = 0; i < args.length; ++i) {
            arg = args[i];
            if (null == arg || arg.getClass() != AsBean.class) continue;
            args[i] = asBean;
            break;
        }
        return jp.proceed(args);
    }

    private String genRequestId() {
        return UUID.randomUUID().toString();
    }
}

