/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.base;

import com.rabbitmq.client.Channel;
import com.xdja.cssp.acs.IAssetService;
import com.xdja.cssp.acs.bean.asset.ProductAsset;
import com.xdja.cssp.ras.cache.AccountCache;
import com.xdja.cssp.ras.service.Constant;
import com.xdja.cssp.ums.service.Constants;
import com.xdja.cssp.ums.service.callback.CallbackFactory;
import com.xdja.cssp.ums.service.init.InitMdmCache;
import com.xdja.cssp.ums.service.init.InitUserInfoCache;
import com.xdja.log.analysis.format.sdk.log.LogSetting;
import com.xdja.platform.common.lite.kit.StrKit;
import com.xdja.platform.common.lite.kit.prop.Prop;
import com.xdja.platform.common.lite.kit.prop.PropKit;
import com.xdja.platform.microservice.ServiceException;
import com.xdja.platform.microservice.config.MicroServiceConfig;
import com.xdja.platform.microservice.db.DataSourceProvider;
import com.xdja.platform.microservice.db.DbUtilsPlugin;
import com.xdja.platform.microservice.db.druid.DruidPlugin;
import com.xdja.platform.microservice.plugin.IPlugin;
import com.xdja.platform.microservice.plugin.Plugins;
import com.xdja.platform.microservice.spring.SpringPlugin;
import com.xdja.platform.rpc.consumer.IService;
import com.xdja.platform.rpc.consumer.Service;
import com.xdja.platform.rpc.consumer.ServicePool;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import com.xdja.platform.rpc.provider.ProviderStarter;
import com.xdja.sc.client.consumer.ReceivedAction;
import com.xdja.sc.client.core.MQSetting;
import com.xdja.sc.model.Msg;
import java.io.IOException;
import java.net.BindException;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config
extends MicroServiceConfig {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Prop systemProp;

    public void configPlugin(Plugins me) {
        this.systemProp = PropKit.use((String)"system.properties");
        String url = this.systemProp.get("jdbc.acs.url");
        if (StrKit.isBlank((String)url)) {
            throw ServiceException.create((String)"\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6system.properties\u4e2d\u6dfb\u52a0jdbc.acs.url\u7684\u914d\u7f6e");
        }
        String userName = this.systemProp.get("jdbc.acs.username");
        if (StrKit.isBlank((String)userName)) {
            throw ServiceException.create((String)"\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6system.properties\u4e2d\u6dfb\u52a0jdbc.acs.username\u7684\u914d\u7f6e");
        }
        String password = this.systemProp.get("jdbc.acs.password");
        DruidPlugin dbPlugin = new DruidPlugin(url, userName, password).set(this.systemProp.getInt("jdbc.acs.initialSize").intValue(), this.systemProp.getInt("jdbc.acs.minIdle").intValue(), this.systemProp.getInt("jdbc.acs.maxActive").intValue());
        me.add((IPlugin)dbPlugin);
        me.add((IPlugin)new DbUtilsPlugin("db::acs", (DataSourceProvider)dbPlugin));
        url = this.systemProp.get("jdbc.ums.url");
        if (StrKit.isBlank((String)url)) {
            throw ServiceException.create((String)"\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6system.properties\u4e2d\u6dfb\u52a0jdbc.ums.url\u7684\u914d\u7f6e");
        }
        userName = this.systemProp.get("jdbc.ums.username");
        if (StrKit.isBlank((String)userName)) {
            throw ServiceException.create((String)"\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6system.properties\u4e2d\u6dfb\u52a0jdbc.ums.username\u7684\u914d\u7f6e");
        }
        password = this.systemProp.get("jdbc.ums.password");
        dbPlugin = new DruidPlugin(url, userName, password).set(this.systemProp.getInt("jdbc.ums.initialSize").intValue(), this.systemProp.getInt("jdbc.ums.minIdle").intValue(), this.systemProp.getInt("jdbc.ums.maxActive").intValue());
        me.add((IPlugin)dbPlugin);
        me.add((IPlugin)new DbUtilsPlugin("db::ums", (DataSourceProvider)dbPlugin));
        url = this.systemProp.get("jdbc.ras.url");
        if (StrKit.isBlank((String)url)) {
            throw ServiceException.create((String)"\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6system.properties\u4e2d\u6dfb\u52a0jdbc.ras.url\u7684\u914d\u7f6e");
        }
        userName = this.systemProp.get("jdbc.ras.username");
        if (StrKit.isBlank((String)userName)) {
            throw ServiceException.create((String)"\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6system.properties\u4e2d\u6dfb\u52a0jdbc.ras.username\u7684\u914d\u7f6e");
        }
        password = this.systemProp.get("jdbc.ras.password");
        dbPlugin = new DruidPlugin(url, userName, password).set(this.systemProp.getInt("jdbc.ras.initialSize").intValue(), this.systemProp.getInt("jdbc.ras.minIdle").intValue(), this.systemProp.getInt("jdbc.ras.maxActive").intValue());
        me.add((IPlugin)dbPlugin);
        me.add((IPlugin)new DbUtilsPlugin("RAS", (DataSourceProvider)dbPlugin));
        url = this.systemProp.get("jdbc.amscore.url");
        if (StrKit.isBlank((String)url)) {
            throw ServiceException.create((String)"\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6system.properties\u4e2d\u6dfb\u52a0jdbc.amscore.url\u7684\u914d\u7f6e");
        }
        userName = this.systemProp.get("jdbc.amscore.username");
        if (StrKit.isBlank((String)userName)) {
            throw ServiceException.create((String)"\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6system.properties\u4e2d\u6dfb\u52a0jdbc.amscore.username\u7684\u914d\u7f6e");
        }
        password = this.systemProp.get("jdbc.amscore.password");
        dbPlugin = new DruidPlugin(url, userName, password).set(this.systemProp.getInt("jdbc.amscore.initialSize").intValue(), this.systemProp.getInt("jdbc.amscore.minIdle").intValue(), this.systemProp.getInt("jdbc.amscore.maxActive").intValue());
        me.add((IPlugin)dbPlugin);
        me.add((IPlugin)new DbUtilsPlugin("db::amscore", (DataSourceProvider)dbPlugin));
        String[] configLocations = new String[]{"classpath*:/META-INF/spring/applicationContext-*.xml"};
        me.add((IPlugin)new SpringPlugin(configLocations));
    }

    public void afterStart() {
        String ip = this.systemProp.get("rpc.ip");
        int port = this.systemProp.getInt("rpc.port");
        int maxWorkThread = this.systemProp.getInt("rpc.maxWorkThread", Integer.valueOf(100));
        try {
            ProviderStarter.NETTY.setMaxWorkThread(maxWorkThread).start(ip, port);
            this.logger.info("====>\u4e91\u5e73\u53f0\u57fa\u7840\u670d\u52a1{}:{}\u542f\u52a8\u6210\u529f\uff0c\u6700\u5927\u5de5\u4f5c\u7ebf\u7a0b\u6570\u4e3a{}\u4e2a\uff01", new Object[]{ip, port, maxWorkThread});
        }
        catch (BindException e) {
            this.logger.error("\u670d\u52a1\u7ed1\u5b9a\u5f02\u5e38", (Object)e.getMessage());
        }
        catch (InterruptedException e) {
            this.logger.error("\u7ebf\u7a0b\u5f02\u5e38", (Object)e.getMessage());
        }
        String[] services = StringUtils.split((String)this.systemProp.get("rpc.services"), (String)"|");
        if (null != services && services.length > 0) {
            for (int i = 0; i < services.length; ++i) {
                String rpcIp = this.systemProp.get("rpc." + services[i] + ".ip");
                int rpcPort = this.systemProp.getInt("rpc." + services[i] + ".port");
                long rpcTimeoutMillis = this.systemProp.getLong("rpc." + services[i] + ".timeoutMillis");
                Service service = new Service();
                service.setAddr(rpcIp);
                service.setPort(rpcPort);
                service.setTimeoutMillis(rpcTimeoutMillis);
                ServicePool.addService((String)services[i], (IService)service);
                this.logger.info("====>\u5f00\u59cb\u521d\u59cb\u5316RPC\u5ba2\u6237\u7aef\u914d\u7f6e\uff0c{}\u670d\u52a1\u5730\u5740{}:{}", new Object[]{services[i], rpcIp, rpcPort});
            }
        }
        ServicePool.addLocalService((String[])new String[]{"acs"});
        String avatarPath = this.systemProp.get("avatarPath");
        if (StringUtils.isNotBlank((CharSequence)avatarPath)) {
            Constants.AVATAR_PATH = avatarPath;
        }
        Constants.SC_IP = this.systemProp.get("sc.ip");
        Constants.SC_PORT = this.systemProp.get("sc.port");
        Constants.SC_APP_ACCOUNT = this.systemProp.get("sc.app.username");
        Constants.SC_APP_PASSWORD = this.systemProp.get("sc.app.password");
        Constants.SC_APP_ID = this.systemProp.get("sc.app.identify");
        try {
            this.logger.info("\u5f00\u59cb\u521d\u59cb\u5316SC");
            String mqUrl = Constants.SC_IP + ":" + Constants.SC_PORT;
            MQSetting.init((String)Constants.SC_APP_ACCOUNT, (String)Constants.SC_APP_PASSWORD, (String)mqUrl, (String)Constants.SC_APP_ID);
            MQSetting.initChanel(Arrays.asList("assetFormat", "assetImport", "certChange"));
            MQSetting.setThreadSize((int)5);
            MQSetting.registAction((ReceivedAction)new ReceivedAction(){

                public void delivery(Msg msg, long deliveryTag, Channel channel, boolean autoAck) {
                    try {
                        CallbackFactory.getCallback((String)msg.type).process(msg);
                    }
                    catch (ServiceException e) {
                        Config.this.logger.error(e.getMessage());
                    }
                    catch (Exception e) {
                        Config.this.logger.error(String.format(" %s \u4e3b\u9898\u6d88\u8d39\u5931\u8d25", msg.type));
                        try {
                            channel.basicNack(deliveryTag, false, true);
                        }
                        catch (IOException e1) {
                            Config.this.logger.error(String.format("\u6d88\u8d39 %s\u4e3b\u9898\u5931\u8d25\uff0c\u66f4\u6539\u6d88\u606f\u72b6\u6001\u5931\u8d25", msg.type), (Throwable)e);
                        }
                        return;
                    }
                    if (!autoAck) {
                        try {
                            channel.basicAck(deliveryTag, true);
                        }
                        catch (IOException e) {
                            Config.this.logger.error(String.format("\u6d88\u8d39 %s\u4e3b\u9898\u5b8c\u6210\uff0c\u66f4\u6539\u6d88\u606f\u72b6\u6001\u5931\u8d25", msg.type), (Throwable)e);
                        }
                    }
                }
            });
            this.logger.info("SC\u521d\u59cb\u5316\u6210\u529f\uff01");
        }
        catch (Exception ex) {
            this.logger.error("SC\u521d\u59cb\u5316\u5931\u8d25,\u975e\u6b63\u5e38\u8fdb\u884c\u7a0b\u5e8f\u9000\u51fa\uff01", (Throwable)ex);
            System.exit(0);
        }
        AccountCache.init();
        InitMdmCache.loadCache();
        InitUserInfoCache.loadUserInfoCache();
        Prop configProp = PropKit.use((String)"config.properties");
        Constant.ACCOUNT_LENGTH = configProp.getInt("accountLength", Integer.valueOf(9));
        Constants.CERT_CA_ALG = configProp.getInt("cert.caAlg");
        Constants.CERT_TYPE = configProp.getInt("cert.type");
        try {
            this.logger.info("\u5f00\u59cb\u521d\u59cb\u5316\u4e1a\u52a1\u65e5\u5fd7\u7ec4\u4ef6\u670d\u52a1\u6807\u8bc6");
            LogSetting.setServerName((String)configProp.get("log.server.name"));
            this.logger.error("\u521d\u59cb\u5316\u4e1a\u52a1\u65e5\u5fd7\u7ec4\u4ef6\u670d\u52a1\u6807\u8bc6\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error("\u521d\u59cb\u5316\u4e1a\u52a1\u65e5\u5fd7\u7ec4\u4ef6\u670d\u52a1\u6807\u8bc6\u5931\u8d25", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        String rpcIp = "11.12.86.212";
        int rpcPort = 15844;
        int rpcTimeoutMillis = 5000;
        Service service = new Service();
        service.setAddr(rpcIp);
        service.setPort(rpcPort);
        service.setTimeoutMillis((long)rpcTimeoutMillis);
        ServicePool.addService((String)"acs", (IService)service);
        IAssetService assetService = (IAssetService)DefaultServiceRefer.getServiceRefer(IAssetService.class);
        ProductAsset productAsset1 = assetService.queryAssetByIdentity("1234567893");
        ProductAsset productAsset2 = assetService.queryAssetByCustomerInfo("TEST1", null);
        ProductAsset productAsset3 = assetService.queryAssetByCustomerInfo(null, "test123456");
        System.out.println("====================================");
        System.out.println(productAsset1.toString());
        System.out.println("------------------------------------");
        System.out.println(productAsset2.toString());
        System.out.println("------------------------------------");
        System.out.println(productAsset3.toString());
        System.out.println("------------------------------------");
    }
}

