package com.xdja.cssp.friend.im;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.alibaba.fastjson.JSON;
import com.xdja.cssp.im.client.ImSender;

/**
 * 调用im发送通知消息的线程
 * @author zhouyj
 *
 */
public class ImMsgThread implements Runnable {
	
	private Logger logger = LoggerFactory.getLogger(ImMsgThread.class);
	
	private String account;
	private FriendNoticeMsg friendNoticeMsg;
	
	public ImMsgThread(FriendNoticeMsg friendNoticeMsg) {
		this.friendNoticeMsg = friendNoticeMsg;
	}
	
	@Override
	public void run() {
		String content = JSON.toJSONString(friendNoticeMsg);
		logger.debug("send im message :{} !", content);
		ImSender.sendMsg(account, content);
	}

}
