package com.xdja.cssp.friend.pn;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xdja.cssp.account.service.IAccountQueryService;
import com.xdja.cssp.pn.client.PnClient;
import com.xdja.platform.common.lite.kit.prop.Prop;
import com.xdja.platform.common.lite.kit.prop.PropKit;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;

/**
 * 推送线程
 * @author zhouyj
 *
 */
public class PushSender implements Runnable {


	//新推送主题关键字 key
	private static final String NPS_TOPIC_KEY = "nps.topic.key";
	//新推送默认主题关键字
	private static final String DEFAULT_NPS_TOPIC_KEY = "atp_frd";
	//新推送主题关键字
	private static String TOPICKEY;
	//接受调用的推送功能ID产生的Id
	private long idGen;
	
	
	private Logger logger = LoggerFactory.getLogger(PushSender.class);
	private List<String> accounts;
	String content;
	private String excludePnToken;
	
	
	//账户服务
	private IAccountQueryService accountService = DefaultServiceRefer.getServiceRefer(IAccountQueryService.class);
	
	
	public PushSender(List<String> accounts, String content) {
		this.accounts = accounts;
		this.content = content;
		
	}
	
	public PushSender(List<String> accounts, String content, String excludePnToken,long idGen) {
		this.accounts = accounts;
		this.content = content;
		this.excludePnToken = excludePnToken;
		this.idGen = idGen;
	}

	@Override
	public void run() {
		try {
			String[] accountArr = new String[accounts.size()]; 
			accounts.toArray(accountArr);
			List<String> pnTokens = accountService.queryOnlinePnToken(accountArr);
			Prop configProp = PropKit.use("system.properties");
			List<String> pnTopics = new ArrayList<String>();
			if(TOPICKEY == null) {
				TOPICKEY = configProp.get(NPS_TOPIC_KEY, DEFAULT_NPS_TOPIC_KEY);
			}
			
			for(String pnStr : pnTokens) {
				if(StringUtils.isNotBlank(excludePnToken) && pnStr.contains(excludePnToken)) {
					continue;
				}
				pnTopics.add(pnStr + TOPICKEY);
			}
			
			PnClient.sendMsg(content, pnTopics, PnClient.SEND_MODE_DIRECT, null, null,idGen);
			logger.info("Invoke pn to send {} notice success,  pnTokens:{}", content, pnTopics);
		} catch (Exception e) {
			logger.error("Invoke PnService to send {} failure, account:{}", content, accounts);
			logger.error("Invoke PnService error", e);
		}
		
	}
	
}
