package com.xdja.cssp.group.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 添加群成员结果
 * @author zhouyj
 *
 */
public class AddMembersResult implements Serializable {
	
	private static final long serialVersionUID = 1L;

	/**
	 * 添加群成员结果，成功
	 */
	public static int RET_SUCCESS = 0;

	/**
	 * 添加群成员结果，全失败
	 */
	public static int RET_ALL_FAIL = -1;
	
	/**
	 * 添加群成员结果,因群成员数量超限而失败
	 */
	public static int RET_FAIl_GROUP_MEMBER_EXCESS = -2;
	
	

	/**
	 * 添加群成员结果，部分成功
	 */
	public static int RET_PARTIAL_SUCCESS = -3;

	/**
	 * 群成员所在群数量超限
	 */
	public static int GROUP_MEMBER_EXCEED = -1;

	/**
	 * 群成员已存在
	 */
	public static int GROUP_MEMBER_ALREADY_EXIST = -2;
	
	//创建结果 0-成功，1-部分成功
	private int retFlag;
	
	//失败的账号信息，使用key来标识失败原因，使用value值来标记某种原因失败的账号列表
	private Map<Integer, List<String>> errMap;
	
	//成功入群账号
	private List<String> suceessAccounts = new ArrayList<String>();

	public int getRetFlag() {
		return retFlag;
	}
	public void setRetFlag(int retFlag) {
		this.retFlag = retFlag;
	}
	public Map<Integer, List<String>> getErrMap() {
		return errMap;
	}
	public void setErrMap(Map<Integer, List<String>> errMap) {
		this.errMap = errMap;
	}
	public List<String> getSuceessAccounts() {
		return suceessAccounts;
	}
	public void setSuceessAccounts(List<String> suceessAccounts) {
		this.suceessAccounts = suceessAccounts;
	}
	
	
	
	
}
